/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan.video;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.video.StdVideoEncodeH264ReferenceInfoFlags;

public class StdVideoEncodeH264ReferenceInfo
extends Struct<StdVideoEncodeH264ReferenceInfo>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int FLAGS;
    public static final int PRIMARY_PIC_TYPE;
    public static final int FRAMENUM;
    public static final int PICORDERCNT;
    public static final int LONG_TERM_PIC_NUM;
    public static final int LONG_TERM_FRAME_IDX;
    public static final int TEMPORAL_ID;

    protected StdVideoEncodeH264ReferenceInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected StdVideoEncodeH264ReferenceInfo create(long address, @Nullable ByteBuffer container) {
        return new StdVideoEncodeH264ReferenceInfo(address, container);
    }

    public StdVideoEncodeH264ReferenceInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), StdVideoEncodeH264ReferenceInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public StdVideoEncodeH264ReferenceInfoFlags flags() {
        return StdVideoEncodeH264ReferenceInfo.nflags(this.address());
    }

    @NativeType(value="StdVideoH264PictureType")
    public int primary_pic_type() {
        return StdVideoEncodeH264ReferenceInfo.nprimary_pic_type(this.address());
    }

    @NativeType(value="uint32_t")
    public int FrameNum() {
        return StdVideoEncodeH264ReferenceInfo.nFrameNum(this.address());
    }

    @NativeType(value="int32_t")
    public int PicOrderCnt() {
        return StdVideoEncodeH264ReferenceInfo.nPicOrderCnt(this.address());
    }

    @NativeType(value="uint16_t")
    public short long_term_pic_num() {
        return StdVideoEncodeH264ReferenceInfo.nlong_term_pic_num(this.address());
    }

    @NativeType(value="uint16_t")
    public short long_term_frame_idx() {
        return StdVideoEncodeH264ReferenceInfo.nlong_term_frame_idx(this.address());
    }

    @NativeType(value="uint8_t")
    public byte temporal_id() {
        return StdVideoEncodeH264ReferenceInfo.ntemporal_id(this.address());
    }

    public StdVideoEncodeH264ReferenceInfo flags(StdVideoEncodeH264ReferenceInfoFlags value) {
        StdVideoEncodeH264ReferenceInfo.nflags(this.address(), value);
        return this;
    }

    public StdVideoEncodeH264ReferenceInfo flags(Consumer<StdVideoEncodeH264ReferenceInfoFlags> consumer) {
        consumer.accept(this.flags());
        return this;
    }

    public StdVideoEncodeH264ReferenceInfo primary_pic_type(@NativeType(value="StdVideoH264PictureType") int value) {
        StdVideoEncodeH264ReferenceInfo.nprimary_pic_type(this.address(), value);
        return this;
    }

    public StdVideoEncodeH264ReferenceInfo FrameNum(@NativeType(value="uint32_t") int value) {
        StdVideoEncodeH264ReferenceInfo.nFrameNum(this.address(), value);
        return this;
    }

    public StdVideoEncodeH264ReferenceInfo PicOrderCnt(@NativeType(value="int32_t") int value) {
        StdVideoEncodeH264ReferenceInfo.nPicOrderCnt(this.address(), value);
        return this;
    }

    public StdVideoEncodeH264ReferenceInfo long_term_pic_num(@NativeType(value="uint16_t") short value) {
        StdVideoEncodeH264ReferenceInfo.nlong_term_pic_num(this.address(), value);
        return this;
    }

    public StdVideoEncodeH264ReferenceInfo long_term_frame_idx(@NativeType(value="uint16_t") short value) {
        StdVideoEncodeH264ReferenceInfo.nlong_term_frame_idx(this.address(), value);
        return this;
    }

    public StdVideoEncodeH264ReferenceInfo temporal_id(@NativeType(value="uint8_t") byte value) {
        StdVideoEncodeH264ReferenceInfo.ntemporal_id(this.address(), value);
        return this;
    }

    public StdVideoEncodeH264ReferenceInfo set(StdVideoEncodeH264ReferenceInfoFlags flags, int primary_pic_type, int FrameNum, int PicOrderCnt, short long_term_pic_num, short long_term_frame_idx, byte temporal_id) {
        this.flags(flags);
        this.primary_pic_type(primary_pic_type);
        this.FrameNum(FrameNum);
        this.PicOrderCnt(PicOrderCnt);
        this.long_term_pic_num(long_term_pic_num);
        this.long_term_frame_idx(long_term_frame_idx);
        this.temporal_id(temporal_id);
        return this;
    }

    public StdVideoEncodeH264ReferenceInfo set(StdVideoEncodeH264ReferenceInfo src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static StdVideoEncodeH264ReferenceInfo malloc() {
        return new StdVideoEncodeH264ReferenceInfo(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static StdVideoEncodeH264ReferenceInfo calloc() {
        return new StdVideoEncodeH264ReferenceInfo(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static StdVideoEncodeH264ReferenceInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new StdVideoEncodeH264ReferenceInfo(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static StdVideoEncodeH264ReferenceInfo create(long address) {
        return new StdVideoEncodeH264ReferenceInfo(address, null);
    }

    @Nullable
    public static StdVideoEncodeH264ReferenceInfo createSafe(long address) {
        return address == 0L ? null : new StdVideoEncodeH264ReferenceInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)StdVideoEncodeH264ReferenceInfo.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = StdVideoEncodeH264ReferenceInfo.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static StdVideoEncodeH264ReferenceInfo malloc(MemoryStack stack) {
        return new StdVideoEncodeH264ReferenceInfo(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static StdVideoEncodeH264ReferenceInfo calloc(MemoryStack stack) {
        return new StdVideoEncodeH264ReferenceInfo(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static StdVideoEncodeH264ReferenceInfoFlags nflags(long struct) {
        return StdVideoEncodeH264ReferenceInfoFlags.create(struct + (long)FLAGS);
    }

    public static int nprimary_pic_type(long struct) {
        return UNSAFE.getInt(null, struct + (long)PRIMARY_PIC_TYPE);
    }

    public static int nFrameNum(long struct) {
        return UNSAFE.getInt(null, struct + (long)FRAMENUM);
    }

    public static int nPicOrderCnt(long struct) {
        return UNSAFE.getInt(null, struct + (long)PICORDERCNT);
    }

    public static short nlong_term_pic_num(long struct) {
        return UNSAFE.getShort(null, struct + (long)LONG_TERM_PIC_NUM);
    }

    public static short nlong_term_frame_idx(long struct) {
        return UNSAFE.getShort(null, struct + (long)LONG_TERM_FRAME_IDX);
    }

    public static byte ntemporal_id(long struct) {
        return UNSAFE.getByte(null, struct + (long)TEMPORAL_ID);
    }

    public static void nflags(long struct, StdVideoEncodeH264ReferenceInfoFlags value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)FLAGS), (long)StdVideoEncodeH264ReferenceInfoFlags.SIZEOF);
    }

    public static void nprimary_pic_type(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)PRIMARY_PIC_TYPE, value);
    }

    public static void nFrameNum(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FRAMENUM, value);
    }

    public static void nPicOrderCnt(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)PICORDERCNT, value);
    }

    public static void nlong_term_pic_num(long struct, short value) {
        UNSAFE.putShort(null, struct + (long)LONG_TERM_PIC_NUM, value);
    }

    public static void nlong_term_frame_idx(long struct, short value) {
        UNSAFE.putShort(null, struct + (long)LONG_TERM_FRAME_IDX, value);
    }

    public static void ntemporal_id(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)TEMPORAL_ID, value);
    }

    static {
        Struct.Layout layout = StdVideoEncodeH264ReferenceInfo.__struct((Struct.Member[])new Struct.Member[]{StdVideoEncodeH264ReferenceInfo.__member((int)StdVideoEncodeH264ReferenceInfoFlags.SIZEOF, (int)StdVideoEncodeH264ReferenceInfoFlags.ALIGNOF), StdVideoEncodeH264ReferenceInfo.__member((int)4), StdVideoEncodeH264ReferenceInfo.__member((int)4), StdVideoEncodeH264ReferenceInfo.__member((int)4), StdVideoEncodeH264ReferenceInfo.__member((int)2), StdVideoEncodeH264ReferenceInfo.__member((int)2), StdVideoEncodeH264ReferenceInfo.__member((int)1)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        FLAGS = layout.offsetof(0);
        PRIMARY_PIC_TYPE = layout.offsetof(1);
        FRAMENUM = layout.offsetof(2);
        PICORDERCNT = layout.offsetof(3);
        LONG_TERM_PIC_NUM = layout.offsetof(4);
        LONG_TERM_FRAME_IDX = layout.offsetof(5);
        TEMPORAL_ID = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<StdVideoEncodeH264ReferenceInfo, Buffer>
    implements NativeResource {
        private static final StdVideoEncodeH264ReferenceInfo ELEMENT_FACTORY = StdVideoEncodeH264ReferenceInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected StdVideoEncodeH264ReferenceInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public StdVideoEncodeH264ReferenceInfoFlags flags() {
            return StdVideoEncodeH264ReferenceInfo.nflags(this.address());
        }

        @NativeType(value="StdVideoH264PictureType")
        public int primary_pic_type() {
            return StdVideoEncodeH264ReferenceInfo.nprimary_pic_type(this.address());
        }

        @NativeType(value="uint32_t")
        public int FrameNum() {
            return StdVideoEncodeH264ReferenceInfo.nFrameNum(this.address());
        }

        @NativeType(value="int32_t")
        public int PicOrderCnt() {
            return StdVideoEncodeH264ReferenceInfo.nPicOrderCnt(this.address());
        }

        @NativeType(value="uint16_t")
        public short long_term_pic_num() {
            return StdVideoEncodeH264ReferenceInfo.nlong_term_pic_num(this.address());
        }

        @NativeType(value="uint16_t")
        public short long_term_frame_idx() {
            return StdVideoEncodeH264ReferenceInfo.nlong_term_frame_idx(this.address());
        }

        @NativeType(value="uint8_t")
        public byte temporal_id() {
            return StdVideoEncodeH264ReferenceInfo.ntemporal_id(this.address());
        }

        public Buffer flags(StdVideoEncodeH264ReferenceInfoFlags value) {
            StdVideoEncodeH264ReferenceInfo.nflags(this.address(), value);
            return this;
        }

        public Buffer flags(Consumer<StdVideoEncodeH264ReferenceInfoFlags> consumer) {
            consumer.accept(this.flags());
            return this;
        }

        public Buffer primary_pic_type(@NativeType(value="StdVideoH264PictureType") int value) {
            StdVideoEncodeH264ReferenceInfo.nprimary_pic_type(this.address(), value);
            return this;
        }

        public Buffer FrameNum(@NativeType(value="uint32_t") int value) {
            StdVideoEncodeH264ReferenceInfo.nFrameNum(this.address(), value);
            return this;
        }

        public Buffer PicOrderCnt(@NativeType(value="int32_t") int value) {
            StdVideoEncodeH264ReferenceInfo.nPicOrderCnt(this.address(), value);
            return this;
        }

        public Buffer long_term_pic_num(@NativeType(value="uint16_t") short value) {
            StdVideoEncodeH264ReferenceInfo.nlong_term_pic_num(this.address(), value);
            return this;
        }

        public Buffer long_term_frame_idx(@NativeType(value="uint16_t") short value) {
            StdVideoEncodeH264ReferenceInfo.nlong_term_frame_idx(this.address(), value);
            return this;
        }

        public Buffer temporal_id(@NativeType(value="uint8_t") byte value) {
            StdVideoEncodeH264ReferenceInfo.ntemporal_id(this.address(), value);
            return this;
        }
    }
}

