/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan.video;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.video.StdVideoEncodeH264PictureInfoFlags;
import org.lwjgl.vulkan.video.StdVideoEncodeH264ReferenceListsInfo;

public class StdVideoEncodeH264PictureInfo
extends Struct<StdVideoEncodeH264PictureInfo>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int FLAGS;
    public static final int SEQ_PARAMETER_SET_ID;
    public static final int PIC_PARAMETER_SET_ID;
    public static final int IDR_PIC_ID;
    public static final int PRIMARY_PIC_TYPE;
    public static final int FRAME_NUM;
    public static final int PICORDERCNT;
    public static final int TEMPORAL_ID;
    public static final int RESERVED1;
    public static final int PREFLISTS;

    protected StdVideoEncodeH264PictureInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected StdVideoEncodeH264PictureInfo create(long address, @Nullable ByteBuffer container) {
        return new StdVideoEncodeH264PictureInfo(address, container);
    }

    public StdVideoEncodeH264PictureInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), StdVideoEncodeH264PictureInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public StdVideoEncodeH264PictureInfoFlags flags() {
        return StdVideoEncodeH264PictureInfo.nflags(this.address());
    }

    @NativeType(value="uint8_t")
    public byte seq_parameter_set_id() {
        return StdVideoEncodeH264PictureInfo.nseq_parameter_set_id(this.address());
    }

    @NativeType(value="uint8_t")
    public byte pic_parameter_set_id() {
        return StdVideoEncodeH264PictureInfo.npic_parameter_set_id(this.address());
    }

    @NativeType(value="uint16_t")
    public short idr_pic_id() {
        return StdVideoEncodeH264PictureInfo.nidr_pic_id(this.address());
    }

    @NativeType(value="StdVideoH264PictureType")
    public int primary_pic_type() {
        return StdVideoEncodeH264PictureInfo.nprimary_pic_type(this.address());
    }

    @NativeType(value="uint32_t")
    public int frame_num() {
        return StdVideoEncodeH264PictureInfo.nframe_num(this.address());
    }

    @NativeType(value="int32_t")
    public int PicOrderCnt() {
        return StdVideoEncodeH264PictureInfo.nPicOrderCnt(this.address());
    }

    @NativeType(value="uint8_t")
    public byte temporal_id() {
        return StdVideoEncodeH264PictureInfo.ntemporal_id(this.address());
    }

    @NativeType(value="StdVideoEncodeH264ReferenceListsInfo const *")
    public StdVideoEncodeH264ReferenceListsInfo pRefLists() {
        return StdVideoEncodeH264PictureInfo.npRefLists(this.address());
    }

    public StdVideoEncodeH264PictureInfo flags(StdVideoEncodeH264PictureInfoFlags value) {
        StdVideoEncodeH264PictureInfo.nflags(this.address(), value);
        return this;
    }

    public StdVideoEncodeH264PictureInfo flags(Consumer<StdVideoEncodeH264PictureInfoFlags> consumer) {
        consumer.accept(this.flags());
        return this;
    }

    public StdVideoEncodeH264PictureInfo seq_parameter_set_id(@NativeType(value="uint8_t") byte value) {
        StdVideoEncodeH264PictureInfo.nseq_parameter_set_id(this.address(), value);
        return this;
    }

    public StdVideoEncodeH264PictureInfo pic_parameter_set_id(@NativeType(value="uint8_t") byte value) {
        StdVideoEncodeH264PictureInfo.npic_parameter_set_id(this.address(), value);
        return this;
    }

    public StdVideoEncodeH264PictureInfo idr_pic_id(@NativeType(value="uint16_t") short value) {
        StdVideoEncodeH264PictureInfo.nidr_pic_id(this.address(), value);
        return this;
    }

    public StdVideoEncodeH264PictureInfo primary_pic_type(@NativeType(value="StdVideoH264PictureType") int value) {
        StdVideoEncodeH264PictureInfo.nprimary_pic_type(this.address(), value);
        return this;
    }

    public StdVideoEncodeH264PictureInfo frame_num(@NativeType(value="uint32_t") int value) {
        StdVideoEncodeH264PictureInfo.nframe_num(this.address(), value);
        return this;
    }

    public StdVideoEncodeH264PictureInfo PicOrderCnt(@NativeType(value="int32_t") int value) {
        StdVideoEncodeH264PictureInfo.nPicOrderCnt(this.address(), value);
        return this;
    }

    public StdVideoEncodeH264PictureInfo temporal_id(@NativeType(value="uint8_t") byte value) {
        StdVideoEncodeH264PictureInfo.ntemporal_id(this.address(), value);
        return this;
    }

    public StdVideoEncodeH264PictureInfo pRefLists(@NativeType(value="StdVideoEncodeH264ReferenceListsInfo const *") StdVideoEncodeH264ReferenceListsInfo value) {
        StdVideoEncodeH264PictureInfo.npRefLists(this.address(), value);
        return this;
    }

    public StdVideoEncodeH264PictureInfo set(StdVideoEncodeH264PictureInfoFlags flags, byte seq_parameter_set_id, byte pic_parameter_set_id, short idr_pic_id, int primary_pic_type, int frame_num, int PicOrderCnt, byte temporal_id, StdVideoEncodeH264ReferenceListsInfo pRefLists) {
        this.flags(flags);
        this.seq_parameter_set_id(seq_parameter_set_id);
        this.pic_parameter_set_id(pic_parameter_set_id);
        this.idr_pic_id(idr_pic_id);
        this.primary_pic_type(primary_pic_type);
        this.frame_num(frame_num);
        this.PicOrderCnt(PicOrderCnt);
        this.temporal_id(temporal_id);
        this.pRefLists(pRefLists);
        return this;
    }

    public StdVideoEncodeH264PictureInfo set(StdVideoEncodeH264PictureInfo src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static StdVideoEncodeH264PictureInfo malloc() {
        return new StdVideoEncodeH264PictureInfo(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static StdVideoEncodeH264PictureInfo calloc() {
        return new StdVideoEncodeH264PictureInfo(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static StdVideoEncodeH264PictureInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new StdVideoEncodeH264PictureInfo(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static StdVideoEncodeH264PictureInfo create(long address) {
        return new StdVideoEncodeH264PictureInfo(address, null);
    }

    @Nullable
    public static StdVideoEncodeH264PictureInfo createSafe(long address) {
        return address == 0L ? null : new StdVideoEncodeH264PictureInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)StdVideoEncodeH264PictureInfo.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = StdVideoEncodeH264PictureInfo.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static StdVideoEncodeH264PictureInfo malloc(MemoryStack stack) {
        return new StdVideoEncodeH264PictureInfo(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static StdVideoEncodeH264PictureInfo calloc(MemoryStack stack) {
        return new StdVideoEncodeH264PictureInfo(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static StdVideoEncodeH264PictureInfoFlags nflags(long struct) {
        return StdVideoEncodeH264PictureInfoFlags.create(struct + (long)FLAGS);
    }

    public static byte nseq_parameter_set_id(long struct) {
        return UNSAFE.getByte(null, struct + (long)SEQ_PARAMETER_SET_ID);
    }

    public static byte npic_parameter_set_id(long struct) {
        return UNSAFE.getByte(null, struct + (long)PIC_PARAMETER_SET_ID);
    }

    public static short nidr_pic_id(long struct) {
        return UNSAFE.getShort(null, struct + (long)IDR_PIC_ID);
    }

    public static int nprimary_pic_type(long struct) {
        return UNSAFE.getInt(null, struct + (long)PRIMARY_PIC_TYPE);
    }

    public static int nframe_num(long struct) {
        return UNSAFE.getInt(null, struct + (long)FRAME_NUM);
    }

    public static int nPicOrderCnt(long struct) {
        return UNSAFE.getInt(null, struct + (long)PICORDERCNT);
    }

    public static byte ntemporal_id(long struct) {
        return UNSAFE.getByte(null, struct + (long)TEMPORAL_ID);
    }

    public static ByteBuffer nreserved1(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)RESERVED1), (int)3);
    }

    public static byte nreserved1(long struct, int index) {
        return UNSAFE.getByte(null, struct + (long)RESERVED1 + Checks.check((int)index, (int)3) * 1L);
    }

    public static StdVideoEncodeH264ReferenceListsInfo npRefLists(long struct) {
        return StdVideoEncodeH264ReferenceListsInfo.create(MemoryUtil.memGetAddress((long)(struct + (long)PREFLISTS)));
    }

    public static void nflags(long struct, StdVideoEncodeH264PictureInfoFlags value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)FLAGS), (long)StdVideoEncodeH264PictureInfoFlags.SIZEOF);
    }

    public static void nseq_parameter_set_id(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)SEQ_PARAMETER_SET_ID, value);
    }

    public static void npic_parameter_set_id(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)PIC_PARAMETER_SET_ID, value);
    }

    public static void nidr_pic_id(long struct, short value) {
        UNSAFE.putShort(null, struct + (long)IDR_PIC_ID, value);
    }

    public static void nprimary_pic_type(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)PRIMARY_PIC_TYPE, value);
    }

    public static void nframe_num(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FRAME_NUM, value);
    }

    public static void nPicOrderCnt(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)PICORDERCNT, value);
    }

    public static void ntemporal_id(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)TEMPORAL_ID, value);
    }

    public static void nreserved1(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((java.nio.Buffer)value, (int)3);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((ByteBuffer)value), (long)(struct + (long)RESERVED1), (long)(value.remaining() * 1));
    }

    public static void nreserved1(long struct, int index, byte value) {
        UNSAFE.putByte(null, struct + (long)RESERVED1 + Checks.check((int)index, (int)3) * 1L, value);
    }

    public static void npRefLists(long struct, StdVideoEncodeH264ReferenceListsInfo value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PREFLISTS), (long)value.address());
    }

    public static void validate(long struct) {
        long pRefLists = MemoryUtil.memGetAddress((long)(struct + (long)PREFLISTS));
        Checks.check((long)pRefLists);
        StdVideoEncodeH264ReferenceListsInfo.validate(pRefLists);
    }

    static {
        Struct.Layout layout = StdVideoEncodeH264PictureInfo.__struct((Struct.Member[])new Struct.Member[]{StdVideoEncodeH264PictureInfo.__member((int)StdVideoEncodeH264PictureInfoFlags.SIZEOF, (int)StdVideoEncodeH264PictureInfoFlags.ALIGNOF), StdVideoEncodeH264PictureInfo.__member((int)1), StdVideoEncodeH264PictureInfo.__member((int)1), StdVideoEncodeH264PictureInfo.__member((int)2), StdVideoEncodeH264PictureInfo.__member((int)4), StdVideoEncodeH264PictureInfo.__member((int)4), StdVideoEncodeH264PictureInfo.__member((int)4), StdVideoEncodeH264PictureInfo.__member((int)1), StdVideoEncodeH264PictureInfo.__array((int)1, (int)3), StdVideoEncodeH264PictureInfo.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        FLAGS = layout.offsetof(0);
        SEQ_PARAMETER_SET_ID = layout.offsetof(1);
        PIC_PARAMETER_SET_ID = layout.offsetof(2);
        IDR_PIC_ID = layout.offsetof(3);
        PRIMARY_PIC_TYPE = layout.offsetof(4);
        FRAME_NUM = layout.offsetof(5);
        PICORDERCNT = layout.offsetof(6);
        TEMPORAL_ID = layout.offsetof(7);
        RESERVED1 = layout.offsetof(8);
        PREFLISTS = layout.offsetof(9);
    }

    public static class Buffer
    extends StructBuffer<StdVideoEncodeH264PictureInfo, Buffer>
    implements NativeResource {
        private static final StdVideoEncodeH264PictureInfo ELEMENT_FACTORY = StdVideoEncodeH264PictureInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected StdVideoEncodeH264PictureInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public StdVideoEncodeH264PictureInfoFlags flags() {
            return StdVideoEncodeH264PictureInfo.nflags(this.address());
        }

        @NativeType(value="uint8_t")
        public byte seq_parameter_set_id() {
            return StdVideoEncodeH264PictureInfo.nseq_parameter_set_id(this.address());
        }

        @NativeType(value="uint8_t")
        public byte pic_parameter_set_id() {
            return StdVideoEncodeH264PictureInfo.npic_parameter_set_id(this.address());
        }

        @NativeType(value="uint16_t")
        public short idr_pic_id() {
            return StdVideoEncodeH264PictureInfo.nidr_pic_id(this.address());
        }

        @NativeType(value="StdVideoH264PictureType")
        public int primary_pic_type() {
            return StdVideoEncodeH264PictureInfo.nprimary_pic_type(this.address());
        }

        @NativeType(value="uint32_t")
        public int frame_num() {
            return StdVideoEncodeH264PictureInfo.nframe_num(this.address());
        }

        @NativeType(value="int32_t")
        public int PicOrderCnt() {
            return StdVideoEncodeH264PictureInfo.nPicOrderCnt(this.address());
        }

        @NativeType(value="uint8_t")
        public byte temporal_id() {
            return StdVideoEncodeH264PictureInfo.ntemporal_id(this.address());
        }

        @NativeType(value="StdVideoEncodeH264ReferenceListsInfo const *")
        public StdVideoEncodeH264ReferenceListsInfo pRefLists() {
            return StdVideoEncodeH264PictureInfo.npRefLists(this.address());
        }

        public Buffer flags(StdVideoEncodeH264PictureInfoFlags value) {
            StdVideoEncodeH264PictureInfo.nflags(this.address(), value);
            return this;
        }

        public Buffer flags(Consumer<StdVideoEncodeH264PictureInfoFlags> consumer) {
            consumer.accept(this.flags());
            return this;
        }

        public Buffer seq_parameter_set_id(@NativeType(value="uint8_t") byte value) {
            StdVideoEncodeH264PictureInfo.nseq_parameter_set_id(this.address(), value);
            return this;
        }

        public Buffer pic_parameter_set_id(@NativeType(value="uint8_t") byte value) {
            StdVideoEncodeH264PictureInfo.npic_parameter_set_id(this.address(), value);
            return this;
        }

        public Buffer idr_pic_id(@NativeType(value="uint16_t") short value) {
            StdVideoEncodeH264PictureInfo.nidr_pic_id(this.address(), value);
            return this;
        }

        public Buffer primary_pic_type(@NativeType(value="StdVideoH264PictureType") int value) {
            StdVideoEncodeH264PictureInfo.nprimary_pic_type(this.address(), value);
            return this;
        }

        public Buffer frame_num(@NativeType(value="uint32_t") int value) {
            StdVideoEncodeH264PictureInfo.nframe_num(this.address(), value);
            return this;
        }

        public Buffer PicOrderCnt(@NativeType(value="int32_t") int value) {
            StdVideoEncodeH264PictureInfo.nPicOrderCnt(this.address(), value);
            return this;
        }

        public Buffer temporal_id(@NativeType(value="uint8_t") byte value) {
            StdVideoEncodeH264PictureInfo.ntemporal_id(this.address(), value);
            return this;
        }

        public Buffer pRefLists(@NativeType(value="StdVideoEncodeH264ReferenceListsInfo const *") StdVideoEncodeH264ReferenceListsInfo value) {
            StdVideoEncodeH264PictureInfo.npRefLists(this.address(), value);
            return this;
        }
    }
}

