/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkAttachmentReference2;
import org.lwjgl.vulkan.VkFragmentShadingRateAttachmentInfoKHR;
import org.lwjgl.vulkan.VkMultisampledRenderToSingleSampledInfoEXT;
import org.lwjgl.vulkan.VkRenderPassCreationControlEXT;
import org.lwjgl.vulkan.VkRenderPassSubpassFeedbackCreateInfoEXT;
import org.lwjgl.vulkan.VkSubpassDescriptionDepthStencilResolve;
import org.lwjgl.vulkan.VkSubpassDescriptionDepthStencilResolveKHR;

public class VkSubpassDescription2
extends Struct<VkSubpassDescription2>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int PIPELINEBINDPOINT;
    public static final int VIEWMASK;
    public static final int INPUTATTACHMENTCOUNT;
    public static final int PINPUTATTACHMENTS;
    public static final int COLORATTACHMENTCOUNT;
    public static final int PCOLORATTACHMENTS;
    public static final int PRESOLVEATTACHMENTS;
    public static final int PDEPTHSTENCILATTACHMENT;
    public static final int PRESERVEATTACHMENTCOUNT;
    public static final int PPRESERVEATTACHMENTS;

    protected VkSubpassDescription2(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkSubpassDescription2 create(long address, @Nullable ByteBuffer container) {
        return new VkSubpassDescription2(address, container);
    }

    public VkSubpassDescription2(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkSubpassDescription2.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkSubpassDescription2.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkSubpassDescription2.npNext(this.address());
    }

    @NativeType(value="VkSubpassDescriptionFlags")
    public int flags() {
        return VkSubpassDescription2.nflags(this.address());
    }

    @NativeType(value="VkPipelineBindPoint")
    public int pipelineBindPoint() {
        return VkSubpassDescription2.npipelineBindPoint(this.address());
    }

    @NativeType(value="uint32_t")
    public int viewMask() {
        return VkSubpassDescription2.nviewMask(this.address());
    }

    @NativeType(value="uint32_t")
    public int inputAttachmentCount() {
        return VkSubpassDescription2.ninputAttachmentCount(this.address());
    }

    @Nullable
    @NativeType(value="VkAttachmentReference2 const *")
    public VkAttachmentReference2.Buffer pInputAttachments() {
        return VkSubpassDescription2.npInputAttachments(this.address());
    }

    @NativeType(value="uint32_t")
    public int colorAttachmentCount() {
        return VkSubpassDescription2.ncolorAttachmentCount(this.address());
    }

    @Nullable
    @NativeType(value="VkAttachmentReference2 const *")
    public VkAttachmentReference2.Buffer pColorAttachments() {
        return VkSubpassDescription2.npColorAttachments(this.address());
    }

    @Nullable
    @NativeType(value="VkAttachmentReference2 const *")
    public VkAttachmentReference2.Buffer pResolveAttachments() {
        return VkSubpassDescription2.npResolveAttachments(this.address());
    }

    @Nullable
    @NativeType(value="VkAttachmentReference2 const *")
    public VkAttachmentReference2 pDepthStencilAttachment() {
        return VkSubpassDescription2.npDepthStencilAttachment(this.address());
    }

    @NativeType(value="uint32_t")
    public int preserveAttachmentCount() {
        return VkSubpassDescription2.npreserveAttachmentCount(this.address());
    }

    @Nullable
    @NativeType(value="uint32_t const *")
    public IntBuffer pPreserveAttachments() {
        return VkSubpassDescription2.npPreserveAttachments(this.address());
    }

    public VkSubpassDescription2 sType(@NativeType(value="VkStructureType") int value) {
        VkSubpassDescription2.nsType(this.address(), value);
        return this;
    }

    public VkSubpassDescription2 sType$Default() {
        return this.sType(1000109002);
    }

    public VkSubpassDescription2 pNext(@NativeType(value="void const *") long value) {
        VkSubpassDescription2.npNext(this.address(), value);
        return this;
    }

    public VkSubpassDescription2 pNext(VkFragmentShadingRateAttachmentInfoKHR value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkSubpassDescription2 pNext(VkMultisampledRenderToSingleSampledInfoEXT value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkSubpassDescription2 pNext(VkRenderPassCreationControlEXT value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkSubpassDescription2 pNext(VkRenderPassSubpassFeedbackCreateInfoEXT value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkSubpassDescription2 pNext(VkSubpassDescriptionDepthStencilResolve value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkSubpassDescription2 pNext(VkSubpassDescriptionDepthStencilResolveKHR value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkSubpassDescription2 flags(@NativeType(value="VkSubpassDescriptionFlags") int value) {
        VkSubpassDescription2.nflags(this.address(), value);
        return this;
    }

    public VkSubpassDescription2 pipelineBindPoint(@NativeType(value="VkPipelineBindPoint") int value) {
        VkSubpassDescription2.npipelineBindPoint(this.address(), value);
        return this;
    }

    public VkSubpassDescription2 viewMask(@NativeType(value="uint32_t") int value) {
        VkSubpassDescription2.nviewMask(this.address(), value);
        return this;
    }

    public VkSubpassDescription2 pInputAttachments(@Nullable @NativeType(value="VkAttachmentReference2 const *") VkAttachmentReference2.Buffer value) {
        VkSubpassDescription2.npInputAttachments(this.address(), value);
        return this;
    }

    public VkSubpassDescription2 colorAttachmentCount(@NativeType(value="uint32_t") int value) {
        VkSubpassDescription2.ncolorAttachmentCount(this.address(), value);
        return this;
    }

    public VkSubpassDescription2 pColorAttachments(@Nullable @NativeType(value="VkAttachmentReference2 const *") VkAttachmentReference2.Buffer value) {
        VkSubpassDescription2.npColorAttachments(this.address(), value);
        return this;
    }

    public VkSubpassDescription2 pResolveAttachments(@Nullable @NativeType(value="VkAttachmentReference2 const *") VkAttachmentReference2.Buffer value) {
        VkSubpassDescription2.npResolveAttachments(this.address(), value);
        return this;
    }

    public VkSubpassDescription2 pDepthStencilAttachment(@Nullable @NativeType(value="VkAttachmentReference2 const *") VkAttachmentReference2 value) {
        VkSubpassDescription2.npDepthStencilAttachment(this.address(), value);
        return this;
    }

    public VkSubpassDescription2 pPreserveAttachments(@Nullable @NativeType(value="uint32_t const *") IntBuffer value) {
        VkSubpassDescription2.npPreserveAttachments(this.address(), value);
        return this;
    }

    public VkSubpassDescription2 set(int sType, long pNext, int flags, int pipelineBindPoint, int viewMask, @Nullable VkAttachmentReference2.Buffer pInputAttachments, int colorAttachmentCount, @Nullable VkAttachmentReference2.Buffer pColorAttachments, @Nullable VkAttachmentReference2.Buffer pResolveAttachments, @Nullable VkAttachmentReference2 pDepthStencilAttachment, @Nullable IntBuffer pPreserveAttachments) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.pipelineBindPoint(pipelineBindPoint);
        this.viewMask(viewMask);
        this.pInputAttachments(pInputAttachments);
        this.colorAttachmentCount(colorAttachmentCount);
        this.pColorAttachments(pColorAttachments);
        this.pResolveAttachments(pResolveAttachments);
        this.pDepthStencilAttachment(pDepthStencilAttachment);
        this.pPreserveAttachments(pPreserveAttachments);
        return this;
    }

    public VkSubpassDescription2 set(VkSubpassDescription2 src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkSubpassDescription2 malloc() {
        return new VkSubpassDescription2(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkSubpassDescription2 calloc() {
        return new VkSubpassDescription2(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkSubpassDescription2 create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkSubpassDescription2(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkSubpassDescription2 create(long address) {
        return new VkSubpassDescription2(address, null);
    }

    @Nullable
    public static VkSubpassDescription2 createSafe(long address) {
        return address == 0L ? null : new VkSubpassDescription2(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkSubpassDescription2.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkSubpassDescription2.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkSubpassDescription2 malloc(MemoryStack stack) {
        return new VkSubpassDescription2(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkSubpassDescription2 calloc(MemoryStack stack) {
        return new VkSubpassDescription2(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static int nflags(long struct) {
        return UNSAFE.getInt(null, struct + (long)FLAGS);
    }

    public static int npipelineBindPoint(long struct) {
        return UNSAFE.getInt(null, struct + (long)PIPELINEBINDPOINT);
    }

    public static int nviewMask(long struct) {
        return UNSAFE.getInt(null, struct + (long)VIEWMASK);
    }

    public static int ninputAttachmentCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)INPUTATTACHMENTCOUNT);
    }

    @Nullable
    public static VkAttachmentReference2.Buffer npInputAttachments(long struct) {
        return VkAttachmentReference2.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)PINPUTATTACHMENTS)), VkSubpassDescription2.ninputAttachmentCount(struct));
    }

    public static int ncolorAttachmentCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)COLORATTACHMENTCOUNT);
    }

    @Nullable
    public static VkAttachmentReference2.Buffer npColorAttachments(long struct) {
        return VkAttachmentReference2.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)PCOLORATTACHMENTS)), VkSubpassDescription2.ncolorAttachmentCount(struct));
    }

    @Nullable
    public static VkAttachmentReference2.Buffer npResolveAttachments(long struct) {
        return VkAttachmentReference2.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)PRESOLVEATTACHMENTS)), VkSubpassDescription2.ncolorAttachmentCount(struct));
    }

    @Nullable
    public static VkAttachmentReference2 npDepthStencilAttachment(long struct) {
        return VkAttachmentReference2.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)PDEPTHSTENCILATTACHMENT)));
    }

    public static int npreserveAttachmentCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)PRESERVEATTACHMENTCOUNT);
    }

    @Nullable
    public static IntBuffer npPreserveAttachments(long struct) {
        return MemoryUtil.memIntBufferSafe((long)MemoryUtil.memGetAddress((long)(struct + (long)PPRESERVEATTACHMENTS)), (int)VkSubpassDescription2.npreserveAttachmentCount(struct));
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void nflags(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FLAGS, value);
    }

    public static void npipelineBindPoint(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)PIPELINEBINDPOINT, value);
    }

    public static void nviewMask(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)VIEWMASK, value);
    }

    public static void ninputAttachmentCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)INPUTATTACHMENTCOUNT, value);
    }

    public static void npInputAttachments(long struct, @Nullable VkAttachmentReference2.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PINPUTATTACHMENTS), (long)MemoryUtil.memAddressSafe((Pointer)value));
        VkSubpassDescription2.ninputAttachmentCount(struct, value == null ? 0 : value.remaining());
    }

    public static void ncolorAttachmentCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)COLORATTACHMENTCOUNT, value);
    }

    public static void npColorAttachments(long struct, @Nullable VkAttachmentReference2.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PCOLORATTACHMENTS), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    public static void npResolveAttachments(long struct, @Nullable VkAttachmentReference2.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PRESOLVEATTACHMENTS), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    public static void npDepthStencilAttachment(long struct, @Nullable VkAttachmentReference2 value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PDEPTHSTENCILATTACHMENT), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    public static void npreserveAttachmentCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)PRESERVEATTACHMENTCOUNT, value);
    }

    public static void npPreserveAttachments(long struct, @Nullable IntBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PPRESERVEATTACHMENTS), (long)MemoryUtil.memAddressSafe((IntBuffer)value));
        VkSubpassDescription2.npreserveAttachmentCount(struct, value == null ? 0 : value.remaining());
    }

    public static void validate(long struct) {
        if (VkSubpassDescription2.ninputAttachmentCount(struct) != 0) {
            Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PINPUTATTACHMENTS)));
        }
        if (VkSubpassDescription2.ncolorAttachmentCount(struct) != 0) {
            Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PCOLORATTACHMENTS)));
        }
        if (VkSubpassDescription2.npreserveAttachmentCount(struct) != 0) {
            Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PPRESERVEATTACHMENTS)));
        }
    }

    static {
        Struct.Layout layout = VkSubpassDescription2.__struct((Struct.Member[])new Struct.Member[]{VkSubpassDescription2.__member((int)4), VkSubpassDescription2.__member((int)POINTER_SIZE), VkSubpassDescription2.__member((int)4), VkSubpassDescription2.__member((int)4), VkSubpassDescription2.__member((int)4), VkSubpassDescription2.__member((int)4), VkSubpassDescription2.__member((int)POINTER_SIZE), VkSubpassDescription2.__member((int)4), VkSubpassDescription2.__member((int)POINTER_SIZE), VkSubpassDescription2.__member((int)POINTER_SIZE), VkSubpassDescription2.__member((int)POINTER_SIZE), VkSubpassDescription2.__member((int)4), VkSubpassDescription2.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        PIPELINEBINDPOINT = layout.offsetof(3);
        VIEWMASK = layout.offsetof(4);
        INPUTATTACHMENTCOUNT = layout.offsetof(5);
        PINPUTATTACHMENTS = layout.offsetof(6);
        COLORATTACHMENTCOUNT = layout.offsetof(7);
        PCOLORATTACHMENTS = layout.offsetof(8);
        PRESOLVEATTACHMENTS = layout.offsetof(9);
        PDEPTHSTENCILATTACHMENT = layout.offsetof(10);
        PRESERVEATTACHMENTCOUNT = layout.offsetof(11);
        PPRESERVEATTACHMENTS = layout.offsetof(12);
    }

    public static class Buffer
    extends StructBuffer<VkSubpassDescription2, Buffer>
    implements NativeResource {
        private static final VkSubpassDescription2 ELEMENT_FACTORY = VkSubpassDescription2.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkSubpassDescription2 getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkSubpassDescription2.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkSubpassDescription2.npNext(this.address());
        }

        @NativeType(value="VkSubpassDescriptionFlags")
        public int flags() {
            return VkSubpassDescription2.nflags(this.address());
        }

        @NativeType(value="VkPipelineBindPoint")
        public int pipelineBindPoint() {
            return VkSubpassDescription2.npipelineBindPoint(this.address());
        }

        @NativeType(value="uint32_t")
        public int viewMask() {
            return VkSubpassDescription2.nviewMask(this.address());
        }

        @NativeType(value="uint32_t")
        public int inputAttachmentCount() {
            return VkSubpassDescription2.ninputAttachmentCount(this.address());
        }

        @Nullable
        @NativeType(value="VkAttachmentReference2 const *")
        public VkAttachmentReference2.Buffer pInputAttachments() {
            return VkSubpassDescription2.npInputAttachments(this.address());
        }

        @NativeType(value="uint32_t")
        public int colorAttachmentCount() {
            return VkSubpassDescription2.ncolorAttachmentCount(this.address());
        }

        @Nullable
        @NativeType(value="VkAttachmentReference2 const *")
        public VkAttachmentReference2.Buffer pColorAttachments() {
            return VkSubpassDescription2.npColorAttachments(this.address());
        }

        @Nullable
        @NativeType(value="VkAttachmentReference2 const *")
        public VkAttachmentReference2.Buffer pResolveAttachments() {
            return VkSubpassDescription2.npResolveAttachments(this.address());
        }

        @Nullable
        @NativeType(value="VkAttachmentReference2 const *")
        public VkAttachmentReference2 pDepthStencilAttachment() {
            return VkSubpassDescription2.npDepthStencilAttachment(this.address());
        }

        @NativeType(value="uint32_t")
        public int preserveAttachmentCount() {
            return VkSubpassDescription2.npreserveAttachmentCount(this.address());
        }

        @Nullable
        @NativeType(value="uint32_t const *")
        public IntBuffer pPreserveAttachments() {
            return VkSubpassDescription2.npPreserveAttachments(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkSubpassDescription2.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000109002);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkSubpassDescription2.npNext(this.address(), value);
            return this;
        }

        public Buffer pNext(VkFragmentShadingRateAttachmentInfoKHR value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkMultisampledRenderToSingleSampledInfoEXT value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkRenderPassCreationControlEXT value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkRenderPassSubpassFeedbackCreateInfoEXT value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkSubpassDescriptionDepthStencilResolve value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkSubpassDescriptionDepthStencilResolveKHR value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer flags(@NativeType(value="VkSubpassDescriptionFlags") int value) {
            VkSubpassDescription2.nflags(this.address(), value);
            return this;
        }

        public Buffer pipelineBindPoint(@NativeType(value="VkPipelineBindPoint") int value) {
            VkSubpassDescription2.npipelineBindPoint(this.address(), value);
            return this;
        }

        public Buffer viewMask(@NativeType(value="uint32_t") int value) {
            VkSubpassDescription2.nviewMask(this.address(), value);
            return this;
        }

        public Buffer pInputAttachments(@Nullable @NativeType(value="VkAttachmentReference2 const *") VkAttachmentReference2.Buffer value) {
            VkSubpassDescription2.npInputAttachments(this.address(), value);
            return this;
        }

        public Buffer colorAttachmentCount(@NativeType(value="uint32_t") int value) {
            VkSubpassDescription2.ncolorAttachmentCount(this.address(), value);
            return this;
        }

        public Buffer pColorAttachments(@Nullable @NativeType(value="VkAttachmentReference2 const *") VkAttachmentReference2.Buffer value) {
            VkSubpassDescription2.npColorAttachments(this.address(), value);
            return this;
        }

        public Buffer pResolveAttachments(@Nullable @NativeType(value="VkAttachmentReference2 const *") VkAttachmentReference2.Buffer value) {
            VkSubpassDescription2.npResolveAttachments(this.address(), value);
            return this;
        }

        public Buffer pDepthStencilAttachment(@Nullable @NativeType(value="VkAttachmentReference2 const *") VkAttachmentReference2 value) {
            VkSubpassDescription2.npDepthStencilAttachment(this.address(), value);
            return this;
        }

        public Buffer pPreserveAttachments(@Nullable @NativeType(value="uint32_t const *") IntBuffer value) {
            VkSubpassDescription2.npPreserveAttachments(this.address(), value);
            return this;
        }
    }
}

