/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkExtent3D;
import org.lwjgl.vulkan.VkImageSubresource;
import org.lwjgl.vulkan.VkOffset3D;

public class VkSparseImageMemoryBind
extends Struct<VkSparseImageMemoryBind>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int SUBRESOURCE;
    public static final int OFFSET;
    public static final int EXTENT;
    public static final int MEMORY;
    public static final int MEMORYOFFSET;
    public static final int FLAGS;

    protected VkSparseImageMemoryBind(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkSparseImageMemoryBind create(long address, @Nullable ByteBuffer container) {
        return new VkSparseImageMemoryBind(address, container);
    }

    public VkSparseImageMemoryBind(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkSparseImageMemoryBind.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public VkImageSubresource subresource() {
        return VkSparseImageMemoryBind.nsubresource(this.address());
    }

    public VkOffset3D offset() {
        return VkSparseImageMemoryBind.noffset(this.address());
    }

    public VkExtent3D extent() {
        return VkSparseImageMemoryBind.nextent(this.address());
    }

    @NativeType(value="VkDeviceMemory")
    public long memory() {
        return VkSparseImageMemoryBind.nmemory(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long memoryOffset() {
        return VkSparseImageMemoryBind.nmemoryOffset(this.address());
    }

    @NativeType(value="VkSparseMemoryBindFlags")
    public int flags() {
        return VkSparseImageMemoryBind.nflags(this.address());
    }

    public VkSparseImageMemoryBind subresource(VkImageSubresource value) {
        VkSparseImageMemoryBind.nsubresource(this.address(), value);
        return this;
    }

    public VkSparseImageMemoryBind subresource(Consumer<VkImageSubresource> consumer) {
        consumer.accept(this.subresource());
        return this;
    }

    public VkSparseImageMemoryBind offset(VkOffset3D value) {
        VkSparseImageMemoryBind.noffset(this.address(), value);
        return this;
    }

    public VkSparseImageMemoryBind offset(Consumer<VkOffset3D> consumer) {
        consumer.accept(this.offset());
        return this;
    }

    public VkSparseImageMemoryBind extent(VkExtent3D value) {
        VkSparseImageMemoryBind.nextent(this.address(), value);
        return this;
    }

    public VkSparseImageMemoryBind extent(Consumer<VkExtent3D> consumer) {
        consumer.accept(this.extent());
        return this;
    }

    public VkSparseImageMemoryBind memory(@NativeType(value="VkDeviceMemory") long value) {
        VkSparseImageMemoryBind.nmemory(this.address(), value);
        return this;
    }

    public VkSparseImageMemoryBind memoryOffset(@NativeType(value="VkDeviceSize") long value) {
        VkSparseImageMemoryBind.nmemoryOffset(this.address(), value);
        return this;
    }

    public VkSparseImageMemoryBind flags(@NativeType(value="VkSparseMemoryBindFlags") int value) {
        VkSparseImageMemoryBind.nflags(this.address(), value);
        return this;
    }

    public VkSparseImageMemoryBind set(VkImageSubresource subresource, VkOffset3D offset, VkExtent3D extent, long memory, long memoryOffset, int flags) {
        this.subresource(subresource);
        this.offset(offset);
        this.extent(extent);
        this.memory(memory);
        this.memoryOffset(memoryOffset);
        this.flags(flags);
        return this;
    }

    public VkSparseImageMemoryBind set(VkSparseImageMemoryBind src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkSparseImageMemoryBind malloc() {
        return new VkSparseImageMemoryBind(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkSparseImageMemoryBind calloc() {
        return new VkSparseImageMemoryBind(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkSparseImageMemoryBind create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkSparseImageMemoryBind(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkSparseImageMemoryBind create(long address) {
        return new VkSparseImageMemoryBind(address, null);
    }

    @Nullable
    public static VkSparseImageMemoryBind createSafe(long address) {
        return address == 0L ? null : new VkSparseImageMemoryBind(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkSparseImageMemoryBind.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkSparseImageMemoryBind.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkSparseImageMemoryBind mallocStack() {
        return VkSparseImageMemoryBind.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkSparseImageMemoryBind callocStack() {
        return VkSparseImageMemoryBind.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkSparseImageMemoryBind mallocStack(MemoryStack stack) {
        return VkSparseImageMemoryBind.malloc(stack);
    }

    @Deprecated
    public static VkSparseImageMemoryBind callocStack(MemoryStack stack) {
        return VkSparseImageMemoryBind.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkSparseImageMemoryBind.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkSparseImageMemoryBind.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkSparseImageMemoryBind.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkSparseImageMemoryBind.calloc(capacity, stack);
    }

    public static VkSparseImageMemoryBind malloc(MemoryStack stack) {
        return new VkSparseImageMemoryBind(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkSparseImageMemoryBind calloc(MemoryStack stack) {
        return new VkSparseImageMemoryBind(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static VkImageSubresource nsubresource(long struct) {
        return VkImageSubresource.create(struct + (long)SUBRESOURCE);
    }

    public static VkOffset3D noffset(long struct) {
        return VkOffset3D.create(struct + (long)OFFSET);
    }

    public static VkExtent3D nextent(long struct) {
        return VkExtent3D.create(struct + (long)EXTENT);
    }

    public static long nmemory(long struct) {
        return UNSAFE.getLong(null, struct + (long)MEMORY);
    }

    public static long nmemoryOffset(long struct) {
        return UNSAFE.getLong(null, struct + (long)MEMORYOFFSET);
    }

    public static int nflags(long struct) {
        return UNSAFE.getInt(null, struct + (long)FLAGS);
    }

    public static void nsubresource(long struct, VkImageSubresource value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)SUBRESOURCE), (long)VkImageSubresource.SIZEOF);
    }

    public static void noffset(long struct, VkOffset3D value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)OFFSET), (long)VkOffset3D.SIZEOF);
    }

    public static void nextent(long struct, VkExtent3D value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)EXTENT), (long)VkExtent3D.SIZEOF);
    }

    public static void nmemory(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)MEMORY, value);
    }

    public static void nmemoryOffset(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)MEMORYOFFSET, value);
    }

    public static void nflags(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FLAGS, value);
    }

    static {
        Struct.Layout layout = VkSparseImageMemoryBind.__struct((Struct.Member[])new Struct.Member[]{VkSparseImageMemoryBind.__member((int)VkImageSubresource.SIZEOF, (int)VkImageSubresource.ALIGNOF), VkSparseImageMemoryBind.__member((int)VkOffset3D.SIZEOF, (int)VkOffset3D.ALIGNOF), VkSparseImageMemoryBind.__member((int)VkExtent3D.SIZEOF, (int)VkExtent3D.ALIGNOF), VkSparseImageMemoryBind.__member((int)8), VkSparseImageMemoryBind.__member((int)8), VkSparseImageMemoryBind.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        SUBRESOURCE = layout.offsetof(0);
        OFFSET = layout.offsetof(1);
        EXTENT = layout.offsetof(2);
        MEMORY = layout.offsetof(3);
        MEMORYOFFSET = layout.offsetof(4);
        FLAGS = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<VkSparseImageMemoryBind, Buffer>
    implements NativeResource {
        private static final VkSparseImageMemoryBind ELEMENT_FACTORY = VkSparseImageMemoryBind.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkSparseImageMemoryBind getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public VkImageSubresource subresource() {
            return VkSparseImageMemoryBind.nsubresource(this.address());
        }

        public VkOffset3D offset() {
            return VkSparseImageMemoryBind.noffset(this.address());
        }

        public VkExtent3D extent() {
            return VkSparseImageMemoryBind.nextent(this.address());
        }

        @NativeType(value="VkDeviceMemory")
        public long memory() {
            return VkSparseImageMemoryBind.nmemory(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long memoryOffset() {
            return VkSparseImageMemoryBind.nmemoryOffset(this.address());
        }

        @NativeType(value="VkSparseMemoryBindFlags")
        public int flags() {
            return VkSparseImageMemoryBind.nflags(this.address());
        }

        public Buffer subresource(VkImageSubresource value) {
            VkSparseImageMemoryBind.nsubresource(this.address(), value);
            return this;
        }

        public Buffer subresource(Consumer<VkImageSubresource> consumer) {
            consumer.accept(this.subresource());
            return this;
        }

        public Buffer offset(VkOffset3D value) {
            VkSparseImageMemoryBind.noffset(this.address(), value);
            return this;
        }

        public Buffer offset(Consumer<VkOffset3D> consumer) {
            consumer.accept(this.offset());
            return this;
        }

        public Buffer extent(VkExtent3D value) {
            VkSparseImageMemoryBind.nextent(this.address(), value);
            return this;
        }

        public Buffer extent(Consumer<VkExtent3D> consumer) {
            consumer.accept(this.extent());
            return this;
        }

        public Buffer memory(@NativeType(value="VkDeviceMemory") long value) {
            VkSparseImageMemoryBind.nmemory(this.address(), value);
            return this;
        }

        public Buffer memoryOffset(@NativeType(value="VkDeviceSize") long value) {
            VkSparseImageMemoryBind.nmemoryOffset(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="VkSparseMemoryBindFlags") int value) {
            VkSparseImageMemoryBind.nflags(this.address(), value);
            return this;
        }
    }
}

