/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkPipelineLayoutCreateInfo;

public class VkPushConstantsInfoKHR
extends Struct<VkPushConstantsInfoKHR>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int LAYOUT;
    public static final int STAGEFLAGS;
    public static final int OFFSET;
    public static final int SIZE;
    public static final int PVALUES;

    protected VkPushConstantsInfoKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkPushConstantsInfoKHR create(long address, @Nullable ByteBuffer container) {
        return new VkPushConstantsInfoKHR(address, container);
    }

    public VkPushConstantsInfoKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkPushConstantsInfoKHR.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkPushConstantsInfoKHR.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkPushConstantsInfoKHR.npNext(this.address());
    }

    @NativeType(value="VkPipelineLayout")
    public long layout() {
        return VkPushConstantsInfoKHR.nlayout(this.address());
    }

    @NativeType(value="VkShaderStageFlags")
    public int stageFlags() {
        return VkPushConstantsInfoKHR.nstageFlags(this.address());
    }

    @NativeType(value="uint32_t")
    public int offset() {
        return VkPushConstantsInfoKHR.noffset(this.address());
    }

    @NativeType(value="uint32_t")
    public int size() {
        return VkPushConstantsInfoKHR.nsize(this.address());
    }

    @NativeType(value="void const *")
    public ByteBuffer pValues() {
        return VkPushConstantsInfoKHR.npValues(this.address());
    }

    public VkPushConstantsInfoKHR sType(@NativeType(value="VkStructureType") int value) {
        VkPushConstantsInfoKHR.nsType(this.address(), value);
        return this;
    }

    public VkPushConstantsInfoKHR sType$Default() {
        return this.sType(1000545004);
    }

    public VkPushConstantsInfoKHR pNext(@NativeType(value="void const *") long value) {
        VkPushConstantsInfoKHR.npNext(this.address(), value);
        return this;
    }

    public VkPushConstantsInfoKHR pNext(VkPipelineLayoutCreateInfo value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkPushConstantsInfoKHR layout(@NativeType(value="VkPipelineLayout") long value) {
        VkPushConstantsInfoKHR.nlayout(this.address(), value);
        return this;
    }

    public VkPushConstantsInfoKHR stageFlags(@NativeType(value="VkShaderStageFlags") int value) {
        VkPushConstantsInfoKHR.nstageFlags(this.address(), value);
        return this;
    }

    public VkPushConstantsInfoKHR offset(@NativeType(value="uint32_t") int value) {
        VkPushConstantsInfoKHR.noffset(this.address(), value);
        return this;
    }

    public VkPushConstantsInfoKHR pValues(@NativeType(value="void const *") ByteBuffer value) {
        VkPushConstantsInfoKHR.npValues(this.address(), value);
        return this;
    }

    public VkPushConstantsInfoKHR set(int sType, long pNext, long layout, int stageFlags, int offset, ByteBuffer pValues) {
        this.sType(sType);
        this.pNext(pNext);
        this.layout(layout);
        this.stageFlags(stageFlags);
        this.offset(offset);
        this.pValues(pValues);
        return this;
    }

    public VkPushConstantsInfoKHR set(VkPushConstantsInfoKHR src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkPushConstantsInfoKHR malloc() {
        return new VkPushConstantsInfoKHR(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkPushConstantsInfoKHR calloc() {
        return new VkPushConstantsInfoKHR(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkPushConstantsInfoKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkPushConstantsInfoKHR(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkPushConstantsInfoKHR create(long address) {
        return new VkPushConstantsInfoKHR(address, null);
    }

    @Nullable
    public static VkPushConstantsInfoKHR createSafe(long address) {
        return address == 0L ? null : new VkPushConstantsInfoKHR(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkPushConstantsInfoKHR.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkPushConstantsInfoKHR.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkPushConstantsInfoKHR malloc(MemoryStack stack) {
        return new VkPushConstantsInfoKHR(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkPushConstantsInfoKHR calloc(MemoryStack stack) {
        return new VkPushConstantsInfoKHR(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static long nlayout(long struct) {
        return UNSAFE.getLong(null, struct + (long)LAYOUT);
    }

    public static int nstageFlags(long struct) {
        return UNSAFE.getInt(null, struct + (long)STAGEFLAGS);
    }

    public static int noffset(long struct) {
        return UNSAFE.getInt(null, struct + (long)OFFSET);
    }

    public static int nsize(long struct) {
        return UNSAFE.getInt(null, struct + (long)SIZE);
    }

    public static ByteBuffer npValues(long struct) {
        return MemoryUtil.memByteBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)PVALUES)), (int)VkPushConstantsInfoKHR.nsize(struct));
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void nlayout(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)LAYOUT, value);
    }

    public static void nstageFlags(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STAGEFLAGS, value);
    }

    public static void noffset(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)OFFSET, value);
    }

    public static void nsize(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SIZE, value);
    }

    public static void npValues(long struct, ByteBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PVALUES), (long)MemoryUtil.memAddress((ByteBuffer)value));
        VkPushConstantsInfoKHR.nsize(struct, value.remaining());
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PVALUES)));
    }

    static {
        Struct.Layout layout = VkPushConstantsInfoKHR.__struct((Struct.Member[])new Struct.Member[]{VkPushConstantsInfoKHR.__member((int)4), VkPushConstantsInfoKHR.__member((int)POINTER_SIZE), VkPushConstantsInfoKHR.__member((int)8), VkPushConstantsInfoKHR.__member((int)4), VkPushConstantsInfoKHR.__member((int)4), VkPushConstantsInfoKHR.__member((int)4), VkPushConstantsInfoKHR.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        LAYOUT = layout.offsetof(2);
        STAGEFLAGS = layout.offsetof(3);
        OFFSET = layout.offsetof(4);
        SIZE = layout.offsetof(5);
        PVALUES = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<VkPushConstantsInfoKHR, Buffer>
    implements NativeResource {
        private static final VkPushConstantsInfoKHR ELEMENT_FACTORY = VkPushConstantsInfoKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkPushConstantsInfoKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkPushConstantsInfoKHR.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkPushConstantsInfoKHR.npNext(this.address());
        }

        @NativeType(value="VkPipelineLayout")
        public long layout() {
            return VkPushConstantsInfoKHR.nlayout(this.address());
        }

        @NativeType(value="VkShaderStageFlags")
        public int stageFlags() {
            return VkPushConstantsInfoKHR.nstageFlags(this.address());
        }

        @NativeType(value="uint32_t")
        public int offset() {
            return VkPushConstantsInfoKHR.noffset(this.address());
        }

        @NativeType(value="uint32_t")
        public int size() {
            return VkPushConstantsInfoKHR.nsize(this.address());
        }

        @NativeType(value="void const *")
        public ByteBuffer pValues() {
            return VkPushConstantsInfoKHR.npValues(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkPushConstantsInfoKHR.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000545004);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkPushConstantsInfoKHR.npNext(this.address(), value);
            return this;
        }

        public Buffer pNext(VkPipelineLayoutCreateInfo value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer layout(@NativeType(value="VkPipelineLayout") long value) {
            VkPushConstantsInfoKHR.nlayout(this.address(), value);
            return this;
        }

        public Buffer stageFlags(@NativeType(value="VkShaderStageFlags") int value) {
            VkPushConstantsInfoKHR.nstageFlags(this.address(), value);
            return this;
        }

        public Buffer offset(@NativeType(value="uint32_t") int value) {
            VkPushConstantsInfoKHR.noffset(this.address(), value);
            return this;
        }

        public Buffer pValues(@NativeType(value="void const *") ByteBuffer value) {
            VkPushConstantsInfoKHR.npValues(this.address(), value);
            return this;
        }
    }
}

