/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkPushConstantRange
extends Struct<VkPushConstantRange>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STAGEFLAGS;
    public static final int OFFSET;
    public static final int SIZE;

    protected VkPushConstantRange(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkPushConstantRange create(long address, @Nullable ByteBuffer container) {
        return new VkPushConstantRange(address, container);
    }

    public VkPushConstantRange(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkPushConstantRange.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkShaderStageFlags")
    public int stageFlags() {
        return VkPushConstantRange.nstageFlags(this.address());
    }

    @NativeType(value="uint32_t")
    public int offset() {
        return VkPushConstantRange.noffset(this.address());
    }

    @NativeType(value="uint32_t")
    public int size() {
        return VkPushConstantRange.nsize(this.address());
    }

    public VkPushConstantRange stageFlags(@NativeType(value="VkShaderStageFlags") int value) {
        VkPushConstantRange.nstageFlags(this.address(), value);
        return this;
    }

    public VkPushConstantRange offset(@NativeType(value="uint32_t") int value) {
        VkPushConstantRange.noffset(this.address(), value);
        return this;
    }

    public VkPushConstantRange size(@NativeType(value="uint32_t") int value) {
        VkPushConstantRange.nsize(this.address(), value);
        return this;
    }

    public VkPushConstantRange set(int stageFlags, int offset, int size) {
        this.stageFlags(stageFlags);
        this.offset(offset);
        this.size(size);
        return this;
    }

    public VkPushConstantRange set(VkPushConstantRange src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkPushConstantRange malloc() {
        return new VkPushConstantRange(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkPushConstantRange calloc() {
        return new VkPushConstantRange(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkPushConstantRange create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkPushConstantRange(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkPushConstantRange create(long address) {
        return new VkPushConstantRange(address, null);
    }

    @Nullable
    public static VkPushConstantRange createSafe(long address) {
        return address == 0L ? null : new VkPushConstantRange(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkPushConstantRange.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkPushConstantRange.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkPushConstantRange mallocStack() {
        return VkPushConstantRange.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkPushConstantRange callocStack() {
        return VkPushConstantRange.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkPushConstantRange mallocStack(MemoryStack stack) {
        return VkPushConstantRange.malloc(stack);
    }

    @Deprecated
    public static VkPushConstantRange callocStack(MemoryStack stack) {
        return VkPushConstantRange.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkPushConstantRange.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkPushConstantRange.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkPushConstantRange.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkPushConstantRange.calloc(capacity, stack);
    }

    public static VkPushConstantRange malloc(MemoryStack stack) {
        return new VkPushConstantRange(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkPushConstantRange calloc(MemoryStack stack) {
        return new VkPushConstantRange(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nstageFlags(long struct) {
        return UNSAFE.getInt(null, struct + (long)STAGEFLAGS);
    }

    public static int noffset(long struct) {
        return UNSAFE.getInt(null, struct + (long)OFFSET);
    }

    public static int nsize(long struct) {
        return UNSAFE.getInt(null, struct + (long)SIZE);
    }

    public static void nstageFlags(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STAGEFLAGS, value);
    }

    public static void noffset(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)OFFSET, value);
    }

    public static void nsize(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SIZE, value);
    }

    static {
        Struct.Layout layout = VkPushConstantRange.__struct((Struct.Member[])new Struct.Member[]{VkPushConstantRange.__member((int)4), VkPushConstantRange.__member((int)4), VkPushConstantRange.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STAGEFLAGS = layout.offsetof(0);
        OFFSET = layout.offsetof(1);
        SIZE = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkPushConstantRange, Buffer>
    implements NativeResource {
        private static final VkPushConstantRange ELEMENT_FACTORY = VkPushConstantRange.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkPushConstantRange getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkShaderStageFlags")
        public int stageFlags() {
            return VkPushConstantRange.nstageFlags(this.address());
        }

        @NativeType(value="uint32_t")
        public int offset() {
            return VkPushConstantRange.noffset(this.address());
        }

        @NativeType(value="uint32_t")
        public int size() {
            return VkPushConstantRange.nsize(this.address());
        }

        public Buffer stageFlags(@NativeType(value="VkShaderStageFlags") int value) {
            VkPushConstantRange.nstageFlags(this.address(), value);
            return this;
        }

        public Buffer offset(@NativeType(value="uint32_t") int value) {
            VkPushConstantRange.noffset(this.address(), value);
            return this;
        }

        public Buffer size(@NativeType(value="uint32_t") int value) {
            VkPushConstantRange.nsize(this.address(), value);
            return this;
        }
    }
}

