/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkMemoryPriorityAllocateInfoEXT
extends Struct<VkMemoryPriorityAllocateInfoEXT>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int PRIORITY;

    protected VkMemoryPriorityAllocateInfoEXT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkMemoryPriorityAllocateInfoEXT create(long address, @Nullable ByteBuffer container) {
        return new VkMemoryPriorityAllocateInfoEXT(address, container);
    }

    public VkMemoryPriorityAllocateInfoEXT(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkMemoryPriorityAllocateInfoEXT.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkMemoryPriorityAllocateInfoEXT.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkMemoryPriorityAllocateInfoEXT.npNext(this.address());
    }

    public float priority() {
        return VkMemoryPriorityAllocateInfoEXT.npriority(this.address());
    }

    public VkMemoryPriorityAllocateInfoEXT sType(@NativeType(value="VkStructureType") int value) {
        VkMemoryPriorityAllocateInfoEXT.nsType(this.address(), value);
        return this;
    }

    public VkMemoryPriorityAllocateInfoEXT sType$Default() {
        return this.sType(1000238001);
    }

    public VkMemoryPriorityAllocateInfoEXT pNext(@NativeType(value="void const *") long value) {
        VkMemoryPriorityAllocateInfoEXT.npNext(this.address(), value);
        return this;
    }

    public VkMemoryPriorityAllocateInfoEXT priority(float value) {
        VkMemoryPriorityAllocateInfoEXT.npriority(this.address(), value);
        return this;
    }

    public VkMemoryPriorityAllocateInfoEXT set(int sType, long pNext, float priority) {
        this.sType(sType);
        this.pNext(pNext);
        this.priority(priority);
        return this;
    }

    public VkMemoryPriorityAllocateInfoEXT set(VkMemoryPriorityAllocateInfoEXT src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkMemoryPriorityAllocateInfoEXT malloc() {
        return new VkMemoryPriorityAllocateInfoEXT(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkMemoryPriorityAllocateInfoEXT calloc() {
        return new VkMemoryPriorityAllocateInfoEXT(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkMemoryPriorityAllocateInfoEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkMemoryPriorityAllocateInfoEXT(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkMemoryPriorityAllocateInfoEXT create(long address) {
        return new VkMemoryPriorityAllocateInfoEXT(address, null);
    }

    @Nullable
    public static VkMemoryPriorityAllocateInfoEXT createSafe(long address) {
        return address == 0L ? null : new VkMemoryPriorityAllocateInfoEXT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkMemoryPriorityAllocateInfoEXT.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkMemoryPriorityAllocateInfoEXT.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkMemoryPriorityAllocateInfoEXT mallocStack() {
        return VkMemoryPriorityAllocateInfoEXT.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkMemoryPriorityAllocateInfoEXT callocStack() {
        return VkMemoryPriorityAllocateInfoEXT.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkMemoryPriorityAllocateInfoEXT mallocStack(MemoryStack stack) {
        return VkMemoryPriorityAllocateInfoEXT.malloc(stack);
    }

    @Deprecated
    public static VkMemoryPriorityAllocateInfoEXT callocStack(MemoryStack stack) {
        return VkMemoryPriorityAllocateInfoEXT.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkMemoryPriorityAllocateInfoEXT.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkMemoryPriorityAllocateInfoEXT.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkMemoryPriorityAllocateInfoEXT.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkMemoryPriorityAllocateInfoEXT.calloc(capacity, stack);
    }

    public static VkMemoryPriorityAllocateInfoEXT malloc(MemoryStack stack) {
        return new VkMemoryPriorityAllocateInfoEXT(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkMemoryPriorityAllocateInfoEXT calloc(MemoryStack stack) {
        return new VkMemoryPriorityAllocateInfoEXT(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static float npriority(long struct) {
        return UNSAFE.getFloat(null, struct + (long)PRIORITY);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void npriority(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)PRIORITY, value);
    }

    static {
        Struct.Layout layout = VkMemoryPriorityAllocateInfoEXT.__struct((Struct.Member[])new Struct.Member[]{VkMemoryPriorityAllocateInfoEXT.__member((int)4), VkMemoryPriorityAllocateInfoEXT.__member((int)POINTER_SIZE), VkMemoryPriorityAllocateInfoEXT.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        PRIORITY = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkMemoryPriorityAllocateInfoEXT, Buffer>
    implements NativeResource {
        private static final VkMemoryPriorityAllocateInfoEXT ELEMENT_FACTORY = VkMemoryPriorityAllocateInfoEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkMemoryPriorityAllocateInfoEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkMemoryPriorityAllocateInfoEXT.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkMemoryPriorityAllocateInfoEXT.npNext(this.address());
        }

        public float priority() {
            return VkMemoryPriorityAllocateInfoEXT.npriority(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkMemoryPriorityAllocateInfoEXT.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000238001);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkMemoryPriorityAllocateInfoEXT.npNext(this.address(), value);
            return this;
        }

        public Buffer priority(float value) {
            VkMemoryPriorityAllocateInfoEXT.npriority(this.address(), value);
            return this;
        }
    }
}

