/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkImportMetalBufferInfoEXT
extends Struct<VkImportMetalBufferInfoEXT>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int MTLBUFFER;

    protected VkImportMetalBufferInfoEXT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkImportMetalBufferInfoEXT create(long address, @Nullable ByteBuffer container) {
        return new VkImportMetalBufferInfoEXT(address, container);
    }

    public VkImportMetalBufferInfoEXT(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkImportMetalBufferInfoEXT.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkImportMetalBufferInfoEXT.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkImportMetalBufferInfoEXT.npNext(this.address());
    }

    @NativeType(value="MTLBuffer_id")
    public long mtlBuffer() {
        return VkImportMetalBufferInfoEXT.nmtlBuffer(this.address());
    }

    public VkImportMetalBufferInfoEXT sType(@NativeType(value="VkStructureType") int value) {
        VkImportMetalBufferInfoEXT.nsType(this.address(), value);
        return this;
    }

    public VkImportMetalBufferInfoEXT sType$Default() {
        return this.sType(1000311005);
    }

    public VkImportMetalBufferInfoEXT pNext(@NativeType(value="void const *") long value) {
        VkImportMetalBufferInfoEXT.npNext(this.address(), value);
        return this;
    }

    public VkImportMetalBufferInfoEXT mtlBuffer(@NativeType(value="MTLBuffer_id") long value) {
        VkImportMetalBufferInfoEXT.nmtlBuffer(this.address(), value);
        return this;
    }

    public VkImportMetalBufferInfoEXT set(int sType, long pNext, long mtlBuffer) {
        this.sType(sType);
        this.pNext(pNext);
        this.mtlBuffer(mtlBuffer);
        return this;
    }

    public VkImportMetalBufferInfoEXT set(VkImportMetalBufferInfoEXT src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkImportMetalBufferInfoEXT malloc() {
        return new VkImportMetalBufferInfoEXT(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkImportMetalBufferInfoEXT calloc() {
        return new VkImportMetalBufferInfoEXT(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkImportMetalBufferInfoEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkImportMetalBufferInfoEXT(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkImportMetalBufferInfoEXT create(long address) {
        return new VkImportMetalBufferInfoEXT(address, null);
    }

    @Nullable
    public static VkImportMetalBufferInfoEXT createSafe(long address) {
        return address == 0L ? null : new VkImportMetalBufferInfoEXT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkImportMetalBufferInfoEXT.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkImportMetalBufferInfoEXT.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkImportMetalBufferInfoEXT malloc(MemoryStack stack) {
        return new VkImportMetalBufferInfoEXT(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkImportMetalBufferInfoEXT calloc(MemoryStack stack) {
        return new VkImportMetalBufferInfoEXT(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static long nmtlBuffer(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)MTLBUFFER));
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void nmtlBuffer(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)MTLBUFFER), (long)Checks.check((long)value));
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)MTLBUFFER)));
    }

    static {
        Struct.Layout layout = VkImportMetalBufferInfoEXT.__struct((Struct.Member[])new Struct.Member[]{VkImportMetalBufferInfoEXT.__member((int)4), VkImportMetalBufferInfoEXT.__member((int)POINTER_SIZE), VkImportMetalBufferInfoEXT.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        MTLBUFFER = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkImportMetalBufferInfoEXT, Buffer>
    implements NativeResource {
        private static final VkImportMetalBufferInfoEXT ELEMENT_FACTORY = VkImportMetalBufferInfoEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkImportMetalBufferInfoEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkImportMetalBufferInfoEXT.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkImportMetalBufferInfoEXT.npNext(this.address());
        }

        @NativeType(value="MTLBuffer_id")
        public long mtlBuffer() {
            return VkImportMetalBufferInfoEXT.nmtlBuffer(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkImportMetalBufferInfoEXT.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000311005);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkImportMetalBufferInfoEXT.npNext(this.address(), value);
            return this;
        }

        public Buffer mtlBuffer(@NativeType(value="MTLBuffer_id") long value) {
            VkImportMetalBufferInfoEXT.nmtlBuffer(this.address(), value);
            return this;
        }
    }
}

