/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkImagePlaneMemoryRequirementsInfo;
import org.lwjgl.vulkan.VkImagePlaneMemoryRequirementsInfoKHR;

public class VkImageMemoryRequirementsInfo2
extends Struct<VkImageMemoryRequirementsInfo2>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int IMAGE;

    protected VkImageMemoryRequirementsInfo2(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkImageMemoryRequirementsInfo2 create(long address, @Nullable ByteBuffer container) {
        return new VkImageMemoryRequirementsInfo2(address, container);
    }

    public VkImageMemoryRequirementsInfo2(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkImageMemoryRequirementsInfo2.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkImageMemoryRequirementsInfo2.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkImageMemoryRequirementsInfo2.npNext(this.address());
    }

    @NativeType(value="VkImage")
    public long image() {
        return VkImageMemoryRequirementsInfo2.nimage(this.address());
    }

    public VkImageMemoryRequirementsInfo2 sType(@NativeType(value="VkStructureType") int value) {
        VkImageMemoryRequirementsInfo2.nsType(this.address(), value);
        return this;
    }

    public VkImageMemoryRequirementsInfo2 sType$Default() {
        return this.sType(1000146001);
    }

    public VkImageMemoryRequirementsInfo2 pNext(@NativeType(value="void const *") long value) {
        VkImageMemoryRequirementsInfo2.npNext(this.address(), value);
        return this;
    }

    public VkImageMemoryRequirementsInfo2 pNext(VkImagePlaneMemoryRequirementsInfo value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkImageMemoryRequirementsInfo2 pNext(VkImagePlaneMemoryRequirementsInfoKHR value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkImageMemoryRequirementsInfo2 image(@NativeType(value="VkImage") long value) {
        VkImageMemoryRequirementsInfo2.nimage(this.address(), value);
        return this;
    }

    public VkImageMemoryRequirementsInfo2 set(int sType, long pNext, long image) {
        this.sType(sType);
        this.pNext(pNext);
        this.image(image);
        return this;
    }

    public VkImageMemoryRequirementsInfo2 set(VkImageMemoryRequirementsInfo2 src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkImageMemoryRequirementsInfo2 malloc() {
        return new VkImageMemoryRequirementsInfo2(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkImageMemoryRequirementsInfo2 calloc() {
        return new VkImageMemoryRequirementsInfo2(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkImageMemoryRequirementsInfo2 create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkImageMemoryRequirementsInfo2(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkImageMemoryRequirementsInfo2 create(long address) {
        return new VkImageMemoryRequirementsInfo2(address, null);
    }

    @Nullable
    public static VkImageMemoryRequirementsInfo2 createSafe(long address) {
        return address == 0L ? null : new VkImageMemoryRequirementsInfo2(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkImageMemoryRequirementsInfo2.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkImageMemoryRequirementsInfo2.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkImageMemoryRequirementsInfo2 mallocStack() {
        return VkImageMemoryRequirementsInfo2.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkImageMemoryRequirementsInfo2 callocStack() {
        return VkImageMemoryRequirementsInfo2.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkImageMemoryRequirementsInfo2 mallocStack(MemoryStack stack) {
        return VkImageMemoryRequirementsInfo2.malloc(stack);
    }

    @Deprecated
    public static VkImageMemoryRequirementsInfo2 callocStack(MemoryStack stack) {
        return VkImageMemoryRequirementsInfo2.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkImageMemoryRequirementsInfo2.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkImageMemoryRequirementsInfo2.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkImageMemoryRequirementsInfo2.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkImageMemoryRequirementsInfo2.calloc(capacity, stack);
    }

    public static VkImageMemoryRequirementsInfo2 malloc(MemoryStack stack) {
        return new VkImageMemoryRequirementsInfo2(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkImageMemoryRequirementsInfo2 calloc(MemoryStack stack) {
        return new VkImageMemoryRequirementsInfo2(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static long nimage(long struct) {
        return UNSAFE.getLong(null, struct + (long)IMAGE);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void nimage(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)IMAGE, value);
    }

    static {
        Struct.Layout layout = VkImageMemoryRequirementsInfo2.__struct((Struct.Member[])new Struct.Member[]{VkImageMemoryRequirementsInfo2.__member((int)4), VkImageMemoryRequirementsInfo2.__member((int)POINTER_SIZE), VkImageMemoryRequirementsInfo2.__member((int)8)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        IMAGE = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkImageMemoryRequirementsInfo2, Buffer>
    implements NativeResource {
        private static final VkImageMemoryRequirementsInfo2 ELEMENT_FACTORY = VkImageMemoryRequirementsInfo2.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkImageMemoryRequirementsInfo2 getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkImageMemoryRequirementsInfo2.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkImageMemoryRequirementsInfo2.npNext(this.address());
        }

        @NativeType(value="VkImage")
        public long image() {
            return VkImageMemoryRequirementsInfo2.nimage(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkImageMemoryRequirementsInfo2.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000146001);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkImageMemoryRequirementsInfo2.npNext(this.address(), value);
            return this;
        }

        public Buffer pNext(VkImagePlaneMemoryRequirementsInfo value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkImagePlaneMemoryRequirementsInfoKHR value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer image(@NativeType(value="VkImage") long value) {
            VkImageMemoryRequirementsInfo2.nimage(this.address(), value);
            return this;
        }
    }
}

