/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkExtent3D;

public class VkImageFormatProperties
extends Struct<VkImageFormatProperties>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MAXEXTENT;
    public static final int MAXMIPLEVELS;
    public static final int MAXARRAYLAYERS;
    public static final int SAMPLECOUNTS;
    public static final int MAXRESOURCESIZE;

    protected VkImageFormatProperties(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkImageFormatProperties create(long address, @Nullable ByteBuffer container) {
        return new VkImageFormatProperties(address, container);
    }

    public VkImageFormatProperties(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkImageFormatProperties.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public VkExtent3D maxExtent() {
        return VkImageFormatProperties.nmaxExtent(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxMipLevels() {
        return VkImageFormatProperties.nmaxMipLevels(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxArrayLayers() {
        return VkImageFormatProperties.nmaxArrayLayers(this.address());
    }

    @NativeType(value="VkSampleCountFlags")
    public int sampleCounts() {
        return VkImageFormatProperties.nsampleCounts(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long maxResourceSize() {
        return VkImageFormatProperties.nmaxResourceSize(this.address());
    }

    public static VkImageFormatProperties malloc() {
        return new VkImageFormatProperties(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkImageFormatProperties calloc() {
        return new VkImageFormatProperties(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkImageFormatProperties create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkImageFormatProperties(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkImageFormatProperties create(long address) {
        return new VkImageFormatProperties(address, null);
    }

    @Nullable
    public static VkImageFormatProperties createSafe(long address) {
        return address == 0L ? null : new VkImageFormatProperties(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkImageFormatProperties.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkImageFormatProperties.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkImageFormatProperties mallocStack() {
        return VkImageFormatProperties.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkImageFormatProperties callocStack() {
        return VkImageFormatProperties.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkImageFormatProperties mallocStack(MemoryStack stack) {
        return VkImageFormatProperties.malloc(stack);
    }

    @Deprecated
    public static VkImageFormatProperties callocStack(MemoryStack stack) {
        return VkImageFormatProperties.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkImageFormatProperties.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkImageFormatProperties.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkImageFormatProperties.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkImageFormatProperties.calloc(capacity, stack);
    }

    public static VkImageFormatProperties malloc(MemoryStack stack) {
        return new VkImageFormatProperties(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkImageFormatProperties calloc(MemoryStack stack) {
        return new VkImageFormatProperties(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static VkExtent3D nmaxExtent(long struct) {
        return VkExtent3D.create(struct + (long)MAXEXTENT);
    }

    public static int nmaxMipLevels(long struct) {
        return UNSAFE.getInt(null, struct + (long)MAXMIPLEVELS);
    }

    public static int nmaxArrayLayers(long struct) {
        return UNSAFE.getInt(null, struct + (long)MAXARRAYLAYERS);
    }

    public static int nsampleCounts(long struct) {
        return UNSAFE.getInt(null, struct + (long)SAMPLECOUNTS);
    }

    public static long nmaxResourceSize(long struct) {
        return UNSAFE.getLong(null, struct + (long)MAXRESOURCESIZE);
    }

    static {
        Struct.Layout layout = VkImageFormatProperties.__struct((Struct.Member[])new Struct.Member[]{VkImageFormatProperties.__member((int)VkExtent3D.SIZEOF, (int)VkExtent3D.ALIGNOF), VkImageFormatProperties.__member((int)4), VkImageFormatProperties.__member((int)4), VkImageFormatProperties.__member((int)4), VkImageFormatProperties.__member((int)8)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MAXEXTENT = layout.offsetof(0);
        MAXMIPLEVELS = layout.offsetof(1);
        MAXARRAYLAYERS = layout.offsetof(2);
        SAMPLECOUNTS = layout.offsetof(3);
        MAXRESOURCESIZE = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<VkImageFormatProperties, Buffer>
    implements NativeResource {
        private static final VkImageFormatProperties ELEMENT_FACTORY = VkImageFormatProperties.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkImageFormatProperties getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public VkExtent3D maxExtent() {
            return VkImageFormatProperties.nmaxExtent(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxMipLevels() {
            return VkImageFormatProperties.nmaxMipLevels(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxArrayLayers() {
            return VkImageFormatProperties.nmaxArrayLayers(this.address());
        }

        @NativeType(value="VkSampleCountFlags")
        public int sampleCounts() {
            return VkImageFormatProperties.nsampleCounts(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long maxResourceSize() {
            return VkImageFormatProperties.nmaxResourceSize(this.address());
        }
    }
}

