/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkDeviceOrHostAddressKHR
extends Struct<VkDeviceOrHostAddressKHR>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int DEVICEADDRESS;
    public static final int HOSTADDRESS;

    protected VkDeviceOrHostAddressKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkDeviceOrHostAddressKHR create(long address, @Nullable ByteBuffer container) {
        return new VkDeviceOrHostAddressKHR(address, container);
    }

    public VkDeviceOrHostAddressKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkDeviceOrHostAddressKHR.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkDeviceAddress")
    public long deviceAddress() {
        return VkDeviceOrHostAddressKHR.ndeviceAddress(this.address());
    }

    @NativeType(value="void *")
    public long hostAddress() {
        return VkDeviceOrHostAddressKHR.nhostAddress(this.address());
    }

    public VkDeviceOrHostAddressKHR deviceAddress(@NativeType(value="VkDeviceAddress") long value) {
        VkDeviceOrHostAddressKHR.ndeviceAddress(this.address(), value);
        return this;
    }

    public VkDeviceOrHostAddressKHR hostAddress(@NativeType(value="void *") long value) {
        VkDeviceOrHostAddressKHR.nhostAddress(this.address(), value);
        return this;
    }

    public VkDeviceOrHostAddressKHR set(VkDeviceOrHostAddressKHR src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkDeviceOrHostAddressKHR malloc() {
        return new VkDeviceOrHostAddressKHR(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkDeviceOrHostAddressKHR calloc() {
        return new VkDeviceOrHostAddressKHR(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkDeviceOrHostAddressKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkDeviceOrHostAddressKHR(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkDeviceOrHostAddressKHR create(long address) {
        return new VkDeviceOrHostAddressKHR(address, null);
    }

    @Nullable
    public static VkDeviceOrHostAddressKHR createSafe(long address) {
        return address == 0L ? null : new VkDeviceOrHostAddressKHR(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkDeviceOrHostAddressKHR.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkDeviceOrHostAddressKHR.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkDeviceOrHostAddressKHR malloc(MemoryStack stack) {
        return new VkDeviceOrHostAddressKHR(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkDeviceOrHostAddressKHR calloc(MemoryStack stack) {
        return new VkDeviceOrHostAddressKHR(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long ndeviceAddress(long struct) {
        return UNSAFE.getLong(null, struct + (long)DEVICEADDRESS);
    }

    public static long nhostAddress(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)HOSTADDRESS));
    }

    public static void ndeviceAddress(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)DEVICEADDRESS, value);
    }

    public static void nhostAddress(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)HOSTADDRESS), (long)value);
    }

    static {
        Struct.Layout layout = VkDeviceOrHostAddressKHR.__union((Struct.Member[])new Struct.Member[]{VkDeviceOrHostAddressKHR.__member((int)8), VkDeviceOrHostAddressKHR.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        DEVICEADDRESS = layout.offsetof(0);
        HOSTADDRESS = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<VkDeviceOrHostAddressKHR, Buffer>
    implements NativeResource {
        private static final VkDeviceOrHostAddressKHR ELEMENT_FACTORY = VkDeviceOrHostAddressKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkDeviceOrHostAddressKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkDeviceAddress")
        public long deviceAddress() {
            return VkDeviceOrHostAddressKHR.ndeviceAddress(this.address());
        }

        @NativeType(value="void *")
        public long hostAddress() {
            return VkDeviceOrHostAddressKHR.nhostAddress(this.address());
        }

        public Buffer deviceAddress(@NativeType(value="VkDeviceAddress") long value) {
            VkDeviceOrHostAddressKHR.ndeviceAddress(this.address(), value);
            return this;
        }

        public Buffer hostAddress(@NativeType(value="void *") long value) {
            VkDeviceOrHostAddressKHR.nhostAddress(this.address(), value);
            return this;
        }
    }
}

