/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkBufferMemoryBarrier2;
import org.lwjgl.vulkan.VkImageMemoryBarrier2;
import org.lwjgl.vulkan.VkMemoryBarrier2;

public class VkDependencyInfo
extends Struct<VkDependencyInfo>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int DEPENDENCYFLAGS;
    public static final int MEMORYBARRIERCOUNT;
    public static final int PMEMORYBARRIERS;
    public static final int BUFFERMEMORYBARRIERCOUNT;
    public static final int PBUFFERMEMORYBARRIERS;
    public static final int IMAGEMEMORYBARRIERCOUNT;
    public static final int PIMAGEMEMORYBARRIERS;

    protected VkDependencyInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkDependencyInfo create(long address, @Nullable ByteBuffer container) {
        return new VkDependencyInfo(address, container);
    }

    public VkDependencyInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkDependencyInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkDependencyInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkDependencyInfo.npNext(this.address());
    }

    @NativeType(value="VkDependencyFlags")
    public int dependencyFlags() {
        return VkDependencyInfo.ndependencyFlags(this.address());
    }

    @NativeType(value="uint32_t")
    public int memoryBarrierCount() {
        return VkDependencyInfo.nmemoryBarrierCount(this.address());
    }

    @Nullable
    @NativeType(value="VkMemoryBarrier2 const *")
    public VkMemoryBarrier2.Buffer pMemoryBarriers() {
        return VkDependencyInfo.npMemoryBarriers(this.address());
    }

    @NativeType(value="uint32_t")
    public int bufferMemoryBarrierCount() {
        return VkDependencyInfo.nbufferMemoryBarrierCount(this.address());
    }

    @Nullable
    @NativeType(value="VkBufferMemoryBarrier2 const *")
    public VkBufferMemoryBarrier2.Buffer pBufferMemoryBarriers() {
        return VkDependencyInfo.npBufferMemoryBarriers(this.address());
    }

    @NativeType(value="uint32_t")
    public int imageMemoryBarrierCount() {
        return VkDependencyInfo.nimageMemoryBarrierCount(this.address());
    }

    @Nullable
    @NativeType(value="VkImageMemoryBarrier2 const *")
    public VkImageMemoryBarrier2.Buffer pImageMemoryBarriers() {
        return VkDependencyInfo.npImageMemoryBarriers(this.address());
    }

    public VkDependencyInfo sType(@NativeType(value="VkStructureType") int value) {
        VkDependencyInfo.nsType(this.address(), value);
        return this;
    }

    public VkDependencyInfo sType$Default() {
        return this.sType(1000314003);
    }

    public VkDependencyInfo pNext(@NativeType(value="void const *") long value) {
        VkDependencyInfo.npNext(this.address(), value);
        return this;
    }

    public VkDependencyInfo dependencyFlags(@NativeType(value="VkDependencyFlags") int value) {
        VkDependencyInfo.ndependencyFlags(this.address(), value);
        return this;
    }

    public VkDependencyInfo pMemoryBarriers(@Nullable @NativeType(value="VkMemoryBarrier2 const *") VkMemoryBarrier2.Buffer value) {
        VkDependencyInfo.npMemoryBarriers(this.address(), value);
        return this;
    }

    public VkDependencyInfo pBufferMemoryBarriers(@Nullable @NativeType(value="VkBufferMemoryBarrier2 const *") VkBufferMemoryBarrier2.Buffer value) {
        VkDependencyInfo.npBufferMemoryBarriers(this.address(), value);
        return this;
    }

    public VkDependencyInfo pImageMemoryBarriers(@Nullable @NativeType(value="VkImageMemoryBarrier2 const *") VkImageMemoryBarrier2.Buffer value) {
        VkDependencyInfo.npImageMemoryBarriers(this.address(), value);
        return this;
    }

    public VkDependencyInfo set(int sType, long pNext, int dependencyFlags, @Nullable VkMemoryBarrier2.Buffer pMemoryBarriers, @Nullable VkBufferMemoryBarrier2.Buffer pBufferMemoryBarriers, @Nullable VkImageMemoryBarrier2.Buffer pImageMemoryBarriers) {
        this.sType(sType);
        this.pNext(pNext);
        this.dependencyFlags(dependencyFlags);
        this.pMemoryBarriers(pMemoryBarriers);
        this.pBufferMemoryBarriers(pBufferMemoryBarriers);
        this.pImageMemoryBarriers(pImageMemoryBarriers);
        return this;
    }

    public VkDependencyInfo set(VkDependencyInfo src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkDependencyInfo malloc() {
        return new VkDependencyInfo(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkDependencyInfo calloc() {
        return new VkDependencyInfo(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkDependencyInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkDependencyInfo(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkDependencyInfo create(long address) {
        return new VkDependencyInfo(address, null);
    }

    @Nullable
    public static VkDependencyInfo createSafe(long address) {
        return address == 0L ? null : new VkDependencyInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkDependencyInfo.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkDependencyInfo.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkDependencyInfo malloc(MemoryStack stack) {
        return new VkDependencyInfo(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkDependencyInfo calloc(MemoryStack stack) {
        return new VkDependencyInfo(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static int ndependencyFlags(long struct) {
        return UNSAFE.getInt(null, struct + (long)DEPENDENCYFLAGS);
    }

    public static int nmemoryBarrierCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)MEMORYBARRIERCOUNT);
    }

    @Nullable
    public static VkMemoryBarrier2.Buffer npMemoryBarriers(long struct) {
        return VkMemoryBarrier2.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)PMEMORYBARRIERS)), VkDependencyInfo.nmemoryBarrierCount(struct));
    }

    public static int nbufferMemoryBarrierCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)BUFFERMEMORYBARRIERCOUNT);
    }

    @Nullable
    public static VkBufferMemoryBarrier2.Buffer npBufferMemoryBarriers(long struct) {
        return VkBufferMemoryBarrier2.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)PBUFFERMEMORYBARRIERS)), VkDependencyInfo.nbufferMemoryBarrierCount(struct));
    }

    public static int nimageMemoryBarrierCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)IMAGEMEMORYBARRIERCOUNT);
    }

    @Nullable
    public static VkImageMemoryBarrier2.Buffer npImageMemoryBarriers(long struct) {
        return VkImageMemoryBarrier2.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)PIMAGEMEMORYBARRIERS)), VkDependencyInfo.nimageMemoryBarrierCount(struct));
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void ndependencyFlags(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)DEPENDENCYFLAGS, value);
    }

    public static void nmemoryBarrierCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MEMORYBARRIERCOUNT, value);
    }

    public static void npMemoryBarriers(long struct, @Nullable VkMemoryBarrier2.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PMEMORYBARRIERS), (long)MemoryUtil.memAddressSafe((Pointer)value));
        VkDependencyInfo.nmemoryBarrierCount(struct, value == null ? 0 : value.remaining());
    }

    public static void nbufferMemoryBarrierCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)BUFFERMEMORYBARRIERCOUNT, value);
    }

    public static void npBufferMemoryBarriers(long struct, @Nullable VkBufferMemoryBarrier2.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PBUFFERMEMORYBARRIERS), (long)MemoryUtil.memAddressSafe((Pointer)value));
        VkDependencyInfo.nbufferMemoryBarrierCount(struct, value == null ? 0 : value.remaining());
    }

    public static void nimageMemoryBarrierCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)IMAGEMEMORYBARRIERCOUNT, value);
    }

    public static void npImageMemoryBarriers(long struct, @Nullable VkImageMemoryBarrier2.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PIMAGEMEMORYBARRIERS), (long)MemoryUtil.memAddressSafe((Pointer)value));
        VkDependencyInfo.nimageMemoryBarrierCount(struct, value == null ? 0 : value.remaining());
    }

    public static void validate(long struct) {
        if (VkDependencyInfo.nmemoryBarrierCount(struct) != 0) {
            Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PMEMORYBARRIERS)));
        }
        if (VkDependencyInfo.nbufferMemoryBarrierCount(struct) != 0) {
            Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PBUFFERMEMORYBARRIERS)));
        }
        if (VkDependencyInfo.nimageMemoryBarrierCount(struct) != 0) {
            Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PIMAGEMEMORYBARRIERS)));
        }
    }

    static {
        Struct.Layout layout = VkDependencyInfo.__struct((Struct.Member[])new Struct.Member[]{VkDependencyInfo.__member((int)4), VkDependencyInfo.__member((int)POINTER_SIZE), VkDependencyInfo.__member((int)4), VkDependencyInfo.__member((int)4), VkDependencyInfo.__member((int)POINTER_SIZE), VkDependencyInfo.__member((int)4), VkDependencyInfo.__member((int)POINTER_SIZE), VkDependencyInfo.__member((int)4), VkDependencyInfo.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        DEPENDENCYFLAGS = layout.offsetof(2);
        MEMORYBARRIERCOUNT = layout.offsetof(3);
        PMEMORYBARRIERS = layout.offsetof(4);
        BUFFERMEMORYBARRIERCOUNT = layout.offsetof(5);
        PBUFFERMEMORYBARRIERS = layout.offsetof(6);
        IMAGEMEMORYBARRIERCOUNT = layout.offsetof(7);
        PIMAGEMEMORYBARRIERS = layout.offsetof(8);
    }

    public static class Buffer
    extends StructBuffer<VkDependencyInfo, Buffer>
    implements NativeResource {
        private static final VkDependencyInfo ELEMENT_FACTORY = VkDependencyInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkDependencyInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkDependencyInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkDependencyInfo.npNext(this.address());
        }

        @NativeType(value="VkDependencyFlags")
        public int dependencyFlags() {
            return VkDependencyInfo.ndependencyFlags(this.address());
        }

        @NativeType(value="uint32_t")
        public int memoryBarrierCount() {
            return VkDependencyInfo.nmemoryBarrierCount(this.address());
        }

        @Nullable
        @NativeType(value="VkMemoryBarrier2 const *")
        public VkMemoryBarrier2.Buffer pMemoryBarriers() {
            return VkDependencyInfo.npMemoryBarriers(this.address());
        }

        @NativeType(value="uint32_t")
        public int bufferMemoryBarrierCount() {
            return VkDependencyInfo.nbufferMemoryBarrierCount(this.address());
        }

        @Nullable
        @NativeType(value="VkBufferMemoryBarrier2 const *")
        public VkBufferMemoryBarrier2.Buffer pBufferMemoryBarriers() {
            return VkDependencyInfo.npBufferMemoryBarriers(this.address());
        }

        @NativeType(value="uint32_t")
        public int imageMemoryBarrierCount() {
            return VkDependencyInfo.nimageMemoryBarrierCount(this.address());
        }

        @Nullable
        @NativeType(value="VkImageMemoryBarrier2 const *")
        public VkImageMemoryBarrier2.Buffer pImageMemoryBarriers() {
            return VkDependencyInfo.npImageMemoryBarriers(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkDependencyInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000314003);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkDependencyInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer dependencyFlags(@NativeType(value="VkDependencyFlags") int value) {
            VkDependencyInfo.ndependencyFlags(this.address(), value);
            return this;
        }

        public Buffer pMemoryBarriers(@Nullable @NativeType(value="VkMemoryBarrier2 const *") VkMemoryBarrier2.Buffer value) {
            VkDependencyInfo.npMemoryBarriers(this.address(), value);
            return this;
        }

        public Buffer pBufferMemoryBarriers(@Nullable @NativeType(value="VkBufferMemoryBarrier2 const *") VkBufferMemoryBarrier2.Buffer value) {
            VkDependencyInfo.npBufferMemoryBarriers(this.address(), value);
            return this;
        }

        public Buffer pImageMemoryBarriers(@Nullable @NativeType(value="VkImageMemoryBarrier2 const *") VkImageMemoryBarrier2.Buffer value) {
            VkDependencyInfo.npImageMemoryBarriers(this.address(), value);
            return this;
        }
    }
}

