/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkImageCopy2;

public class VkCopyImageToImageInfoEXT
extends Struct<VkCopyImageToImageInfoEXT>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int SRCIMAGE;
    public static final int SRCIMAGELAYOUT;
    public static final int DSTIMAGE;
    public static final int DSTIMAGELAYOUT;
    public static final int REGIONCOUNT;
    public static final int PREGIONS;

    protected VkCopyImageToImageInfoEXT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkCopyImageToImageInfoEXT create(long address, @Nullable ByteBuffer container) {
        return new VkCopyImageToImageInfoEXT(address, container);
    }

    public VkCopyImageToImageInfoEXT(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkCopyImageToImageInfoEXT.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkCopyImageToImageInfoEXT.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkCopyImageToImageInfoEXT.npNext(this.address());
    }

    @NativeType(value="VkHostImageCopyFlagsEXT")
    public int flags() {
        return VkCopyImageToImageInfoEXT.nflags(this.address());
    }

    @NativeType(value="VkImage")
    public long srcImage() {
        return VkCopyImageToImageInfoEXT.nsrcImage(this.address());
    }

    @NativeType(value="VkImageLayout")
    public int srcImageLayout() {
        return VkCopyImageToImageInfoEXT.nsrcImageLayout(this.address());
    }

    @NativeType(value="VkImage")
    public long dstImage() {
        return VkCopyImageToImageInfoEXT.ndstImage(this.address());
    }

    @NativeType(value="VkImageLayout")
    public int dstImageLayout() {
        return VkCopyImageToImageInfoEXT.ndstImageLayout(this.address());
    }

    @NativeType(value="uint32_t")
    public int regionCount() {
        return VkCopyImageToImageInfoEXT.nregionCount(this.address());
    }

    @NativeType(value="VkImageCopy2 const *")
    public VkImageCopy2.Buffer pRegions() {
        return VkCopyImageToImageInfoEXT.npRegions(this.address());
    }

    public VkCopyImageToImageInfoEXT sType(@NativeType(value="VkStructureType") int value) {
        VkCopyImageToImageInfoEXT.nsType(this.address(), value);
        return this;
    }

    public VkCopyImageToImageInfoEXT sType$Default() {
        return this.sType(1000270007);
    }

    public VkCopyImageToImageInfoEXT pNext(@NativeType(value="void const *") long value) {
        VkCopyImageToImageInfoEXT.npNext(this.address(), value);
        return this;
    }

    public VkCopyImageToImageInfoEXT flags(@NativeType(value="VkHostImageCopyFlagsEXT") int value) {
        VkCopyImageToImageInfoEXT.nflags(this.address(), value);
        return this;
    }

    public VkCopyImageToImageInfoEXT srcImage(@NativeType(value="VkImage") long value) {
        VkCopyImageToImageInfoEXT.nsrcImage(this.address(), value);
        return this;
    }

    public VkCopyImageToImageInfoEXT srcImageLayout(@NativeType(value="VkImageLayout") int value) {
        VkCopyImageToImageInfoEXT.nsrcImageLayout(this.address(), value);
        return this;
    }

    public VkCopyImageToImageInfoEXT dstImage(@NativeType(value="VkImage") long value) {
        VkCopyImageToImageInfoEXT.ndstImage(this.address(), value);
        return this;
    }

    public VkCopyImageToImageInfoEXT dstImageLayout(@NativeType(value="VkImageLayout") int value) {
        VkCopyImageToImageInfoEXT.ndstImageLayout(this.address(), value);
        return this;
    }

    public VkCopyImageToImageInfoEXT pRegions(@NativeType(value="VkImageCopy2 const *") VkImageCopy2.Buffer value) {
        VkCopyImageToImageInfoEXT.npRegions(this.address(), value);
        return this;
    }

    public VkCopyImageToImageInfoEXT set(int sType, long pNext, int flags, long srcImage, int srcImageLayout, long dstImage, int dstImageLayout, VkImageCopy2.Buffer pRegions) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.srcImage(srcImage);
        this.srcImageLayout(srcImageLayout);
        this.dstImage(dstImage);
        this.dstImageLayout(dstImageLayout);
        this.pRegions(pRegions);
        return this;
    }

    public VkCopyImageToImageInfoEXT set(VkCopyImageToImageInfoEXT src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkCopyImageToImageInfoEXT malloc() {
        return new VkCopyImageToImageInfoEXT(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkCopyImageToImageInfoEXT calloc() {
        return new VkCopyImageToImageInfoEXT(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkCopyImageToImageInfoEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkCopyImageToImageInfoEXT(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkCopyImageToImageInfoEXT create(long address) {
        return new VkCopyImageToImageInfoEXT(address, null);
    }

    @Nullable
    public static VkCopyImageToImageInfoEXT createSafe(long address) {
        return address == 0L ? null : new VkCopyImageToImageInfoEXT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkCopyImageToImageInfoEXT.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkCopyImageToImageInfoEXT.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkCopyImageToImageInfoEXT malloc(MemoryStack stack) {
        return new VkCopyImageToImageInfoEXT(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkCopyImageToImageInfoEXT calloc(MemoryStack stack) {
        return new VkCopyImageToImageInfoEXT(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static int nflags(long struct) {
        return UNSAFE.getInt(null, struct + (long)FLAGS);
    }

    public static long nsrcImage(long struct) {
        return UNSAFE.getLong(null, struct + (long)SRCIMAGE);
    }

    public static int nsrcImageLayout(long struct) {
        return UNSAFE.getInt(null, struct + (long)SRCIMAGELAYOUT);
    }

    public static long ndstImage(long struct) {
        return UNSAFE.getLong(null, struct + (long)DSTIMAGE);
    }

    public static int ndstImageLayout(long struct) {
        return UNSAFE.getInt(null, struct + (long)DSTIMAGELAYOUT);
    }

    public static int nregionCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)REGIONCOUNT);
    }

    public static VkImageCopy2.Buffer npRegions(long struct) {
        return VkImageCopy2.create(MemoryUtil.memGetAddress((long)(struct + (long)PREGIONS)), VkCopyImageToImageInfoEXT.nregionCount(struct));
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void nflags(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FLAGS, value);
    }

    public static void nsrcImage(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)SRCIMAGE, value);
    }

    public static void nsrcImageLayout(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SRCIMAGELAYOUT, value);
    }

    public static void ndstImage(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)DSTIMAGE, value);
    }

    public static void ndstImageLayout(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)DSTIMAGELAYOUT, value);
    }

    public static void nregionCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)REGIONCOUNT, value);
    }

    public static void npRegions(long struct, VkImageCopy2.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PREGIONS), (long)value.address());
        VkCopyImageToImageInfoEXT.nregionCount(struct, value.remaining());
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PREGIONS)));
    }

    static {
        Struct.Layout layout = VkCopyImageToImageInfoEXT.__struct((Struct.Member[])new Struct.Member[]{VkCopyImageToImageInfoEXT.__member((int)4), VkCopyImageToImageInfoEXT.__member((int)POINTER_SIZE), VkCopyImageToImageInfoEXT.__member((int)4), VkCopyImageToImageInfoEXT.__member((int)8), VkCopyImageToImageInfoEXT.__member((int)4), VkCopyImageToImageInfoEXT.__member((int)8), VkCopyImageToImageInfoEXT.__member((int)4), VkCopyImageToImageInfoEXT.__member((int)4), VkCopyImageToImageInfoEXT.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        SRCIMAGE = layout.offsetof(3);
        SRCIMAGELAYOUT = layout.offsetof(4);
        DSTIMAGE = layout.offsetof(5);
        DSTIMAGELAYOUT = layout.offsetof(6);
        REGIONCOUNT = layout.offsetof(7);
        PREGIONS = layout.offsetof(8);
    }

    public static class Buffer
    extends StructBuffer<VkCopyImageToImageInfoEXT, Buffer>
    implements NativeResource {
        private static final VkCopyImageToImageInfoEXT ELEMENT_FACTORY = VkCopyImageToImageInfoEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkCopyImageToImageInfoEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkCopyImageToImageInfoEXT.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkCopyImageToImageInfoEXT.npNext(this.address());
        }

        @NativeType(value="VkHostImageCopyFlagsEXT")
        public int flags() {
            return VkCopyImageToImageInfoEXT.nflags(this.address());
        }

        @NativeType(value="VkImage")
        public long srcImage() {
            return VkCopyImageToImageInfoEXT.nsrcImage(this.address());
        }

        @NativeType(value="VkImageLayout")
        public int srcImageLayout() {
            return VkCopyImageToImageInfoEXT.nsrcImageLayout(this.address());
        }

        @NativeType(value="VkImage")
        public long dstImage() {
            return VkCopyImageToImageInfoEXT.ndstImage(this.address());
        }

        @NativeType(value="VkImageLayout")
        public int dstImageLayout() {
            return VkCopyImageToImageInfoEXT.ndstImageLayout(this.address());
        }

        @NativeType(value="uint32_t")
        public int regionCount() {
            return VkCopyImageToImageInfoEXT.nregionCount(this.address());
        }

        @NativeType(value="VkImageCopy2 const *")
        public VkImageCopy2.Buffer pRegions() {
            return VkCopyImageToImageInfoEXT.npRegions(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkCopyImageToImageInfoEXT.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000270007);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkCopyImageToImageInfoEXT.npNext(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="VkHostImageCopyFlagsEXT") int value) {
            VkCopyImageToImageInfoEXT.nflags(this.address(), value);
            return this;
        }

        public Buffer srcImage(@NativeType(value="VkImage") long value) {
            VkCopyImageToImageInfoEXT.nsrcImage(this.address(), value);
            return this;
        }

        public Buffer srcImageLayout(@NativeType(value="VkImageLayout") int value) {
            VkCopyImageToImageInfoEXT.nsrcImageLayout(this.address(), value);
            return this;
        }

        public Buffer dstImage(@NativeType(value="VkImage") long value) {
            VkCopyImageToImageInfoEXT.ndstImage(this.address(), value);
            return this;
        }

        public Buffer dstImageLayout(@NativeType(value="VkImageLayout") int value) {
            VkCopyImageToImageInfoEXT.ndstImageLayout(this.address(), value);
            return this;
        }

        public Buffer pRegions(@NativeType(value="VkImageCopy2 const *") VkImageCopy2.Buffer value) {
            VkCopyImageToImageInfoEXT.npRegions(this.address(), value);
            return this;
        }
    }
}

