/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkClearColorValue;
import org.lwjgl.vulkan.VkClearDepthStencilValue;

public class VkClearValue
extends Struct<VkClearValue>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int COLOR;
    public static final int DEPTHSTENCIL;

    protected VkClearValue(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkClearValue create(long address, @Nullable ByteBuffer container) {
        return new VkClearValue(address, container);
    }

    public VkClearValue(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkClearValue.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public VkClearColorValue color() {
        return VkClearValue.ncolor(this.address());
    }

    public VkClearDepthStencilValue depthStencil() {
        return VkClearValue.ndepthStencil(this.address());
    }

    public VkClearValue color(VkClearColorValue value) {
        VkClearValue.ncolor(this.address(), value);
        return this;
    }

    public VkClearValue color(Consumer<VkClearColorValue> consumer) {
        consumer.accept(this.color());
        return this;
    }

    public VkClearValue depthStencil(VkClearDepthStencilValue value) {
        VkClearValue.ndepthStencil(this.address(), value);
        return this;
    }

    public VkClearValue depthStencil(Consumer<VkClearDepthStencilValue> consumer) {
        consumer.accept(this.depthStencil());
        return this;
    }

    public VkClearValue set(VkClearValue src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkClearValue malloc() {
        return new VkClearValue(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkClearValue calloc() {
        return new VkClearValue(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkClearValue create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkClearValue(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkClearValue create(long address) {
        return new VkClearValue(address, null);
    }

    @Nullable
    public static VkClearValue createSafe(long address) {
        return address == 0L ? null : new VkClearValue(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkClearValue.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkClearValue.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkClearValue mallocStack() {
        return VkClearValue.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkClearValue callocStack() {
        return VkClearValue.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkClearValue mallocStack(MemoryStack stack) {
        return VkClearValue.malloc(stack);
    }

    @Deprecated
    public static VkClearValue callocStack(MemoryStack stack) {
        return VkClearValue.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkClearValue.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkClearValue.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkClearValue.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkClearValue.calloc(capacity, stack);
    }

    public static VkClearValue malloc(MemoryStack stack) {
        return new VkClearValue(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkClearValue calloc(MemoryStack stack) {
        return new VkClearValue(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static VkClearColorValue ncolor(long struct) {
        return VkClearColorValue.create(struct + (long)COLOR);
    }

    public static VkClearDepthStencilValue ndepthStencil(long struct) {
        return VkClearDepthStencilValue.create(struct + (long)DEPTHSTENCIL);
    }

    public static void ncolor(long struct, VkClearColorValue value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)COLOR), (long)VkClearColorValue.SIZEOF);
    }

    public static void ndepthStencil(long struct, VkClearDepthStencilValue value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)DEPTHSTENCIL), (long)VkClearDepthStencilValue.SIZEOF);
    }

    static {
        Struct.Layout layout = VkClearValue.__union((Struct.Member[])new Struct.Member[]{VkClearValue.__member((int)VkClearColorValue.SIZEOF, (int)VkClearColorValue.ALIGNOF), VkClearValue.__member((int)VkClearDepthStencilValue.SIZEOF, (int)VkClearDepthStencilValue.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        COLOR = layout.offsetof(0);
        DEPTHSTENCIL = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<VkClearValue, Buffer>
    implements NativeResource {
        private static final VkClearValue ELEMENT_FACTORY = VkClearValue.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkClearValue getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public VkClearColorValue color() {
            return VkClearValue.ncolor(this.address());
        }

        public VkClearDepthStencilValue depthStencil() {
            return VkClearValue.ndepthStencil(this.address());
        }

        public Buffer color(VkClearColorValue value) {
            VkClearValue.ncolor(this.address(), value);
            return this;
        }

        public Buffer color(Consumer<VkClearColorValue> consumer) {
            consumer.accept(this.color());
            return this;
        }

        public Buffer depthStencil(VkClearDepthStencilValue value) {
            VkClearValue.ndepthStencil(this.address(), value);
            return this;
        }

        public Buffer depthStencil(Consumer<VkClearDepthStencilValue> consumer) {
            consumer.accept(this.depthStencil());
            return this;
        }
    }
}

