/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkBindIndexBufferIndirectCommandNV
extends Struct<VkBindIndexBufferIndirectCommandNV>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int BUFFERADDRESS;
    public static final int SIZE;
    public static final int INDEXTYPE;

    protected VkBindIndexBufferIndirectCommandNV(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkBindIndexBufferIndirectCommandNV create(long address, @Nullable ByteBuffer container) {
        return new VkBindIndexBufferIndirectCommandNV(address, container);
    }

    public VkBindIndexBufferIndirectCommandNV(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkBindIndexBufferIndirectCommandNV.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkDeviceAddress")
    public long bufferAddress() {
        return VkBindIndexBufferIndirectCommandNV.nbufferAddress(this.address());
    }

    @NativeType(value="uint32_t")
    public int size() {
        return VkBindIndexBufferIndirectCommandNV.nsize(this.address());
    }

    @NativeType(value="VkIndexType")
    public int indexType() {
        return VkBindIndexBufferIndirectCommandNV.nindexType(this.address());
    }

    public VkBindIndexBufferIndirectCommandNV bufferAddress(@NativeType(value="VkDeviceAddress") long value) {
        VkBindIndexBufferIndirectCommandNV.nbufferAddress(this.address(), value);
        return this;
    }

    public VkBindIndexBufferIndirectCommandNV size(@NativeType(value="uint32_t") int value) {
        VkBindIndexBufferIndirectCommandNV.nsize(this.address(), value);
        return this;
    }

    public VkBindIndexBufferIndirectCommandNV indexType(@NativeType(value="VkIndexType") int value) {
        VkBindIndexBufferIndirectCommandNV.nindexType(this.address(), value);
        return this;
    }

    public VkBindIndexBufferIndirectCommandNV set(long bufferAddress, int size, int indexType) {
        this.bufferAddress(bufferAddress);
        this.size(size);
        this.indexType(indexType);
        return this;
    }

    public VkBindIndexBufferIndirectCommandNV set(VkBindIndexBufferIndirectCommandNV src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkBindIndexBufferIndirectCommandNV malloc() {
        return new VkBindIndexBufferIndirectCommandNV(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkBindIndexBufferIndirectCommandNV calloc() {
        return new VkBindIndexBufferIndirectCommandNV(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkBindIndexBufferIndirectCommandNV create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkBindIndexBufferIndirectCommandNV(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkBindIndexBufferIndirectCommandNV create(long address) {
        return new VkBindIndexBufferIndirectCommandNV(address, null);
    }

    @Nullable
    public static VkBindIndexBufferIndirectCommandNV createSafe(long address) {
        return address == 0L ? null : new VkBindIndexBufferIndirectCommandNV(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkBindIndexBufferIndirectCommandNV.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkBindIndexBufferIndirectCommandNV.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkBindIndexBufferIndirectCommandNV malloc(MemoryStack stack) {
        return new VkBindIndexBufferIndirectCommandNV(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkBindIndexBufferIndirectCommandNV calloc(MemoryStack stack) {
        return new VkBindIndexBufferIndirectCommandNV(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nbufferAddress(long struct) {
        return UNSAFE.getLong(null, struct + (long)BUFFERADDRESS);
    }

    public static int nsize(long struct) {
        return UNSAFE.getInt(null, struct + (long)SIZE);
    }

    public static int nindexType(long struct) {
        return UNSAFE.getInt(null, struct + (long)INDEXTYPE);
    }

    public static void nbufferAddress(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)BUFFERADDRESS, value);
    }

    public static void nsize(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SIZE, value);
    }

    public static void nindexType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)INDEXTYPE, value);
    }

    static {
        Struct.Layout layout = VkBindIndexBufferIndirectCommandNV.__struct((Struct.Member[])new Struct.Member[]{VkBindIndexBufferIndirectCommandNV.__member((int)8), VkBindIndexBufferIndirectCommandNV.__member((int)4), VkBindIndexBufferIndirectCommandNV.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        BUFFERADDRESS = layout.offsetof(0);
        SIZE = layout.offsetof(1);
        INDEXTYPE = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkBindIndexBufferIndirectCommandNV, Buffer>
    implements NativeResource {
        private static final VkBindIndexBufferIndirectCommandNV ELEMENT_FACTORY = VkBindIndexBufferIndirectCommandNV.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkBindIndexBufferIndirectCommandNV getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkDeviceAddress")
        public long bufferAddress() {
            return VkBindIndexBufferIndirectCommandNV.nbufferAddress(this.address());
        }

        @NativeType(value="uint32_t")
        public int size() {
            return VkBindIndexBufferIndirectCommandNV.nsize(this.address());
        }

        @NativeType(value="VkIndexType")
        public int indexType() {
            return VkBindIndexBufferIndirectCommandNV.nindexType(this.address());
        }

        public Buffer bufferAddress(@NativeType(value="VkDeviceAddress") long value) {
            VkBindIndexBufferIndirectCommandNV.nbufferAddress(this.address(), value);
            return this;
        }

        public Buffer size(@NativeType(value="uint32_t") int value) {
            VkBindIndexBufferIndirectCommandNV.nsize(this.address(), value);
            return this;
        }

        public Buffer indexType(@NativeType(value="VkIndexType") int value) {
            VkBindIndexBufferIndirectCommandNV.nindexType(this.address(), value);
            return this;
        }
    }
}

