/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkBindBufferMemoryDeviceGroupInfo;
import org.lwjgl.vulkan.VkBindBufferMemoryDeviceGroupInfoKHR;
import org.lwjgl.vulkan.VkBindMemoryStatusKHR;

public class VkBindBufferMemoryInfo
extends Struct<VkBindBufferMemoryInfo>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int BUFFER;
    public static final int MEMORY;
    public static final int MEMORYOFFSET;

    protected VkBindBufferMemoryInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkBindBufferMemoryInfo create(long address, @Nullable ByteBuffer container) {
        return new VkBindBufferMemoryInfo(address, container);
    }

    public VkBindBufferMemoryInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkBindBufferMemoryInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkBindBufferMemoryInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkBindBufferMemoryInfo.npNext(this.address());
    }

    @NativeType(value="VkBuffer")
    public long buffer() {
        return VkBindBufferMemoryInfo.nbuffer(this.address());
    }

    @NativeType(value="VkDeviceMemory")
    public long memory() {
        return VkBindBufferMemoryInfo.nmemory(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long memoryOffset() {
        return VkBindBufferMemoryInfo.nmemoryOffset(this.address());
    }

    public VkBindBufferMemoryInfo sType(@NativeType(value="VkStructureType") int value) {
        VkBindBufferMemoryInfo.nsType(this.address(), value);
        return this;
    }

    public VkBindBufferMemoryInfo sType$Default() {
        return this.sType(1000157000);
    }

    public VkBindBufferMemoryInfo pNext(@NativeType(value="void const *") long value) {
        VkBindBufferMemoryInfo.npNext(this.address(), value);
        return this;
    }

    public VkBindBufferMemoryInfo pNext(VkBindBufferMemoryDeviceGroupInfo value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkBindBufferMemoryInfo pNext(VkBindBufferMemoryDeviceGroupInfoKHR value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkBindBufferMemoryInfo pNext(VkBindMemoryStatusKHR value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkBindBufferMemoryInfo buffer(@NativeType(value="VkBuffer") long value) {
        VkBindBufferMemoryInfo.nbuffer(this.address(), value);
        return this;
    }

    public VkBindBufferMemoryInfo memory(@NativeType(value="VkDeviceMemory") long value) {
        VkBindBufferMemoryInfo.nmemory(this.address(), value);
        return this;
    }

    public VkBindBufferMemoryInfo memoryOffset(@NativeType(value="VkDeviceSize") long value) {
        VkBindBufferMemoryInfo.nmemoryOffset(this.address(), value);
        return this;
    }

    public VkBindBufferMemoryInfo set(int sType, long pNext, long buffer, long memory, long memoryOffset) {
        this.sType(sType);
        this.pNext(pNext);
        this.buffer(buffer);
        this.memory(memory);
        this.memoryOffset(memoryOffset);
        return this;
    }

    public VkBindBufferMemoryInfo set(VkBindBufferMemoryInfo src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkBindBufferMemoryInfo malloc() {
        return new VkBindBufferMemoryInfo(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkBindBufferMemoryInfo calloc() {
        return new VkBindBufferMemoryInfo(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkBindBufferMemoryInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkBindBufferMemoryInfo(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkBindBufferMemoryInfo create(long address) {
        return new VkBindBufferMemoryInfo(address, null);
    }

    @Nullable
    public static VkBindBufferMemoryInfo createSafe(long address) {
        return address == 0L ? null : new VkBindBufferMemoryInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkBindBufferMemoryInfo.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkBindBufferMemoryInfo.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkBindBufferMemoryInfo mallocStack() {
        return VkBindBufferMemoryInfo.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkBindBufferMemoryInfo callocStack() {
        return VkBindBufferMemoryInfo.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkBindBufferMemoryInfo mallocStack(MemoryStack stack) {
        return VkBindBufferMemoryInfo.malloc(stack);
    }

    @Deprecated
    public static VkBindBufferMemoryInfo callocStack(MemoryStack stack) {
        return VkBindBufferMemoryInfo.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkBindBufferMemoryInfo.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkBindBufferMemoryInfo.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkBindBufferMemoryInfo.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkBindBufferMemoryInfo.calloc(capacity, stack);
    }

    public static VkBindBufferMemoryInfo malloc(MemoryStack stack) {
        return new VkBindBufferMemoryInfo(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkBindBufferMemoryInfo calloc(MemoryStack stack) {
        return new VkBindBufferMemoryInfo(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static long nbuffer(long struct) {
        return UNSAFE.getLong(null, struct + (long)BUFFER);
    }

    public static long nmemory(long struct) {
        return UNSAFE.getLong(null, struct + (long)MEMORY);
    }

    public static long nmemoryOffset(long struct) {
        return UNSAFE.getLong(null, struct + (long)MEMORYOFFSET);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void nbuffer(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)BUFFER, value);
    }

    public static void nmemory(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)MEMORY, value);
    }

    public static void nmemoryOffset(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)MEMORYOFFSET, value);
    }

    static {
        Struct.Layout layout = VkBindBufferMemoryInfo.__struct((Struct.Member[])new Struct.Member[]{VkBindBufferMemoryInfo.__member((int)4), VkBindBufferMemoryInfo.__member((int)POINTER_SIZE), VkBindBufferMemoryInfo.__member((int)8), VkBindBufferMemoryInfo.__member((int)8), VkBindBufferMemoryInfo.__member((int)8)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        BUFFER = layout.offsetof(2);
        MEMORY = layout.offsetof(3);
        MEMORYOFFSET = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<VkBindBufferMemoryInfo, Buffer>
    implements NativeResource {
        private static final VkBindBufferMemoryInfo ELEMENT_FACTORY = VkBindBufferMemoryInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkBindBufferMemoryInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkBindBufferMemoryInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkBindBufferMemoryInfo.npNext(this.address());
        }

        @NativeType(value="VkBuffer")
        public long buffer() {
            return VkBindBufferMemoryInfo.nbuffer(this.address());
        }

        @NativeType(value="VkDeviceMemory")
        public long memory() {
            return VkBindBufferMemoryInfo.nmemory(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long memoryOffset() {
            return VkBindBufferMemoryInfo.nmemoryOffset(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkBindBufferMemoryInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000157000);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkBindBufferMemoryInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer pNext(VkBindBufferMemoryDeviceGroupInfo value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkBindBufferMemoryDeviceGroupInfoKHR value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkBindMemoryStatusKHR value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer buffer(@NativeType(value="VkBuffer") long value) {
            VkBindBufferMemoryInfo.nbuffer(this.address(), value);
            return this;
        }

        public Buffer memory(@NativeType(value="VkDeviceMemory") long value) {
            VkBindBufferMemoryInfo.nmemory(this.address(), value);
            return this;
        }

        public Buffer memoryOffset(@NativeType(value="VkDeviceSize") long value) {
            VkBindBufferMemoryInfo.nmemoryOffset(this.address(), value);
            return this;
        }
    }
}

