/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkBaseOutStructure
extends Struct<VkBaseOutStructure>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;

    protected VkBaseOutStructure(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkBaseOutStructure create(long address, @Nullable ByteBuffer container) {
        return new VkBaseOutStructure(address, container);
    }

    public VkBaseOutStructure(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkBaseOutStructure.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkBaseOutStructure.nsType(this.address());
    }

    @Nullable
    @NativeType(value="VkBaseOutStructure *")
    public VkBaseOutStructure pNext() {
        return VkBaseOutStructure.npNext(this.address());
    }

    public VkBaseOutStructure sType(@NativeType(value="VkStructureType") int value) {
        VkBaseOutStructure.nsType(this.address(), value);
        return this;
    }

    public VkBaseOutStructure pNext(@Nullable @NativeType(value="VkBaseOutStructure *") VkBaseOutStructure value) {
        VkBaseOutStructure.npNext(this.address(), value);
        return this;
    }

    public VkBaseOutStructure set(int sType, @Nullable VkBaseOutStructure pNext) {
        this.sType(sType);
        this.pNext(pNext);
        return this;
    }

    public VkBaseOutStructure set(VkBaseOutStructure src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkBaseOutStructure malloc() {
        return new VkBaseOutStructure(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkBaseOutStructure calloc() {
        return new VkBaseOutStructure(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkBaseOutStructure create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkBaseOutStructure(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkBaseOutStructure create(long address) {
        return new VkBaseOutStructure(address, null);
    }

    @Nullable
    public static VkBaseOutStructure createSafe(long address) {
        return address == 0L ? null : new VkBaseOutStructure(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkBaseOutStructure.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkBaseOutStructure.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkBaseOutStructure mallocStack() {
        return VkBaseOutStructure.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkBaseOutStructure callocStack() {
        return VkBaseOutStructure.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkBaseOutStructure mallocStack(MemoryStack stack) {
        return VkBaseOutStructure.malloc(stack);
    }

    @Deprecated
    public static VkBaseOutStructure callocStack(MemoryStack stack) {
        return VkBaseOutStructure.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkBaseOutStructure.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkBaseOutStructure.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkBaseOutStructure.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkBaseOutStructure.calloc(capacity, stack);
    }

    public static VkBaseOutStructure malloc(MemoryStack stack) {
        return new VkBaseOutStructure(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkBaseOutStructure calloc(MemoryStack stack) {
        return new VkBaseOutStructure(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    @Nullable
    public static VkBaseOutStructure npNext(long struct) {
        return VkBaseOutStructure.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)PNEXT)));
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, @Nullable VkBaseOutStructure value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    static {
        Struct.Layout layout = VkBaseOutStructure.__struct((Struct.Member[])new Struct.Member[]{VkBaseOutStructure.__member((int)4), VkBaseOutStructure.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<VkBaseOutStructure, Buffer>
    implements NativeResource {
        private static final VkBaseOutStructure ELEMENT_FACTORY = VkBaseOutStructure.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkBaseOutStructure getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkBaseOutStructure.nsType(this.address());
        }

        @Nullable
        @NativeType(value="VkBaseOutStructure *")
        public VkBaseOutStructure pNext() {
            return VkBaseOutStructure.npNext(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkBaseOutStructure.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@Nullable @NativeType(value="VkBaseOutStructure *") VkBaseOutStructure value) {
            VkBaseOutStructure.npNext(this.address(), value);
            return this;
        }
    }
}

