/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkAttachmentReferenceStencilLayout;
import org.lwjgl.vulkan.VkAttachmentReferenceStencilLayoutKHR;

public class VkAttachmentReference2
extends Struct<VkAttachmentReference2>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int ATTACHMENT;
    public static final int LAYOUT;
    public static final int ASPECTMASK;

    protected VkAttachmentReference2(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkAttachmentReference2 create(long address, @Nullable ByteBuffer container) {
        return new VkAttachmentReference2(address, container);
    }

    public VkAttachmentReference2(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkAttachmentReference2.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkAttachmentReference2.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkAttachmentReference2.npNext(this.address());
    }

    @NativeType(value="uint32_t")
    public int attachment() {
        return VkAttachmentReference2.nattachment(this.address());
    }

    @NativeType(value="VkImageLayout")
    public int layout() {
        return VkAttachmentReference2.nlayout(this.address());
    }

    @NativeType(value="VkImageAspectFlags")
    public int aspectMask() {
        return VkAttachmentReference2.naspectMask(this.address());
    }

    public VkAttachmentReference2 sType(@NativeType(value="VkStructureType") int value) {
        VkAttachmentReference2.nsType(this.address(), value);
        return this;
    }

    public VkAttachmentReference2 sType$Default() {
        return this.sType(1000109001);
    }

    public VkAttachmentReference2 pNext(@NativeType(value="void const *") long value) {
        VkAttachmentReference2.npNext(this.address(), value);
        return this;
    }

    public VkAttachmentReference2 pNext(VkAttachmentReferenceStencilLayout value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkAttachmentReference2 pNext(VkAttachmentReferenceStencilLayoutKHR value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkAttachmentReference2 attachment(@NativeType(value="uint32_t") int value) {
        VkAttachmentReference2.nattachment(this.address(), value);
        return this;
    }

    public VkAttachmentReference2 layout(@NativeType(value="VkImageLayout") int value) {
        VkAttachmentReference2.nlayout(this.address(), value);
        return this;
    }

    public VkAttachmentReference2 aspectMask(@NativeType(value="VkImageAspectFlags") int value) {
        VkAttachmentReference2.naspectMask(this.address(), value);
        return this;
    }

    public VkAttachmentReference2 set(int sType, long pNext, int attachment, int layout, int aspectMask) {
        this.sType(sType);
        this.pNext(pNext);
        this.attachment(attachment);
        this.layout(layout);
        this.aspectMask(aspectMask);
        return this;
    }

    public VkAttachmentReference2 set(VkAttachmentReference2 src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkAttachmentReference2 malloc() {
        return new VkAttachmentReference2(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkAttachmentReference2 calloc() {
        return new VkAttachmentReference2(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkAttachmentReference2 create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkAttachmentReference2(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkAttachmentReference2 create(long address) {
        return new VkAttachmentReference2(address, null);
    }

    @Nullable
    public static VkAttachmentReference2 createSafe(long address) {
        return address == 0L ? null : new VkAttachmentReference2(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkAttachmentReference2.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkAttachmentReference2.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkAttachmentReference2 malloc(MemoryStack stack) {
        return new VkAttachmentReference2(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkAttachmentReference2 calloc(MemoryStack stack) {
        return new VkAttachmentReference2(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static int nattachment(long struct) {
        return UNSAFE.getInt(null, struct + (long)ATTACHMENT);
    }

    public static int nlayout(long struct) {
        return UNSAFE.getInt(null, struct + (long)LAYOUT);
    }

    public static int naspectMask(long struct) {
        return UNSAFE.getInt(null, struct + (long)ASPECTMASK);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void nattachment(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)ATTACHMENT, value);
    }

    public static void nlayout(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)LAYOUT, value);
    }

    public static void naspectMask(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)ASPECTMASK, value);
    }

    static {
        Struct.Layout layout = VkAttachmentReference2.__struct((Struct.Member[])new Struct.Member[]{VkAttachmentReference2.__member((int)4), VkAttachmentReference2.__member((int)POINTER_SIZE), VkAttachmentReference2.__member((int)4), VkAttachmentReference2.__member((int)4), VkAttachmentReference2.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        ATTACHMENT = layout.offsetof(2);
        LAYOUT = layout.offsetof(3);
        ASPECTMASK = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<VkAttachmentReference2, Buffer>
    implements NativeResource {
        private static final VkAttachmentReference2 ELEMENT_FACTORY = VkAttachmentReference2.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkAttachmentReference2 getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkAttachmentReference2.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkAttachmentReference2.npNext(this.address());
        }

        @NativeType(value="uint32_t")
        public int attachment() {
            return VkAttachmentReference2.nattachment(this.address());
        }

        @NativeType(value="VkImageLayout")
        public int layout() {
            return VkAttachmentReference2.nlayout(this.address());
        }

        @NativeType(value="VkImageAspectFlags")
        public int aspectMask() {
            return VkAttachmentReference2.naspectMask(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkAttachmentReference2.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000109001);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkAttachmentReference2.npNext(this.address(), value);
            return this;
        }

        public Buffer pNext(VkAttachmentReferenceStencilLayout value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkAttachmentReferenceStencilLayoutKHR value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer attachment(@NativeType(value="uint32_t") int value) {
            VkAttachmentReference2.nattachment(this.address(), value);
            return this;
        }

        public Buffer layout(@NativeType(value="VkImageLayout") int value) {
            VkAttachmentReference2.nlayout(this.address(), value);
            return this;
        }

        public Buffer aspectMask(@NativeType(value="VkImageAspectFlags") int value) {
            VkAttachmentReference2.naspectMask(this.address(), value);
            return this;
        }
    }
}

