/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkTransformMatrixKHR;

public class VkAccelerationStructureInstanceKHR
extends Struct<VkAccelerationStructureInstanceKHR>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TRANSFORM;
    public static final int BITFIELD0;
    public static final int BITFIELD1;
    public static final int ACCELERATIONSTRUCTUREREFERENCE;

    protected VkAccelerationStructureInstanceKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkAccelerationStructureInstanceKHR create(long address, @Nullable ByteBuffer container) {
        return new VkAccelerationStructureInstanceKHR(address, container);
    }

    public VkAccelerationStructureInstanceKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkAccelerationStructureInstanceKHR.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public VkTransformMatrixKHR transform() {
        return VkAccelerationStructureInstanceKHR.ntransform(this.address());
    }

    @NativeType(value="uint32_t")
    public int instanceCustomIndex() {
        return VkAccelerationStructureInstanceKHR.ninstanceCustomIndex(this.address());
    }

    @NativeType(value="uint32_t")
    public int mask() {
        return VkAccelerationStructureInstanceKHR.nmask(this.address());
    }

    @NativeType(value="uint32_t")
    public int instanceShaderBindingTableRecordOffset() {
        return VkAccelerationStructureInstanceKHR.ninstanceShaderBindingTableRecordOffset(this.address());
    }

    @NativeType(value="VkGeometryInstanceFlagsKHR")
    public int flags() {
        return VkAccelerationStructureInstanceKHR.nflags(this.address());
    }

    @NativeType(value="uint64_t")
    public long accelerationStructureReference() {
        return VkAccelerationStructureInstanceKHR.naccelerationStructureReference(this.address());
    }

    public VkAccelerationStructureInstanceKHR transform(VkTransformMatrixKHR value) {
        VkAccelerationStructureInstanceKHR.ntransform(this.address(), value);
        return this;
    }

    public VkAccelerationStructureInstanceKHR transform(Consumer<VkTransformMatrixKHR> consumer) {
        consumer.accept(this.transform());
        return this;
    }

    public VkAccelerationStructureInstanceKHR instanceCustomIndex(@NativeType(value="uint32_t") int value) {
        VkAccelerationStructureInstanceKHR.ninstanceCustomIndex(this.address(), value);
        return this;
    }

    public VkAccelerationStructureInstanceKHR mask(@NativeType(value="uint32_t") int value) {
        VkAccelerationStructureInstanceKHR.nmask(this.address(), value);
        return this;
    }

    public VkAccelerationStructureInstanceKHR instanceShaderBindingTableRecordOffset(@NativeType(value="uint32_t") int value) {
        VkAccelerationStructureInstanceKHR.ninstanceShaderBindingTableRecordOffset(this.address(), value);
        return this;
    }

    public VkAccelerationStructureInstanceKHR flags(@NativeType(value="VkGeometryInstanceFlagsKHR") int value) {
        VkAccelerationStructureInstanceKHR.nflags(this.address(), value);
        return this;
    }

    public VkAccelerationStructureInstanceKHR accelerationStructureReference(@NativeType(value="uint64_t") long value) {
        VkAccelerationStructureInstanceKHR.naccelerationStructureReference(this.address(), value);
        return this;
    }

    public VkAccelerationStructureInstanceKHR set(VkTransformMatrixKHR transform, int instanceCustomIndex, int mask, int instanceShaderBindingTableRecordOffset, int flags, long accelerationStructureReference) {
        this.transform(transform);
        this.instanceCustomIndex(instanceCustomIndex);
        this.mask(mask);
        this.instanceShaderBindingTableRecordOffset(instanceShaderBindingTableRecordOffset);
        this.flags(flags);
        this.accelerationStructureReference(accelerationStructureReference);
        return this;
    }

    public VkAccelerationStructureInstanceKHR set(VkAccelerationStructureInstanceKHR src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkAccelerationStructureInstanceKHR malloc() {
        return new VkAccelerationStructureInstanceKHR(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkAccelerationStructureInstanceKHR calloc() {
        return new VkAccelerationStructureInstanceKHR(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkAccelerationStructureInstanceKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkAccelerationStructureInstanceKHR(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkAccelerationStructureInstanceKHR create(long address) {
        return new VkAccelerationStructureInstanceKHR(address, null);
    }

    @Nullable
    public static VkAccelerationStructureInstanceKHR createSafe(long address) {
        return address == 0L ? null : new VkAccelerationStructureInstanceKHR(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkAccelerationStructureInstanceKHR.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkAccelerationStructureInstanceKHR.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkAccelerationStructureInstanceKHR malloc(MemoryStack stack) {
        return new VkAccelerationStructureInstanceKHR(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkAccelerationStructureInstanceKHR calloc(MemoryStack stack) {
        return new VkAccelerationStructureInstanceKHR(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static VkTransformMatrixKHR ntransform(long struct) {
        return VkTransformMatrixKHR.create(struct + (long)TRANSFORM);
    }

    public static int nbitfield0(long struct) {
        return UNSAFE.getInt(null, struct + (long)BITFIELD0);
    }

    public static int ninstanceCustomIndex(long struct) {
        return VkAccelerationStructureInstanceKHR.nbitfield0(struct) & 0xFFFFFF;
    }

    public static int nmask(long struct) {
        return VkAccelerationStructureInstanceKHR.nbitfield0(struct) >>> 24;
    }

    public static int nbitfield1(long struct) {
        return UNSAFE.getInt(null, struct + (long)BITFIELD1);
    }

    public static int ninstanceShaderBindingTableRecordOffset(long struct) {
        return VkAccelerationStructureInstanceKHR.nbitfield1(struct) & 0xFFFFFF;
    }

    public static int nflags(long struct) {
        return VkAccelerationStructureInstanceKHR.nbitfield1(struct) >>> 24;
    }

    public static long naccelerationStructureReference(long struct) {
        return UNSAFE.getLong(null, struct + (long)ACCELERATIONSTRUCTUREREFERENCE);
    }

    public static void ntransform(long struct, VkTransformMatrixKHR value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)TRANSFORM), (long)VkTransformMatrixKHR.SIZEOF);
    }

    public static void nbitfield0(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)BITFIELD0, value);
    }

    public static void ninstanceCustomIndex(long struct, int value) {
        VkAccelerationStructureInstanceKHR.nbitfield0(struct, VkAccelerationStructureInstanceKHR.nbitfield0(struct) & 0xFF000000 | value & 0xFFFFFF);
    }

    public static void nmask(long struct, int value) {
        VkAccelerationStructureInstanceKHR.nbitfield0(struct, value << 24 | VkAccelerationStructureInstanceKHR.nbitfield0(struct) & 0xFFFFFF);
    }

    public static void nbitfield1(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)BITFIELD1, value);
    }

    public static void ninstanceShaderBindingTableRecordOffset(long struct, int value) {
        VkAccelerationStructureInstanceKHR.nbitfield1(struct, VkAccelerationStructureInstanceKHR.nbitfield1(struct) & 0xFF000000 | value & 0xFFFFFF);
    }

    public static void nflags(long struct, int value) {
        VkAccelerationStructureInstanceKHR.nbitfield1(struct, value << 24 | VkAccelerationStructureInstanceKHR.nbitfield1(struct) & 0xFFFFFF);
    }

    public static void naccelerationStructureReference(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)ACCELERATIONSTRUCTUREREFERENCE, value);
    }

    static {
        Struct.Layout layout = VkAccelerationStructureInstanceKHR.__struct((Struct.Member[])new Struct.Member[]{VkAccelerationStructureInstanceKHR.__member((int)VkTransformMatrixKHR.SIZEOF, (int)VkTransformMatrixKHR.ALIGNOF), VkAccelerationStructureInstanceKHR.__member((int)4), VkAccelerationStructureInstanceKHR.__member((int)4), VkAccelerationStructureInstanceKHR.__member((int)8)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TRANSFORM = layout.offsetof(0);
        BITFIELD0 = layout.offsetof(1);
        BITFIELD1 = layout.offsetof(2);
        ACCELERATIONSTRUCTUREREFERENCE = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkAccelerationStructureInstanceKHR, Buffer>
    implements NativeResource {
        private static final VkAccelerationStructureInstanceKHR ELEMENT_FACTORY = VkAccelerationStructureInstanceKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkAccelerationStructureInstanceKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public VkTransformMatrixKHR transform() {
            return VkAccelerationStructureInstanceKHR.ntransform(this.address());
        }

        @NativeType(value="uint32_t")
        public int instanceCustomIndex() {
            return VkAccelerationStructureInstanceKHR.ninstanceCustomIndex(this.address());
        }

        @NativeType(value="uint32_t")
        public int mask() {
            return VkAccelerationStructureInstanceKHR.nmask(this.address());
        }

        @NativeType(value="uint32_t")
        public int instanceShaderBindingTableRecordOffset() {
            return VkAccelerationStructureInstanceKHR.ninstanceShaderBindingTableRecordOffset(this.address());
        }

        @NativeType(value="VkGeometryInstanceFlagsKHR")
        public int flags() {
            return VkAccelerationStructureInstanceKHR.nflags(this.address());
        }

        @NativeType(value="uint64_t")
        public long accelerationStructureReference() {
            return VkAccelerationStructureInstanceKHR.naccelerationStructureReference(this.address());
        }

        public Buffer transform(VkTransformMatrixKHR value) {
            VkAccelerationStructureInstanceKHR.ntransform(this.address(), value);
            return this;
        }

        public Buffer transform(Consumer<VkTransformMatrixKHR> consumer) {
            consumer.accept(this.transform());
            return this;
        }

        public Buffer instanceCustomIndex(@NativeType(value="uint32_t") int value) {
            VkAccelerationStructureInstanceKHR.ninstanceCustomIndex(this.address(), value);
            return this;
        }

        public Buffer mask(@NativeType(value="uint32_t") int value) {
            VkAccelerationStructureInstanceKHR.nmask(this.address(), value);
            return this;
        }

        public Buffer instanceShaderBindingTableRecordOffset(@NativeType(value="uint32_t") int value) {
            VkAccelerationStructureInstanceKHR.ninstanceShaderBindingTableRecordOffset(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="VkGeometryInstanceFlagsKHR") int value) {
            VkAccelerationStructureInstanceKHR.nflags(this.address(), value);
            return this;
        }

        public Buffer accelerationStructureReference(@NativeType(value="uint64_t") long value) {
            VkAccelerationStructureInstanceKHR.naccelerationStructureReference(this.address(), value);
            return this;
        }
    }
}

