/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkAccelerationStructureGeometryDataKHR;

public class VkAccelerationStructureGeometryKHR
extends Struct<VkAccelerationStructureGeometryKHR>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int GEOMETRYTYPE;
    public static final int GEOMETRY;
    public static final int FLAGS;

    protected VkAccelerationStructureGeometryKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkAccelerationStructureGeometryKHR create(long address, @Nullable ByteBuffer container) {
        return new VkAccelerationStructureGeometryKHR(address, container);
    }

    public VkAccelerationStructureGeometryKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkAccelerationStructureGeometryKHR.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkAccelerationStructureGeometryKHR.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkAccelerationStructureGeometryKHR.npNext(this.address());
    }

    @NativeType(value="VkGeometryTypeKHR")
    public int geometryType() {
        return VkAccelerationStructureGeometryKHR.ngeometryType(this.address());
    }

    public VkAccelerationStructureGeometryDataKHR geometry() {
        return VkAccelerationStructureGeometryKHR.ngeometry(this.address());
    }

    @NativeType(value="VkGeometryFlagsKHR")
    public int flags() {
        return VkAccelerationStructureGeometryKHR.nflags(this.address());
    }

    public VkAccelerationStructureGeometryKHR sType(@NativeType(value="VkStructureType") int value) {
        VkAccelerationStructureGeometryKHR.nsType(this.address(), value);
        return this;
    }

    public VkAccelerationStructureGeometryKHR sType$Default() {
        return this.sType(1000150006);
    }

    public VkAccelerationStructureGeometryKHR pNext(@NativeType(value="void const *") long value) {
        VkAccelerationStructureGeometryKHR.npNext(this.address(), value);
        return this;
    }

    public VkAccelerationStructureGeometryKHR geometryType(@NativeType(value="VkGeometryTypeKHR") int value) {
        VkAccelerationStructureGeometryKHR.ngeometryType(this.address(), value);
        return this;
    }

    public VkAccelerationStructureGeometryKHR geometry(VkAccelerationStructureGeometryDataKHR value) {
        VkAccelerationStructureGeometryKHR.ngeometry(this.address(), value);
        return this;
    }

    public VkAccelerationStructureGeometryKHR geometry(Consumer<VkAccelerationStructureGeometryDataKHR> consumer) {
        consumer.accept(this.geometry());
        return this;
    }

    public VkAccelerationStructureGeometryKHR flags(@NativeType(value="VkGeometryFlagsKHR") int value) {
        VkAccelerationStructureGeometryKHR.nflags(this.address(), value);
        return this;
    }

    public VkAccelerationStructureGeometryKHR set(int sType, long pNext, int geometryType, VkAccelerationStructureGeometryDataKHR geometry, int flags) {
        this.sType(sType);
        this.pNext(pNext);
        this.geometryType(geometryType);
        this.geometry(geometry);
        this.flags(flags);
        return this;
    }

    public VkAccelerationStructureGeometryKHR set(VkAccelerationStructureGeometryKHR src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkAccelerationStructureGeometryKHR malloc() {
        return new VkAccelerationStructureGeometryKHR(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkAccelerationStructureGeometryKHR calloc() {
        return new VkAccelerationStructureGeometryKHR(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkAccelerationStructureGeometryKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkAccelerationStructureGeometryKHR(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkAccelerationStructureGeometryKHR create(long address) {
        return new VkAccelerationStructureGeometryKHR(address, null);
    }

    @Nullable
    public static VkAccelerationStructureGeometryKHR createSafe(long address) {
        return address == 0L ? null : new VkAccelerationStructureGeometryKHR(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkAccelerationStructureGeometryKHR.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkAccelerationStructureGeometryKHR.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkAccelerationStructureGeometryKHR malloc(MemoryStack stack) {
        return new VkAccelerationStructureGeometryKHR(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkAccelerationStructureGeometryKHR calloc(MemoryStack stack) {
        return new VkAccelerationStructureGeometryKHR(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static int ngeometryType(long struct) {
        return UNSAFE.getInt(null, struct + (long)GEOMETRYTYPE);
    }

    public static VkAccelerationStructureGeometryDataKHR ngeometry(long struct) {
        return VkAccelerationStructureGeometryDataKHR.create(struct + (long)GEOMETRY);
    }

    public static int nflags(long struct) {
        return UNSAFE.getInt(null, struct + (long)FLAGS);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void ngeometryType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)GEOMETRYTYPE, value);
    }

    public static void ngeometry(long struct, VkAccelerationStructureGeometryDataKHR value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)GEOMETRY), (long)VkAccelerationStructureGeometryDataKHR.SIZEOF);
    }

    public static void nflags(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FLAGS, value);
    }

    static {
        Struct.Layout layout = VkAccelerationStructureGeometryKHR.__struct((Struct.Member[])new Struct.Member[]{VkAccelerationStructureGeometryKHR.__member((int)4), VkAccelerationStructureGeometryKHR.__member((int)POINTER_SIZE), VkAccelerationStructureGeometryKHR.__member((int)4), VkAccelerationStructureGeometryKHR.__member((int)VkAccelerationStructureGeometryDataKHR.SIZEOF, (int)VkAccelerationStructureGeometryDataKHR.ALIGNOF), VkAccelerationStructureGeometryKHR.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        GEOMETRYTYPE = layout.offsetof(2);
        GEOMETRY = layout.offsetof(3);
        FLAGS = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<VkAccelerationStructureGeometryKHR, Buffer>
    implements NativeResource {
        private static final VkAccelerationStructureGeometryKHR ELEMENT_FACTORY = VkAccelerationStructureGeometryKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkAccelerationStructureGeometryKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkAccelerationStructureGeometryKHR.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkAccelerationStructureGeometryKHR.npNext(this.address());
        }

        @NativeType(value="VkGeometryTypeKHR")
        public int geometryType() {
            return VkAccelerationStructureGeometryKHR.ngeometryType(this.address());
        }

        public VkAccelerationStructureGeometryDataKHR geometry() {
            return VkAccelerationStructureGeometryKHR.ngeometry(this.address());
        }

        @NativeType(value="VkGeometryFlagsKHR")
        public int flags() {
            return VkAccelerationStructureGeometryKHR.nflags(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkAccelerationStructureGeometryKHR.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000150006);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkAccelerationStructureGeometryKHR.npNext(this.address(), value);
            return this;
        }

        public Buffer geometryType(@NativeType(value="VkGeometryTypeKHR") int value) {
            VkAccelerationStructureGeometryKHR.ngeometryType(this.address(), value);
            return this;
        }

        public Buffer geometry(VkAccelerationStructureGeometryDataKHR value) {
            VkAccelerationStructureGeometryKHR.ngeometry(this.address(), value);
            return this;
        }

        public Buffer geometry(Consumer<VkAccelerationStructureGeometryDataKHR> consumer) {
            consumer.accept(this.geometry());
            return this;
        }

        public Buffer flags(@NativeType(value="VkGeometryFlagsKHR") int value) {
            VkAccelerationStructureGeometryKHR.nflags(this.address(), value);
            return this;
        }
    }
}

