/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.util.Set;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;

public class VKCapabilitiesInstance {
    public final long vkDestroyInstance;
    public final long vkEnumeratePhysicalDevices;
    public final long vkGetPhysicalDeviceFeatures;
    public final long vkGetPhysicalDeviceFormatProperties;
    public final long vkGetPhysicalDeviceImageFormatProperties;
    public final long vkGetPhysicalDeviceProperties;
    public final long vkGetPhysicalDeviceQueueFamilyProperties;
    public final long vkGetPhysicalDeviceMemoryProperties;
    public final long vkCreateDevice;
    public final long vkEnumerateDeviceExtensionProperties;
    public final long vkEnumerateDeviceLayerProperties;
    public final long vkGetPhysicalDeviceSparseImageFormatProperties;
    public final long vkEnumeratePhysicalDeviceGroups;
    public final long vkGetPhysicalDeviceFeatures2;
    public final long vkGetPhysicalDeviceProperties2;
    public final long vkGetPhysicalDeviceFormatProperties2;
    public final long vkGetPhysicalDeviceImageFormatProperties2;
    public final long vkGetPhysicalDeviceQueueFamilyProperties2;
    public final long vkGetPhysicalDeviceMemoryProperties2;
    public final long vkGetPhysicalDeviceSparseImageFormatProperties2;
    public final long vkGetPhysicalDeviceExternalBufferProperties;
    public final long vkGetPhysicalDeviceExternalFenceProperties;
    public final long vkGetPhysicalDeviceExternalSemaphoreProperties;
    public final long vkGetPhysicalDeviceToolProperties;
    public final long vkAcquireDrmDisplayEXT;
    public final long vkGetDrmDisplayEXT;
    public final long vkAcquireXlibDisplayEXT;
    public final long vkGetRandROutputDisplayEXT;
    public final long vkGetPhysicalDeviceCalibrateableTimeDomainsEXT;
    public final long vkCreateDebugReportCallbackEXT;
    public final long vkDestroyDebugReportCallbackEXT;
    public final long vkDebugReportMessageEXT;
    public final long vkSetDebugUtilsObjectNameEXT;
    public final long vkSetDebugUtilsObjectTagEXT;
    public final long vkQueueBeginDebugUtilsLabelEXT;
    public final long vkQueueEndDebugUtilsLabelEXT;
    public final long vkQueueInsertDebugUtilsLabelEXT;
    public final long vkCmdBeginDebugUtilsLabelEXT;
    public final long vkCmdEndDebugUtilsLabelEXT;
    public final long vkCmdInsertDebugUtilsLabelEXT;
    public final long vkCreateDebugUtilsMessengerEXT;
    public final long vkDestroyDebugUtilsMessengerEXT;
    public final long vkSubmitDebugUtilsMessageEXT;
    public final long vkReleaseDisplayEXT;
    public final long vkCreateDirectFBSurfaceEXT;
    public final long vkGetPhysicalDeviceDirectFBPresentationSupportEXT;
    public final long vkGetPhysicalDeviceSurfaceCapabilities2EXT;
    public final long vkGetPhysicalDeviceSurfacePresentModes2EXT;
    public final long vkCreateHeadlessSurfaceEXT;
    public final long vkCreateMetalSurfaceEXT;
    public final long vkGetPhysicalDeviceMultisamplePropertiesEXT;
    public final long vkGetPhysicalDeviceToolPropertiesEXT;
    public final long vkCreateAndroidSurfaceKHR;
    public final long vkGetPhysicalDeviceCalibrateableTimeDomainsKHR;
    public final long vkGetPhysicalDeviceCooperativeMatrixPropertiesKHR;
    public final long vkGetPhysicalDevicePresentRectanglesKHR;
    public final long vkEnumeratePhysicalDeviceGroupsKHR;
    public final long vkGetPhysicalDeviceDisplayPropertiesKHR;
    public final long vkGetPhysicalDeviceDisplayPlanePropertiesKHR;
    public final long vkGetDisplayPlaneSupportedDisplaysKHR;
    public final long vkGetDisplayModePropertiesKHR;
    public final long vkCreateDisplayModeKHR;
    public final long vkGetDisplayPlaneCapabilitiesKHR;
    public final long vkCreateDisplayPlaneSurfaceKHR;
    public final long vkGetPhysicalDeviceExternalFencePropertiesKHR;
    public final long vkGetPhysicalDeviceExternalBufferPropertiesKHR;
    public final long vkGetPhysicalDeviceExternalSemaphorePropertiesKHR;
    public final long vkGetPhysicalDeviceFragmentShadingRatesKHR;
    public final long vkGetPhysicalDeviceDisplayProperties2KHR;
    public final long vkGetPhysicalDeviceDisplayPlaneProperties2KHR;
    public final long vkGetDisplayModeProperties2KHR;
    public final long vkGetDisplayPlaneCapabilities2KHR;
    public final long vkGetPhysicalDeviceFeatures2KHR;
    public final long vkGetPhysicalDeviceProperties2KHR;
    public final long vkGetPhysicalDeviceFormatProperties2KHR;
    public final long vkGetPhysicalDeviceImageFormatProperties2KHR;
    public final long vkGetPhysicalDeviceQueueFamilyProperties2KHR;
    public final long vkGetPhysicalDeviceMemoryProperties2KHR;
    public final long vkGetPhysicalDeviceSparseImageFormatProperties2KHR;
    public final long vkGetPhysicalDeviceSurfaceCapabilities2KHR;
    public final long vkGetPhysicalDeviceSurfaceFormats2KHR;
    public final long vkEnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR;
    public final long vkGetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR;
    public final long vkDestroySurfaceKHR;
    public final long vkGetPhysicalDeviceSurfaceSupportKHR;
    public final long vkGetPhysicalDeviceSurfaceCapabilitiesKHR;
    public final long vkGetPhysicalDeviceSurfaceFormatsKHR;
    public final long vkGetPhysicalDeviceSurfacePresentModesKHR;
    public final long vkGetPhysicalDeviceVideoEncodeQualityLevelPropertiesKHR;
    public final long vkGetPhysicalDeviceVideoCapabilitiesKHR;
    public final long vkGetPhysicalDeviceVideoFormatPropertiesKHR;
    public final long vkCreateWaylandSurfaceKHR;
    public final long vkGetPhysicalDeviceWaylandPresentationSupportKHR;
    public final long vkCreateWin32SurfaceKHR;
    public final long vkGetPhysicalDeviceWin32PresentationSupportKHR;
    public final long vkCreateXcbSurfaceKHR;
    public final long vkGetPhysicalDeviceXcbPresentationSupportKHR;
    public final long vkCreateXlibSurfaceKHR;
    public final long vkGetPhysicalDeviceXlibPresentationSupportKHR;
    public final long vkCreateMacOSSurfaceMVK;
    public final long vkAcquireWinrtDisplayNV;
    public final long vkGetWinrtDisplayNV;
    public final long vkGetPhysicalDeviceCooperativeMatrixPropertiesNV;
    public final long vkGetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV;
    public final long vkGetPhysicalDeviceExternalImageFormatPropertiesNV;
    public final long vkGetPhysicalDeviceOpticalFlowImageFormatsNV;
    public final int apiVersion;
    public final boolean Vulkan10;
    public final boolean Vulkan11;
    public final boolean Vulkan12;
    public final boolean Vulkan13;
    public final boolean VK_EXT_acquire_drm_display;
    public final boolean VK_EXT_acquire_xlib_display;
    public final boolean VK_EXT_debug_report;
    public final boolean VK_EXT_debug_utils;
    public final boolean VK_EXT_direct_mode_display;
    public final boolean VK_EXT_directfb_surface;
    public final boolean VK_EXT_display_surface_counter;
    public final boolean VK_EXT_headless_surface;
    public final boolean VK_EXT_layer_settings;
    public final boolean VK_EXT_metal_surface;
    public final boolean VK_EXT_surface_maintenance1;
    public final boolean VK_EXT_swapchain_colorspace;
    public final boolean VK_EXT_validation_features;
    public final boolean VK_EXT_validation_flags;
    public final boolean VK_GOOGLE_surfaceless_query;
    public final boolean VK_KHR_android_surface;
    public final boolean VK_KHR_device_group_creation;
    public final boolean VK_KHR_display;
    public final boolean VK_KHR_external_fence_capabilities;
    public final boolean VK_KHR_external_memory_capabilities;
    public final boolean VK_KHR_external_semaphore_capabilities;
    public final boolean VK_KHR_get_display_properties2;
    public final boolean VK_KHR_get_physical_device_properties2;
    public final boolean VK_KHR_get_surface_capabilities2;
    public final boolean VK_KHR_portability_enumeration;
    public final boolean VK_KHR_surface;
    public final boolean VK_KHR_surface_protected_capabilities;
    public final boolean VK_KHR_wayland_surface;
    public final boolean VK_KHR_win32_surface;
    public final boolean VK_KHR_xcb_surface;
    public final boolean VK_KHR_xlib_surface;
    public final boolean VK_LUNARG_direct_driver_loading;
    public final boolean VK_MVK_macos_surface;
    public final boolean VK_NV_external_memory_capabilities;

    VKCapabilitiesInstance(FunctionProvider provider, int apiVersion, Set<String> ext, Set<String> deviceExt) {
        this.apiVersion = apiVersion;
        long[] caps = new long[106];
        this.Vulkan10 = VKCapabilitiesInstance.check_VK10(provider, caps, ext);
        this.Vulkan11 = VKCapabilitiesInstance.check_VK11(provider, caps, ext);
        this.Vulkan12 = ext.contains("Vulkan12");
        this.Vulkan13 = VKCapabilitiesInstance.check_VK13(provider, caps, ext);
        this.VK_EXT_acquire_drm_display = VKCapabilitiesInstance.check_EXT_acquire_drm_display(provider, caps, ext);
        this.VK_EXT_acquire_xlib_display = VKCapabilitiesInstance.check_EXT_acquire_xlib_display(provider, caps, ext);
        VKCapabilitiesInstance.check_EXT_calibrated_timestamps(provider, caps, deviceExt);
        this.VK_EXT_debug_report = VKCapabilitiesInstance.check_EXT_debug_report(provider, caps, ext);
        this.VK_EXT_debug_utils = VKCapabilitiesInstance.check_EXT_debug_utils(provider, caps, ext);
        this.VK_EXT_direct_mode_display = VKCapabilitiesInstance.check_EXT_direct_mode_display(provider, caps, ext);
        this.VK_EXT_directfb_surface = VKCapabilitiesInstance.check_EXT_directfb_surface(provider, caps, ext);
        this.VK_EXT_display_surface_counter = VKCapabilitiesInstance.check_EXT_display_surface_counter(provider, caps, ext);
        VKCapabilitiesInstance.check_EXT_full_screen_exclusive(provider, caps, deviceExt);
        this.VK_EXT_headless_surface = VKCapabilitiesInstance.check_EXT_headless_surface(provider, caps, ext);
        this.VK_EXT_layer_settings = ext.contains("VK_EXT_layer_settings");
        this.VK_EXT_metal_surface = VKCapabilitiesInstance.check_EXT_metal_surface(provider, caps, ext);
        VKCapabilitiesInstance.check_EXT_sample_locations(provider, caps, deviceExt);
        this.VK_EXT_surface_maintenance1 = ext.contains("VK_EXT_surface_maintenance1");
        this.VK_EXT_swapchain_colorspace = ext.contains("VK_EXT_swapchain_colorspace");
        VKCapabilitiesInstance.check_EXT_tooling_info(provider, caps, deviceExt);
        this.VK_EXT_validation_features = ext.contains("VK_EXT_validation_features");
        this.VK_EXT_validation_flags = ext.contains("VK_EXT_validation_flags");
        this.VK_GOOGLE_surfaceless_query = ext.contains("VK_GOOGLE_surfaceless_query");
        this.VK_KHR_android_surface = VKCapabilitiesInstance.check_KHR_android_surface(provider, caps, ext);
        VKCapabilitiesInstance.check_KHR_calibrated_timestamps(provider, caps, deviceExt);
        VKCapabilitiesInstance.check_KHR_cooperative_matrix(provider, caps, deviceExt);
        VKCapabilitiesInstance.check_KHR_device_group(provider, caps, deviceExt);
        this.VK_KHR_device_group_creation = VKCapabilitiesInstance.check_KHR_device_group_creation(provider, caps, ext);
        this.VK_KHR_display = VKCapabilitiesInstance.check_KHR_display(provider, caps, ext);
        this.VK_KHR_external_fence_capabilities = VKCapabilitiesInstance.check_KHR_external_fence_capabilities(provider, caps, ext);
        this.VK_KHR_external_memory_capabilities = VKCapabilitiesInstance.check_KHR_external_memory_capabilities(provider, caps, ext);
        this.VK_KHR_external_semaphore_capabilities = VKCapabilitiesInstance.check_KHR_external_semaphore_capabilities(provider, caps, ext);
        VKCapabilitiesInstance.check_KHR_fragment_shading_rate(provider, caps, deviceExt);
        this.VK_KHR_get_display_properties2 = VKCapabilitiesInstance.check_KHR_get_display_properties2(provider, caps, ext);
        this.VK_KHR_get_physical_device_properties2 = VKCapabilitiesInstance.check_KHR_get_physical_device_properties2(provider, caps, ext);
        this.VK_KHR_get_surface_capabilities2 = VKCapabilitiesInstance.check_KHR_get_surface_capabilities2(provider, caps, ext);
        VKCapabilitiesInstance.check_KHR_performance_query(provider, caps, deviceExt);
        this.VK_KHR_portability_enumeration = ext.contains("VK_KHR_portability_enumeration");
        this.VK_KHR_surface = VKCapabilitiesInstance.check_KHR_surface(provider, caps, ext);
        this.VK_KHR_surface_protected_capabilities = ext.contains("VK_KHR_surface_protected_capabilities");
        VKCapabilitiesInstance.check_KHR_swapchain(provider, caps, deviceExt);
        VKCapabilitiesInstance.check_KHR_video_encode_queue(provider, caps, deviceExt);
        VKCapabilitiesInstance.check_KHR_video_queue(provider, caps, deviceExt);
        this.VK_KHR_wayland_surface = VKCapabilitiesInstance.check_KHR_wayland_surface(provider, caps, ext);
        this.VK_KHR_win32_surface = VKCapabilitiesInstance.check_KHR_win32_surface(provider, caps, ext);
        this.VK_KHR_xcb_surface = VKCapabilitiesInstance.check_KHR_xcb_surface(provider, caps, ext);
        this.VK_KHR_xlib_surface = VKCapabilitiesInstance.check_KHR_xlib_surface(provider, caps, ext);
        this.VK_LUNARG_direct_driver_loading = ext.contains("VK_LUNARG_direct_driver_loading");
        this.VK_MVK_macos_surface = VKCapabilitiesInstance.check_MVK_macos_surface(provider, caps, ext);
        VKCapabilitiesInstance.check_NV_acquire_winrt_display(provider, caps, deviceExt);
        VKCapabilitiesInstance.check_NV_cooperative_matrix(provider, caps, deviceExt);
        VKCapabilitiesInstance.check_NV_coverage_reduction_mode(provider, caps, deviceExt);
        this.VK_NV_external_memory_capabilities = VKCapabilitiesInstance.check_NV_external_memory_capabilities(provider, caps, ext);
        VKCapabilitiesInstance.check_NV_optical_flow(provider, caps, deviceExt);
        this.vkDestroyInstance = caps[0];
        this.vkEnumeratePhysicalDevices = caps[1];
        this.vkGetPhysicalDeviceFeatures = caps[2];
        this.vkGetPhysicalDeviceFormatProperties = caps[3];
        this.vkGetPhysicalDeviceImageFormatProperties = caps[4];
        this.vkGetPhysicalDeviceProperties = caps[5];
        this.vkGetPhysicalDeviceQueueFamilyProperties = caps[6];
        this.vkGetPhysicalDeviceMemoryProperties = caps[7];
        this.vkCreateDevice = caps[8];
        this.vkEnumerateDeviceExtensionProperties = caps[9];
        this.vkEnumerateDeviceLayerProperties = caps[10];
        this.vkGetPhysicalDeviceSparseImageFormatProperties = caps[11];
        this.vkEnumeratePhysicalDeviceGroups = caps[12];
        this.vkGetPhysicalDeviceFeatures2 = caps[13];
        this.vkGetPhysicalDeviceProperties2 = caps[14];
        this.vkGetPhysicalDeviceFormatProperties2 = caps[15];
        this.vkGetPhysicalDeviceImageFormatProperties2 = caps[16];
        this.vkGetPhysicalDeviceQueueFamilyProperties2 = caps[17];
        this.vkGetPhysicalDeviceMemoryProperties2 = caps[18];
        this.vkGetPhysicalDeviceSparseImageFormatProperties2 = caps[19];
        this.vkGetPhysicalDeviceExternalBufferProperties = caps[20];
        this.vkGetPhysicalDeviceExternalFenceProperties = caps[21];
        this.vkGetPhysicalDeviceExternalSemaphoreProperties = caps[22];
        this.vkGetPhysicalDeviceToolProperties = caps[23];
        this.vkAcquireDrmDisplayEXT = caps[24];
        this.vkGetDrmDisplayEXT = caps[25];
        this.vkAcquireXlibDisplayEXT = caps[26];
        this.vkGetRandROutputDisplayEXT = caps[27];
        this.vkGetPhysicalDeviceCalibrateableTimeDomainsEXT = caps[28];
        this.vkCreateDebugReportCallbackEXT = caps[29];
        this.vkDestroyDebugReportCallbackEXT = caps[30];
        this.vkDebugReportMessageEXT = caps[31];
        this.vkSetDebugUtilsObjectNameEXT = caps[32];
        this.vkSetDebugUtilsObjectTagEXT = caps[33];
        this.vkQueueBeginDebugUtilsLabelEXT = caps[34];
        this.vkQueueEndDebugUtilsLabelEXT = caps[35];
        this.vkQueueInsertDebugUtilsLabelEXT = caps[36];
        this.vkCmdBeginDebugUtilsLabelEXT = caps[37];
        this.vkCmdEndDebugUtilsLabelEXT = caps[38];
        this.vkCmdInsertDebugUtilsLabelEXT = caps[39];
        this.vkCreateDebugUtilsMessengerEXT = caps[40];
        this.vkDestroyDebugUtilsMessengerEXT = caps[41];
        this.vkSubmitDebugUtilsMessageEXT = caps[42];
        this.vkReleaseDisplayEXT = caps[43];
        this.vkCreateDirectFBSurfaceEXT = caps[44];
        this.vkGetPhysicalDeviceDirectFBPresentationSupportEXT = caps[45];
        this.vkGetPhysicalDeviceSurfaceCapabilities2EXT = caps[46];
        this.vkGetPhysicalDeviceSurfacePresentModes2EXT = caps[47];
        this.vkCreateHeadlessSurfaceEXT = caps[48];
        this.vkCreateMetalSurfaceEXT = caps[49];
        this.vkGetPhysicalDeviceMultisamplePropertiesEXT = caps[50];
        this.vkGetPhysicalDeviceToolPropertiesEXT = caps[51];
        this.vkCreateAndroidSurfaceKHR = caps[52];
        this.vkGetPhysicalDeviceCalibrateableTimeDomainsKHR = caps[53];
        this.vkGetPhysicalDeviceCooperativeMatrixPropertiesKHR = caps[54];
        this.vkGetPhysicalDevicePresentRectanglesKHR = caps[55];
        this.vkEnumeratePhysicalDeviceGroupsKHR = caps[56];
        this.vkGetPhysicalDeviceDisplayPropertiesKHR = caps[57];
        this.vkGetPhysicalDeviceDisplayPlanePropertiesKHR = caps[58];
        this.vkGetDisplayPlaneSupportedDisplaysKHR = caps[59];
        this.vkGetDisplayModePropertiesKHR = caps[60];
        this.vkCreateDisplayModeKHR = caps[61];
        this.vkGetDisplayPlaneCapabilitiesKHR = caps[62];
        this.vkCreateDisplayPlaneSurfaceKHR = caps[63];
        this.vkGetPhysicalDeviceExternalFencePropertiesKHR = caps[64];
        this.vkGetPhysicalDeviceExternalBufferPropertiesKHR = caps[65];
        this.vkGetPhysicalDeviceExternalSemaphorePropertiesKHR = caps[66];
        this.vkGetPhysicalDeviceFragmentShadingRatesKHR = caps[67];
        this.vkGetPhysicalDeviceDisplayProperties2KHR = caps[68];
        this.vkGetPhysicalDeviceDisplayPlaneProperties2KHR = caps[69];
        this.vkGetDisplayModeProperties2KHR = caps[70];
        this.vkGetDisplayPlaneCapabilities2KHR = caps[71];
        this.vkGetPhysicalDeviceFeatures2KHR = caps[72];
        this.vkGetPhysicalDeviceProperties2KHR = caps[73];
        this.vkGetPhysicalDeviceFormatProperties2KHR = caps[74];
        this.vkGetPhysicalDeviceImageFormatProperties2KHR = caps[75];
        this.vkGetPhysicalDeviceQueueFamilyProperties2KHR = caps[76];
        this.vkGetPhysicalDeviceMemoryProperties2KHR = caps[77];
        this.vkGetPhysicalDeviceSparseImageFormatProperties2KHR = caps[78];
        this.vkGetPhysicalDeviceSurfaceCapabilities2KHR = caps[79];
        this.vkGetPhysicalDeviceSurfaceFormats2KHR = caps[80];
        this.vkEnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR = caps[81];
        this.vkGetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR = caps[82];
        this.vkDestroySurfaceKHR = caps[83];
        this.vkGetPhysicalDeviceSurfaceSupportKHR = caps[84];
        this.vkGetPhysicalDeviceSurfaceCapabilitiesKHR = caps[85];
        this.vkGetPhysicalDeviceSurfaceFormatsKHR = caps[86];
        this.vkGetPhysicalDeviceSurfacePresentModesKHR = caps[87];
        this.vkGetPhysicalDeviceVideoEncodeQualityLevelPropertiesKHR = caps[88];
        this.vkGetPhysicalDeviceVideoCapabilitiesKHR = caps[89];
        this.vkGetPhysicalDeviceVideoFormatPropertiesKHR = caps[90];
        this.vkCreateWaylandSurfaceKHR = caps[91];
        this.vkGetPhysicalDeviceWaylandPresentationSupportKHR = caps[92];
        this.vkCreateWin32SurfaceKHR = caps[93];
        this.vkGetPhysicalDeviceWin32PresentationSupportKHR = caps[94];
        this.vkCreateXcbSurfaceKHR = caps[95];
        this.vkGetPhysicalDeviceXcbPresentationSupportKHR = caps[96];
        this.vkCreateXlibSurfaceKHR = caps[97];
        this.vkGetPhysicalDeviceXlibPresentationSupportKHR = caps[98];
        this.vkCreateMacOSSurfaceMVK = caps[99];
        this.vkAcquireWinrtDisplayNV = caps[100];
        this.vkGetWinrtDisplayNV = caps[101];
        this.vkGetPhysicalDeviceCooperativeMatrixPropertiesNV = caps[102];
        this.vkGetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV = caps[103];
        this.vkGetPhysicalDeviceExternalImageFormatPropertiesNV = caps[104];
        this.vkGetPhysicalDeviceOpticalFlowImageFormatsNV = caps[105];
    }

    private static boolean check_VK10(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("Vulkan10")) {
            return false;
        }
        return Checks.checkFunctions((FunctionProvider)provider, (long[])caps, (int[])new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11}, (String[])new String[]{"vkDestroyInstance", "vkEnumeratePhysicalDevices", "vkGetPhysicalDeviceFeatures", "vkGetPhysicalDeviceFormatProperties", "vkGetPhysicalDeviceImageFormatProperties", "vkGetPhysicalDeviceProperties", "vkGetPhysicalDeviceQueueFamilyProperties", "vkGetPhysicalDeviceMemoryProperties", "vkCreateDevice", "vkEnumerateDeviceExtensionProperties", "vkEnumerateDeviceLayerProperties", "vkGetPhysicalDeviceSparseImageFormatProperties"}) || Checks.reportMissing((String)"VK", (String)"Vulkan10");
    }

    private static boolean check_VK11(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("Vulkan11")) {
            return false;
        }
        return Checks.checkFunctions((FunctionProvider)provider, (long[])caps, (int[])new int[]{12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22}, (String[])new String[]{"vkEnumeratePhysicalDeviceGroups", "vkGetPhysicalDeviceFeatures2", "vkGetPhysicalDeviceProperties2", "vkGetPhysicalDeviceFormatProperties2", "vkGetPhysicalDeviceImageFormatProperties2", "vkGetPhysicalDeviceQueueFamilyProperties2", "vkGetPhysicalDeviceMemoryProperties2", "vkGetPhysicalDeviceSparseImageFormatProperties2", "vkGetPhysicalDeviceExternalBufferProperties", "vkGetPhysicalDeviceExternalFenceProperties", "vkGetPhysicalDeviceExternalSemaphoreProperties"}) || Checks.reportMissing((String)"VK", (String)"Vulkan11");
    }

    private static boolean check_VK13(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("Vulkan13")) {
            return false;
        }
        return Checks.checkFunctions((FunctionProvider)provider, (long[])caps, (int[])new int[]{23}, (String[])new String[]{"vkGetPhysicalDeviceToolProperties"}) || Checks.reportMissing((String)"VK", (String)"Vulkan13");
    }

    private static boolean check_EXT_acquire_drm_display(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("VK_EXT_acquire_drm_display")) {
            return false;
        }
        return Checks.checkFunctions((FunctionProvider)provider, (long[])caps, (int[])new int[]{24, 25}, (String[])new String[]{"vkAcquireDrmDisplayEXT", "vkGetDrmDisplayEXT"}) || Checks.reportMissing((String)"VK", (String)"VK_EXT_acquire_drm_display");
    }

    private static boolean check_EXT_acquire_xlib_display(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("VK_EXT_acquire_xlib_display")) {
            return false;
        }
        return Checks.checkFunctions((FunctionProvider)provider, (long[])caps, (int[])new int[]{26, 27}, (String[])new String[]{"vkAcquireXlibDisplayEXT", "vkGetRandROutputDisplayEXT"}) || Checks.reportMissing((String)"VK", (String)"VK_EXT_acquire_xlib_display");
    }

    private static boolean check_EXT_calibrated_timestamps(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("VK_EXT_calibrated_timestamps")) {
            return false;
        }
        return Checks.checkFunctions((FunctionProvider)provider, (long[])caps, (int[])new int[]{28}, (String[])new String[]{"vkGetPhysicalDeviceCalibrateableTimeDomainsEXT"}) || Checks.reportMissing((String)"VK", (String)"VK_EXT_calibrated_timestamps");
    }

    private static boolean check_EXT_debug_report(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("VK_EXT_debug_report")) {
            return false;
        }
        return Checks.checkFunctions((FunctionProvider)provider, (long[])caps, (int[])new int[]{29, 30, 31}, (String[])new String[]{"vkCreateDebugReportCallbackEXT", "vkDestroyDebugReportCallbackEXT", "vkDebugReportMessageEXT"}) || Checks.reportMissing((String)"VK", (String)"VK_EXT_debug_report");
    }

    private static boolean check_EXT_debug_utils(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("VK_EXT_debug_utils")) {
            return false;
        }
        return Checks.checkFunctions((FunctionProvider)provider, (long[])caps, (int[])new int[]{32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42}, (String[])new String[]{"vkSetDebugUtilsObjectNameEXT", "vkSetDebugUtilsObjectTagEXT", "vkQueueBeginDebugUtilsLabelEXT", "vkQueueEndDebugUtilsLabelEXT", "vkQueueInsertDebugUtilsLabelEXT", "vkCmdBeginDebugUtilsLabelEXT", "vkCmdEndDebugUtilsLabelEXT", "vkCmdInsertDebugUtilsLabelEXT", "vkCreateDebugUtilsMessengerEXT", "vkDestroyDebugUtilsMessengerEXT", "vkSubmitDebugUtilsMessageEXT"}) || Checks.reportMissing((String)"VK", (String)"VK_EXT_debug_utils");
    }

    private static boolean check_EXT_direct_mode_display(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("VK_EXT_direct_mode_display")) {
            return false;
        }
        return Checks.checkFunctions((FunctionProvider)provider, (long[])caps, (int[])new int[]{43}, (String[])new String[]{"vkReleaseDisplayEXT"}) || Checks.reportMissing((String)"VK", (String)"VK_EXT_direct_mode_display");
    }

    private static boolean check_EXT_directfb_surface(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("VK_EXT_directfb_surface")) {
            return false;
        }
        return Checks.checkFunctions((FunctionProvider)provider, (long[])caps, (int[])new int[]{44, 45}, (String[])new String[]{"vkCreateDirectFBSurfaceEXT", "vkGetPhysicalDeviceDirectFBPresentationSupportEXT"}) || Checks.reportMissing((String)"VK", (String)"VK_EXT_directfb_surface");
    }

    private static boolean check_EXT_display_surface_counter(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("VK_EXT_display_surface_counter")) {
            return false;
        }
        return Checks.checkFunctions((FunctionProvider)provider, (long[])caps, (int[])new int[]{46}, (String[])new String[]{"vkGetPhysicalDeviceSurfaceCapabilities2EXT"}) || Checks.reportMissing((String)"VK", (String)"VK_EXT_display_surface_counter");
    }

    private static boolean check_EXT_full_screen_exclusive(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("VK_EXT_full_screen_exclusive")) {
            return false;
        }
        return Checks.checkFunctions((FunctionProvider)provider, (long[])caps, (int[])new int[]{47}, (String[])new String[]{"vkGetPhysicalDeviceSurfacePresentModes2EXT"}) || Checks.reportMissing((String)"VK", (String)"VK_EXT_full_screen_exclusive");
    }

    private static boolean check_EXT_headless_surface(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("VK_EXT_headless_surface")) {
            return false;
        }
        return Checks.checkFunctions((FunctionProvider)provider, (long[])caps, (int[])new int[]{48}, (String[])new String[]{"vkCreateHeadlessSurfaceEXT"}) || Checks.reportMissing((String)"VK", (String)"VK_EXT_headless_surface");
    }

    private static boolean check_EXT_metal_surface(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("VK_EXT_metal_surface")) {
            return false;
        }
        return Checks.checkFunctions((FunctionProvider)provider, (long[])caps, (int[])new int[]{49}, (String[])new String[]{"vkCreateMetalSurfaceEXT"}) || Checks.reportMissing((String)"VK", (String)"VK_EXT_metal_surface");
    }

    private static boolean check_EXT_sample_locations(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("VK_EXT_sample_locations")) {
            return false;
        }
        return Checks.checkFunctions((FunctionProvider)provider, (long[])caps, (int[])new int[]{50}, (String[])new String[]{"vkGetPhysicalDeviceMultisamplePropertiesEXT"}) || Checks.reportMissing((String)"VK", (String)"VK_EXT_sample_locations");
    }

    private static boolean check_EXT_tooling_info(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("VK_EXT_tooling_info")) {
            return false;
        }
        return Checks.checkFunctions((FunctionProvider)provider, (long[])caps, (int[])new int[]{51}, (String[])new String[]{"vkGetPhysicalDeviceToolPropertiesEXT"}) || Checks.reportMissing((String)"VK", (String)"VK_EXT_tooling_info");
    }

    private static boolean check_KHR_android_surface(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("VK_KHR_android_surface")) {
            return false;
        }
        return Checks.checkFunctions((FunctionProvider)provider, (long[])caps, (int[])new int[]{52}, (String[])new String[]{"vkCreateAndroidSurfaceKHR"}) || Checks.reportMissing((String)"VK", (String)"VK_KHR_android_surface");
    }

    private static boolean check_KHR_calibrated_timestamps(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("VK_KHR_calibrated_timestamps")) {
            return false;
        }
        return Checks.checkFunctions((FunctionProvider)provider, (long[])caps, (int[])new int[]{53}, (String[])new String[]{"vkGetPhysicalDeviceCalibrateableTimeDomainsKHR"}) || Checks.reportMissing((String)"VK", (String)"VK_KHR_calibrated_timestamps");
    }

    private static boolean check_KHR_cooperative_matrix(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("VK_KHR_cooperative_matrix")) {
            return false;
        }
        return Checks.checkFunctions((FunctionProvider)provider, (long[])caps, (int[])new int[]{54}, (String[])new String[]{"vkGetPhysicalDeviceCooperativeMatrixPropertiesKHR"}) || Checks.reportMissing((String)"VK", (String)"VK_KHR_cooperative_matrix");
    }

    private static boolean check_KHR_device_group(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("VK_KHR_device_group")) {
            return false;
        }
        int flag0 = ext.contains("VK_KHR_surface") ? 0 : Integer.MIN_VALUE;
        return Checks.checkFunctions((FunctionProvider)provider, (long[])caps, (int[])new int[]{flag0 + 55}, (String[])new String[]{"vkGetPhysicalDevicePresentRectanglesKHR"}) || Checks.reportMissing((String)"VK", (String)"VK_KHR_device_group");
    }

    private static boolean check_KHR_device_group_creation(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("VK_KHR_device_group_creation")) {
            return false;
        }
        return Checks.checkFunctions((FunctionProvider)provider, (long[])caps, (int[])new int[]{56}, (String[])new String[]{"vkEnumeratePhysicalDeviceGroupsKHR"}) || Checks.reportMissing((String)"VK", (String)"VK_KHR_device_group_creation");
    }

    private static boolean check_KHR_display(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("VK_KHR_display")) {
            return false;
        }
        return Checks.checkFunctions((FunctionProvider)provider, (long[])caps, (int[])new int[]{57, 58, 59, 60, 61, 62, 63}, (String[])new String[]{"vkGetPhysicalDeviceDisplayPropertiesKHR", "vkGetPhysicalDeviceDisplayPlanePropertiesKHR", "vkGetDisplayPlaneSupportedDisplaysKHR", "vkGetDisplayModePropertiesKHR", "vkCreateDisplayModeKHR", "vkGetDisplayPlaneCapabilitiesKHR", "vkCreateDisplayPlaneSurfaceKHR"}) || Checks.reportMissing((String)"VK", (String)"VK_KHR_display");
    }

    private static boolean check_KHR_external_fence_capabilities(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("VK_KHR_external_fence_capabilities")) {
            return false;
        }
        return Checks.checkFunctions((FunctionProvider)provider, (long[])caps, (int[])new int[]{64}, (String[])new String[]{"vkGetPhysicalDeviceExternalFencePropertiesKHR"}) || Checks.reportMissing((String)"VK", (String)"VK_KHR_external_fence_capabilities");
    }

    private static boolean check_KHR_external_memory_capabilities(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("VK_KHR_external_memory_capabilities")) {
            return false;
        }
        return Checks.checkFunctions((FunctionProvider)provider, (long[])caps, (int[])new int[]{65}, (String[])new String[]{"vkGetPhysicalDeviceExternalBufferPropertiesKHR"}) || Checks.reportMissing((String)"VK", (String)"VK_KHR_external_memory_capabilities");
    }

    private static boolean check_KHR_external_semaphore_capabilities(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("VK_KHR_external_semaphore_capabilities")) {
            return false;
        }
        return Checks.checkFunctions((FunctionProvider)provider, (long[])caps, (int[])new int[]{66}, (String[])new String[]{"vkGetPhysicalDeviceExternalSemaphorePropertiesKHR"}) || Checks.reportMissing((String)"VK", (String)"VK_KHR_external_semaphore_capabilities");
    }

    private static boolean check_KHR_fragment_shading_rate(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("VK_KHR_fragment_shading_rate")) {
            return false;
        }
        return Checks.checkFunctions((FunctionProvider)provider, (long[])caps, (int[])new int[]{67}, (String[])new String[]{"vkGetPhysicalDeviceFragmentShadingRatesKHR"}) || Checks.reportMissing((String)"VK", (String)"VK_KHR_fragment_shading_rate");
    }

    private static boolean check_KHR_get_display_properties2(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("VK_KHR_get_display_properties2")) {
            return false;
        }
        return Checks.checkFunctions((FunctionProvider)provider, (long[])caps, (int[])new int[]{68, 69, 70, 71}, (String[])new String[]{"vkGetPhysicalDeviceDisplayProperties2KHR", "vkGetPhysicalDeviceDisplayPlaneProperties2KHR", "vkGetDisplayModeProperties2KHR", "vkGetDisplayPlaneCapabilities2KHR"}) || Checks.reportMissing((String)"VK", (String)"VK_KHR_get_display_properties2");
    }

    private static boolean check_KHR_get_physical_device_properties2(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("VK_KHR_get_physical_device_properties2")) {
            return false;
        }
        return Checks.checkFunctions((FunctionProvider)provider, (long[])caps, (int[])new int[]{72, 73, 74, 75, 76, 77, 78}, (String[])new String[]{"vkGetPhysicalDeviceFeatures2KHR", "vkGetPhysicalDeviceProperties2KHR", "vkGetPhysicalDeviceFormatProperties2KHR", "vkGetPhysicalDeviceImageFormatProperties2KHR", "vkGetPhysicalDeviceQueueFamilyProperties2KHR", "vkGetPhysicalDeviceMemoryProperties2KHR", "vkGetPhysicalDeviceSparseImageFormatProperties2KHR"}) || Checks.reportMissing((String)"VK", (String)"VK_KHR_get_physical_device_properties2");
    }

    private static boolean check_KHR_get_surface_capabilities2(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("VK_KHR_get_surface_capabilities2")) {
            return false;
        }
        return Checks.checkFunctions((FunctionProvider)provider, (long[])caps, (int[])new int[]{79, 80}, (String[])new String[]{"vkGetPhysicalDeviceSurfaceCapabilities2KHR", "vkGetPhysicalDeviceSurfaceFormats2KHR"}) || Checks.reportMissing((String)"VK", (String)"VK_KHR_get_surface_capabilities2");
    }

    private static boolean check_KHR_performance_query(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("VK_KHR_performance_query")) {
            return false;
        }
        return Checks.checkFunctions((FunctionProvider)provider, (long[])caps, (int[])new int[]{81, 82}, (String[])new String[]{"vkEnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR", "vkGetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR"}) || Checks.reportMissing((String)"VK", (String)"VK_KHR_performance_query");
    }

    private static boolean check_KHR_surface(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("VK_KHR_surface")) {
            return false;
        }
        return Checks.checkFunctions((FunctionProvider)provider, (long[])caps, (int[])new int[]{83, 84, 85, 86, 87}, (String[])new String[]{"vkDestroySurfaceKHR", "vkGetPhysicalDeviceSurfaceSupportKHR", "vkGetPhysicalDeviceSurfaceCapabilitiesKHR", "vkGetPhysicalDeviceSurfaceFormatsKHR", "vkGetPhysicalDeviceSurfacePresentModesKHR"}) || Checks.reportMissing((String)"VK", (String)"VK_KHR_surface");
    }

    private static boolean check_KHR_swapchain(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("VK_KHR_swapchain")) {
            return false;
        }
        int flag0 = ext.contains("Vulkan11") ? 0 : Integer.MIN_VALUE;
        return Checks.checkFunctions((FunctionProvider)provider, (long[])caps, (int[])new int[]{flag0 + 55}, (String[])new String[]{"vkGetPhysicalDevicePresentRectanglesKHR"}) || Checks.reportMissing((String)"VK", (String)"VK_KHR_swapchain");
    }

    private static boolean check_KHR_video_encode_queue(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("VK_KHR_video_encode_queue")) {
            return false;
        }
        return Checks.checkFunctions((FunctionProvider)provider, (long[])caps, (int[])new int[]{88}, (String[])new String[]{"vkGetPhysicalDeviceVideoEncodeQualityLevelPropertiesKHR"}) || Checks.reportMissing((String)"VK", (String)"VK_KHR_video_encode_queue");
    }

    private static boolean check_KHR_video_queue(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("VK_KHR_video_queue")) {
            return false;
        }
        return Checks.checkFunctions((FunctionProvider)provider, (long[])caps, (int[])new int[]{89, 90}, (String[])new String[]{"vkGetPhysicalDeviceVideoCapabilitiesKHR", "vkGetPhysicalDeviceVideoFormatPropertiesKHR"}) || Checks.reportMissing((String)"VK", (String)"VK_KHR_video_queue");
    }

    private static boolean check_KHR_wayland_surface(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("VK_KHR_wayland_surface")) {
            return false;
        }
        return Checks.checkFunctions((FunctionProvider)provider, (long[])caps, (int[])new int[]{91, 92}, (String[])new String[]{"vkCreateWaylandSurfaceKHR", "vkGetPhysicalDeviceWaylandPresentationSupportKHR"}) || Checks.reportMissing((String)"VK", (String)"VK_KHR_wayland_surface");
    }

    private static boolean check_KHR_win32_surface(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("VK_KHR_win32_surface")) {
            return false;
        }
        return Checks.checkFunctions((FunctionProvider)provider, (long[])caps, (int[])new int[]{93, 94}, (String[])new String[]{"vkCreateWin32SurfaceKHR", "vkGetPhysicalDeviceWin32PresentationSupportKHR"}) || Checks.reportMissing((String)"VK", (String)"VK_KHR_win32_surface");
    }

    private static boolean check_KHR_xcb_surface(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("VK_KHR_xcb_surface")) {
            return false;
        }
        return Checks.checkFunctions((FunctionProvider)provider, (long[])caps, (int[])new int[]{95, 96}, (String[])new String[]{"vkCreateXcbSurfaceKHR", "vkGetPhysicalDeviceXcbPresentationSupportKHR"}) || Checks.reportMissing((String)"VK", (String)"VK_KHR_xcb_surface");
    }

    private static boolean check_KHR_xlib_surface(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("VK_KHR_xlib_surface")) {
            return false;
        }
        return Checks.checkFunctions((FunctionProvider)provider, (long[])caps, (int[])new int[]{97, 98}, (String[])new String[]{"vkCreateXlibSurfaceKHR", "vkGetPhysicalDeviceXlibPresentationSupportKHR"}) || Checks.reportMissing((String)"VK", (String)"VK_KHR_xlib_surface");
    }

    private static boolean check_MVK_macos_surface(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("VK_MVK_macos_surface")) {
            return false;
        }
        return Checks.checkFunctions((FunctionProvider)provider, (long[])caps, (int[])new int[]{99}, (String[])new String[]{"vkCreateMacOSSurfaceMVK"}) || Checks.reportMissing((String)"VK", (String)"VK_MVK_macos_surface");
    }

    private static boolean check_NV_acquire_winrt_display(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("VK_NV_acquire_winrt_display")) {
            return false;
        }
        return Checks.checkFunctions((FunctionProvider)provider, (long[])caps, (int[])new int[]{100, 101}, (String[])new String[]{"vkAcquireWinrtDisplayNV", "vkGetWinrtDisplayNV"}) || Checks.reportMissing((String)"VK", (String)"VK_NV_acquire_winrt_display");
    }

    private static boolean check_NV_cooperative_matrix(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("VK_NV_cooperative_matrix")) {
            return false;
        }
        return Checks.checkFunctions((FunctionProvider)provider, (long[])caps, (int[])new int[]{102}, (String[])new String[]{"vkGetPhysicalDeviceCooperativeMatrixPropertiesNV"}) || Checks.reportMissing((String)"VK", (String)"VK_NV_cooperative_matrix");
    }

    private static boolean check_NV_coverage_reduction_mode(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("VK_NV_coverage_reduction_mode")) {
            return false;
        }
        return Checks.checkFunctions((FunctionProvider)provider, (long[])caps, (int[])new int[]{103}, (String[])new String[]{"vkGetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV"}) || Checks.reportMissing((String)"VK", (String)"VK_NV_coverage_reduction_mode");
    }

    private static boolean check_NV_external_memory_capabilities(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("VK_NV_external_memory_capabilities")) {
            return false;
        }
        return Checks.checkFunctions((FunctionProvider)provider, (long[])caps, (int[])new int[]{104}, (String[])new String[]{"vkGetPhysicalDeviceExternalImageFormatPropertiesNV"}) || Checks.reportMissing((String)"VK", (String)"VK_NV_external_memory_capabilities");
    }

    private static boolean check_NV_optical_flow(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("VK_NV_optical_flow")) {
            return false;
        }
        return Checks.checkFunctions((FunctionProvider)provider, (long[])caps, (int[])new int[]{105}, (String[])new String[]{"vkGetPhysicalDeviceOpticalFlowImageFormatsNV"}) || Checks.reportMissing((String)"VK", (String)"VK_NV_optical_flow");
    }
}

