/*
 * Copyright LWJGL. All rights reserved.
 * License terms: https://www.lwjgl.org/license
 * MACHINE GENERATED FILE, DO NOT EDIT
 */
package org.lwjgl.vulkan;

import javax.annotation.*;

import java.nio.*;

import org.lwjgl.*;
import org.lwjgl.system.*;

import static org.lwjgl.system.MemoryUtil.*;
import static org.lwjgl.system.MemoryStack.*;

/**
 * Structure describing external format resolve supported by an implementation.
 * 
 * <h5>Description</h5>
 * 
 * <p>If the {@link VkPhysicalDeviceExternalFormatResolvePropertiesANDROID} structure is included in the {@code pNext} chain of the {@link VkPhysicalDeviceProperties2} structure passed to {@link VK11#vkGetPhysicalDeviceProperties2 GetPhysicalDeviceProperties2}, it is filled in with each corresponding implementation-dependent property.</p>
 * 
 * <h5>Valid Usage (Implicit)</h5>
 * 
 * <ul>
 * <li>{@code sType} <b>must</b> be {@link ANDROIDExternalFormatResolve#VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_FORMAT_RESOLVE_PROPERTIES_ANDROID STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_FORMAT_RESOLVE_PROPERTIES_ANDROID}</li>
 * </ul>
 * 
 * <h3>Layout</h3>
 * 
 * <pre><code>
 * struct VkPhysicalDeviceExternalFormatResolvePropertiesANDROID {
 *     VkStructureType {@link #sType};
 *     void * {@link #pNext};
 *     VkBool32 {@link #nullColorAttachmentWithExternalFormatResolve};
 *     VkChromaLocation {@link #externalFormatResolveChromaOffsetX};
 *     VkChromaLocation {@link #externalFormatResolveChromaOffsetY};
 * }</code></pre>
 */
public class VkPhysicalDeviceExternalFormatResolvePropertiesANDROID extends Struct<VkPhysicalDeviceExternalFormatResolvePropertiesANDROID> implements NativeResource {

    /** The struct size in bytes. */
    public static final int SIZEOF;

    /** The struct alignment in bytes. */
    public static final int ALIGNOF;

    /** The struct member offsets. */
    public static final int
        STYPE,
        PNEXT,
        NULLCOLORATTACHMENTWITHEXTERNALFORMATRESOLVE,
        EXTERNALFORMATRESOLVECHROMAOFFSETX,
        EXTERNALFORMATRESOLVECHROMAOFFSETY;

    static {
        Layout layout = __struct(
            __member(4),
            __member(POINTER_SIZE),
            __member(4),
            __member(4),
            __member(4)
        );

        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();

        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        NULLCOLORATTACHMENTWITHEXTERNALFORMATRESOLVE = layout.offsetof(2);
        EXTERNALFORMATRESOLVECHROMAOFFSETX = layout.offsetof(3);
        EXTERNALFORMATRESOLVECHROMAOFFSETY = layout.offsetof(4);
    }

    protected VkPhysicalDeviceExternalFormatResolvePropertiesANDROID(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkPhysicalDeviceExternalFormatResolvePropertiesANDROID create(long address, @Nullable ByteBuffer container) {
        return new VkPhysicalDeviceExternalFormatResolvePropertiesANDROID(address, container);
    }

    /**
     * Creates a {@code VkPhysicalDeviceExternalFormatResolvePropertiesANDROID} instance at the current position of the specified {@link ByteBuffer} container. Changes to the buffer's content will be
     * visible to the struct instance and vice versa.
     *
     * <p>The created instance holds a strong reference to the container object.</p>
     */
    public VkPhysicalDeviceExternalFormatResolvePropertiesANDROID(ByteBuffer container) {
        super(memAddress(container), __checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() { return SIZEOF; }

    /** a {@code VkStructureType} value identifying this structure. */
    @NativeType("VkStructureType")
    public int sType() { return nsType(address()); }
    /** {@code NULL} or a pointer to a structure extending this structure. */
    @NativeType("void *")
    public long pNext() { return npNext(address()); }
    /** indicates that there <b>must</b> be no color attachment image when performing external format resolves if it is {@link VK10#VK_TRUE TRUE}. */
    @NativeType("VkBool32")
    public boolean nullColorAttachmentWithExternalFormatResolve() { return nnullColorAttachmentWithExternalFormatResolve(address()) != 0; }
    /** indicates the {@code VkChromaLocation} that an implementation uses in the X axis for accesses to an external format image as a resolve attachment. This <b>must</b> be consistent between external format resolves and load operations from external format resolve attachments to color attachments when {@code nullColorAttachmentWithExternalFormatResolve} is {@link VK10#VK_TRUE TRUE}. */
    @NativeType("VkChromaLocation")
    public int externalFormatResolveChromaOffsetX() { return nexternalFormatResolveChromaOffsetX(address()); }
    /** indicates the {@code VkChromaLocation} that an implementation uses in the Y axis for accesses to an external format image as a resolve attachment. This <b>must</b> be consistent between external format resolves and load operations from external format resolve attachments to color attachments when {@code nullColorAttachmentWithExternalFormatResolve} is {@link VK10#VK_TRUE TRUE}. */
    @NativeType("VkChromaLocation")
    public int externalFormatResolveChromaOffsetY() { return nexternalFormatResolveChromaOffsetY(address()); }

    /** Sets the specified value to the {@link #sType} field. */
    public VkPhysicalDeviceExternalFormatResolvePropertiesANDROID sType(@NativeType("VkStructureType") int value) { nsType(address(), value); return this; }
    /** Sets the {@link ANDROIDExternalFormatResolve#VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_FORMAT_RESOLVE_PROPERTIES_ANDROID STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_FORMAT_RESOLVE_PROPERTIES_ANDROID} value to the {@link #sType} field. */
    public VkPhysicalDeviceExternalFormatResolvePropertiesANDROID sType$Default() { return sType(ANDROIDExternalFormatResolve.VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_FORMAT_RESOLVE_PROPERTIES_ANDROID); }
    /** Sets the specified value to the {@link #pNext} field. */
    public VkPhysicalDeviceExternalFormatResolvePropertiesANDROID pNext(@NativeType("void *") long value) { npNext(address(), value); return this; }

    /** Initializes this struct with the specified values. */
    public VkPhysicalDeviceExternalFormatResolvePropertiesANDROID set(
        int sType,
        long pNext
    ) {
        sType(sType);
        pNext(pNext);

        return this;
    }

    /**
     * Copies the specified struct data to this struct.
     *
     * @param src the source struct
     *
     * @return this struct
     */
    public VkPhysicalDeviceExternalFormatResolvePropertiesANDROID set(VkPhysicalDeviceExternalFormatResolvePropertiesANDROID src) {
        memCopy(src.address(), address(), SIZEOF);
        return this;
    }

    // -----------------------------------

    /** Returns a new {@code VkPhysicalDeviceExternalFormatResolvePropertiesANDROID} instance allocated with {@link MemoryUtil#memAlloc memAlloc}. The instance must be explicitly freed. */
    public static VkPhysicalDeviceExternalFormatResolvePropertiesANDROID malloc() {
        return new VkPhysicalDeviceExternalFormatResolvePropertiesANDROID(nmemAllocChecked(SIZEOF), null);
    }

    /** Returns a new {@code VkPhysicalDeviceExternalFormatResolvePropertiesANDROID} instance allocated with {@link MemoryUtil#memCalloc memCalloc}. The instance must be explicitly freed. */
    public static VkPhysicalDeviceExternalFormatResolvePropertiesANDROID calloc() {
        return new VkPhysicalDeviceExternalFormatResolvePropertiesANDROID(nmemCallocChecked(1, SIZEOF), null);
    }

    /** Returns a new {@code VkPhysicalDeviceExternalFormatResolvePropertiesANDROID} instance allocated with {@link BufferUtils}. */
    public static VkPhysicalDeviceExternalFormatResolvePropertiesANDROID create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkPhysicalDeviceExternalFormatResolvePropertiesANDROID(memAddress(container), container);
    }

    /** Returns a new {@code VkPhysicalDeviceExternalFormatResolvePropertiesANDROID} instance for the specified memory address. */
    public static VkPhysicalDeviceExternalFormatResolvePropertiesANDROID create(long address) {
        return new VkPhysicalDeviceExternalFormatResolvePropertiesANDROID(address, null);
    }

    /** Like {@link #create(long) create}, but returns {@code null} if {@code address} is {@code NULL}. */
    @Nullable
    public static VkPhysicalDeviceExternalFormatResolvePropertiesANDROID createSafe(long address) {
        return address == NULL ? null : new VkPhysicalDeviceExternalFormatResolvePropertiesANDROID(address, null);
    }

    /**
     * Returns a new {@link VkPhysicalDeviceExternalFormatResolvePropertiesANDROID.Buffer} instance allocated with {@link MemoryUtil#memAlloc memAlloc}. The instance must be explicitly freed.
     *
     * @param capacity the buffer capacity
     */
    public static VkPhysicalDeviceExternalFormatResolvePropertiesANDROID.Buffer malloc(int capacity) {
        return new Buffer(nmemAllocChecked(__checkMalloc(capacity, SIZEOF)), capacity);
    }

    /**
     * Returns a new {@link VkPhysicalDeviceExternalFormatResolvePropertiesANDROID.Buffer} instance allocated with {@link MemoryUtil#memCalloc memCalloc}. The instance must be explicitly freed.
     *
     * @param capacity the buffer capacity
     */
    public static VkPhysicalDeviceExternalFormatResolvePropertiesANDROID.Buffer calloc(int capacity) {
        return new Buffer(nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    /**
     * Returns a new {@link VkPhysicalDeviceExternalFormatResolvePropertiesANDROID.Buffer} instance allocated with {@link BufferUtils}.
     *
     * @param capacity the buffer capacity
     */
    public static VkPhysicalDeviceExternalFormatResolvePropertiesANDROID.Buffer create(int capacity) {
        ByteBuffer container = __create(capacity, SIZEOF);
        return new Buffer(memAddress(container), container, -1, 0, capacity, capacity);
    }

    /**
     * Create a {@link VkPhysicalDeviceExternalFormatResolvePropertiesANDROID.Buffer} instance at the specified memory.
     *
     * @param address  the memory address
     * @param capacity the buffer capacity
     */
    public static VkPhysicalDeviceExternalFormatResolvePropertiesANDROID.Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    /** Like {@link #create(long, int) create}, but returns {@code null} if {@code address} is {@code NULL}. */
    @Nullable
    public static VkPhysicalDeviceExternalFormatResolvePropertiesANDROID.Buffer createSafe(long address, int capacity) {
        return address == NULL ? null : new Buffer(address, capacity);
    }

    /**
     * Returns a new {@code VkPhysicalDeviceExternalFormatResolvePropertiesANDROID} instance allocated on the specified {@link MemoryStack}.
     *
     * @param stack the stack from which to allocate
     */
    public static VkPhysicalDeviceExternalFormatResolvePropertiesANDROID malloc(MemoryStack stack) {
        return new VkPhysicalDeviceExternalFormatResolvePropertiesANDROID(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    /**
     * Returns a new {@code VkPhysicalDeviceExternalFormatResolvePropertiesANDROID} instance allocated on the specified {@link MemoryStack} and initializes all its bits to zero.
     *
     * @param stack the stack from which to allocate
     */
    public static VkPhysicalDeviceExternalFormatResolvePropertiesANDROID calloc(MemoryStack stack) {
        return new VkPhysicalDeviceExternalFormatResolvePropertiesANDROID(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    /**
     * Returns a new {@link VkPhysicalDeviceExternalFormatResolvePropertiesANDROID.Buffer} instance allocated on the specified {@link MemoryStack}.
     *
     * @param stack    the stack from which to allocate
     * @param capacity the buffer capacity
     */
    public static VkPhysicalDeviceExternalFormatResolvePropertiesANDROID.Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    /**
     * Returns a new {@link VkPhysicalDeviceExternalFormatResolvePropertiesANDROID.Buffer} instance allocated on the specified {@link MemoryStack} and initializes all its bits to zero.
     *
     * @param stack    the stack from which to allocate
     * @param capacity the buffer capacity
     */
    public static VkPhysicalDeviceExternalFormatResolvePropertiesANDROID.Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    // -----------------------------------

    /** Unsafe version of {@link #sType}. */
    public static int nsType(long struct) { return UNSAFE.getInt(null, struct + VkPhysicalDeviceExternalFormatResolvePropertiesANDROID.STYPE); }
    /** Unsafe version of {@link #pNext}. */
    public static long npNext(long struct) { return memGetAddress(struct + VkPhysicalDeviceExternalFormatResolvePropertiesANDROID.PNEXT); }
    /** Unsafe version of {@link #nullColorAttachmentWithExternalFormatResolve}. */
    public static int nnullColorAttachmentWithExternalFormatResolve(long struct) { return UNSAFE.getInt(null, struct + VkPhysicalDeviceExternalFormatResolvePropertiesANDROID.NULLCOLORATTACHMENTWITHEXTERNALFORMATRESOLVE); }
    /** Unsafe version of {@link #externalFormatResolveChromaOffsetX}. */
    public static int nexternalFormatResolveChromaOffsetX(long struct) { return UNSAFE.getInt(null, struct + VkPhysicalDeviceExternalFormatResolvePropertiesANDROID.EXTERNALFORMATRESOLVECHROMAOFFSETX); }
    /** Unsafe version of {@link #externalFormatResolveChromaOffsetY}. */
    public static int nexternalFormatResolveChromaOffsetY(long struct) { return UNSAFE.getInt(null, struct + VkPhysicalDeviceExternalFormatResolvePropertiesANDROID.EXTERNALFORMATRESOLVECHROMAOFFSETY); }

    /** Unsafe version of {@link #sType(int) sType}. */
    public static void nsType(long struct, int value) { UNSAFE.putInt(null, struct + VkPhysicalDeviceExternalFormatResolvePropertiesANDROID.STYPE, value); }
    /** Unsafe version of {@link #pNext(long) pNext}. */
    public static void npNext(long struct, long value) { memPutAddress(struct + VkPhysicalDeviceExternalFormatResolvePropertiesANDROID.PNEXT, value); }

    // -----------------------------------

    /** An array of {@link VkPhysicalDeviceExternalFormatResolvePropertiesANDROID} structs. */
    public static class Buffer extends StructBuffer<VkPhysicalDeviceExternalFormatResolvePropertiesANDROID, Buffer> implements NativeResource {

        private static final VkPhysicalDeviceExternalFormatResolvePropertiesANDROID ELEMENT_FACTORY = VkPhysicalDeviceExternalFormatResolvePropertiesANDROID.create(-1L);

        /**
         * Creates a new {@code VkPhysicalDeviceExternalFormatResolvePropertiesANDROID.Buffer} instance backed by the specified container.
         *
         * <p>Changes to the container's content will be visible to the struct buffer instance and vice versa. The two buffers' position, limit, and mark values
         * will be independent. The new buffer's position will be zero, its capacity and its limit will be the number of bytes remaining in this buffer divided
         * by {@link VkPhysicalDeviceExternalFormatResolvePropertiesANDROID#SIZEOF}, and its mark will be undefined.</p>
         *
         * <p>The created buffer instance holds a strong reference to the container object.</p>
         */
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkPhysicalDeviceExternalFormatResolvePropertiesANDROID getElementFactory() {
            return ELEMENT_FACTORY;
        }

        /** @return the value of the {@link VkPhysicalDeviceExternalFormatResolvePropertiesANDROID#sType} field. */
        @NativeType("VkStructureType")
        public int sType() { return VkPhysicalDeviceExternalFormatResolvePropertiesANDROID.nsType(address()); }
        /** @return the value of the {@link VkPhysicalDeviceExternalFormatResolvePropertiesANDROID#pNext} field. */
        @NativeType("void *")
        public long pNext() { return VkPhysicalDeviceExternalFormatResolvePropertiesANDROID.npNext(address()); }
        /** @return the value of the {@link VkPhysicalDeviceExternalFormatResolvePropertiesANDROID#nullColorAttachmentWithExternalFormatResolve} field. */
        @NativeType("VkBool32")
        public boolean nullColorAttachmentWithExternalFormatResolve() { return VkPhysicalDeviceExternalFormatResolvePropertiesANDROID.nnullColorAttachmentWithExternalFormatResolve(address()) != 0; }
        /** @return the value of the {@link VkPhysicalDeviceExternalFormatResolvePropertiesANDROID#externalFormatResolveChromaOffsetX} field. */
        @NativeType("VkChromaLocation")
        public int externalFormatResolveChromaOffsetX() { return VkPhysicalDeviceExternalFormatResolvePropertiesANDROID.nexternalFormatResolveChromaOffsetX(address()); }
        /** @return the value of the {@link VkPhysicalDeviceExternalFormatResolvePropertiesANDROID#externalFormatResolveChromaOffsetY} field. */
        @NativeType("VkChromaLocation")
        public int externalFormatResolveChromaOffsetY() { return VkPhysicalDeviceExternalFormatResolvePropertiesANDROID.nexternalFormatResolveChromaOffsetY(address()); }

        /** Sets the specified value to the {@link VkPhysicalDeviceExternalFormatResolvePropertiesANDROID#sType} field. */
        public VkPhysicalDeviceExternalFormatResolvePropertiesANDROID.Buffer sType(@NativeType("VkStructureType") int value) { VkPhysicalDeviceExternalFormatResolvePropertiesANDROID.nsType(address(), value); return this; }
        /** Sets the {@link ANDROIDExternalFormatResolve#VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_FORMAT_RESOLVE_PROPERTIES_ANDROID STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_FORMAT_RESOLVE_PROPERTIES_ANDROID} value to the {@link VkPhysicalDeviceExternalFormatResolvePropertiesANDROID#sType} field. */
        public VkPhysicalDeviceExternalFormatResolvePropertiesANDROID.Buffer sType$Default() { return sType(ANDROIDExternalFormatResolve.VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_FORMAT_RESOLVE_PROPERTIES_ANDROID); }
        /** Sets the specified value to the {@link VkPhysicalDeviceExternalFormatResolvePropertiesANDROID#pNext} field. */
        public VkPhysicalDeviceExternalFormatResolvePropertiesANDROID.Buffer pNext(@NativeType("void *") long value) { VkPhysicalDeviceExternalFormatResolvePropertiesANDROID.npNext(address(), value); return this; }

    }

}