/*
 * Copyright LWJGL. All rights reserved.
 * License terms: https://www.lwjgl.org/license
 * MACHINE GENERATED FILE, DO NOT EDIT
 */
package org.lwjgl.vulkan;

import javax.annotation.*;

import java.nio.*;

import org.lwjgl.*;
import org.lwjgl.system.*;

import static org.lwjgl.system.MemoryUtil.*;
import static org.lwjgl.system.MemoryStack.*;

/**
 * Structure describing corner sampled image features that can be supported by an implementation.
 * 
 * <h5>Description</h5>
 * 
 * <p>If the {@link VkPhysicalDeviceCornerSampledImageFeaturesNV} structure is included in the {@code pNext} chain of the {@link VkPhysicalDeviceFeatures2} structure passed to {@link VK11#vkGetPhysicalDeviceFeatures2 GetPhysicalDeviceFeatures2}, it is filled in to indicate whether each corresponding feature is supported. {@link VkPhysicalDeviceCornerSampledImageFeaturesNV} <b>can</b> also be used in the {@code pNext} chain of {@link VkDeviceCreateInfo} to selectively enable these features.</p>
 * 
 * <h5>Valid Usage (Implicit)</h5>
 * 
 * <ul>
 * <li>{@code sType} <b>must</b> be {@link NVCornerSampledImage#VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CORNER_SAMPLED_IMAGE_FEATURES_NV STRUCTURE_TYPE_PHYSICAL_DEVICE_CORNER_SAMPLED_IMAGE_FEATURES_NV}</li>
 * </ul>
 * 
 * <h3>Layout</h3>
 * 
 * <pre><code>
 * struct VkPhysicalDeviceCornerSampledImageFeaturesNV {
 *     VkStructureType {@link #sType};
 *     void * {@link #pNext};
 *     VkBool32 {@link #cornerSampledImage};
 * }</code></pre>
 */
public class VkPhysicalDeviceCornerSampledImageFeaturesNV extends Struct<VkPhysicalDeviceCornerSampledImageFeaturesNV> implements NativeResource {

    /** The struct size in bytes. */
    public static final int SIZEOF;

    /** The struct alignment in bytes. */
    public static final int ALIGNOF;

    /** The struct member offsets. */
    public static final int
        STYPE,
        PNEXT,
        CORNERSAMPLEDIMAGE;

    static {
        Layout layout = __struct(
            __member(4),
            __member(POINTER_SIZE),
            __member(4)
        );

        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();

        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        CORNERSAMPLEDIMAGE = layout.offsetof(2);
    }

    protected VkPhysicalDeviceCornerSampledImageFeaturesNV(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkPhysicalDeviceCornerSampledImageFeaturesNV create(long address, @Nullable ByteBuffer container) {
        return new VkPhysicalDeviceCornerSampledImageFeaturesNV(address, container);
    }

    /**
     * Creates a {@code VkPhysicalDeviceCornerSampledImageFeaturesNV} instance at the current position of the specified {@link ByteBuffer} container. Changes to the buffer's content will be
     * visible to the struct instance and vice versa.
     *
     * <p>The created instance holds a strong reference to the container object.</p>
     */
    public VkPhysicalDeviceCornerSampledImageFeaturesNV(ByteBuffer container) {
        super(memAddress(container), __checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() { return SIZEOF; }

    /** a {@code VkStructureType} value identifying this structure. */
    @NativeType("VkStructureType")
    public int sType() { return nsType(address()); }
    /** {@code NULL} or a pointer to a structure extending this structure. */
    @NativeType("void *")
    public long pNext() { return npNext(address()); }
    /** specifies whether images can be created with a {@link VkImageCreateInfo}{@code ::flags} containing {@link NVCornerSampledImage#VK_IMAGE_CREATE_CORNER_SAMPLED_BIT_NV IMAGE_CREATE_CORNER_SAMPLED_BIT_NV}. See <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#resources-images-corner-sampled">Corner-Sampled Images</a>. */
    @NativeType("VkBool32")
    public boolean cornerSampledImage() { return ncornerSampledImage(address()) != 0; }

    /** Sets the specified value to the {@link #sType} field. */
    public VkPhysicalDeviceCornerSampledImageFeaturesNV sType(@NativeType("VkStructureType") int value) { nsType(address(), value); return this; }
    /** Sets the {@link NVCornerSampledImage#VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CORNER_SAMPLED_IMAGE_FEATURES_NV STRUCTURE_TYPE_PHYSICAL_DEVICE_CORNER_SAMPLED_IMAGE_FEATURES_NV} value to the {@link #sType} field. */
    public VkPhysicalDeviceCornerSampledImageFeaturesNV sType$Default() { return sType(NVCornerSampledImage.VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CORNER_SAMPLED_IMAGE_FEATURES_NV); }
    /** Sets the specified value to the {@link #pNext} field. */
    public VkPhysicalDeviceCornerSampledImageFeaturesNV pNext(@NativeType("void *") long value) { npNext(address(), value); return this; }
    /** Sets the specified value to the {@link #cornerSampledImage} field. */
    public VkPhysicalDeviceCornerSampledImageFeaturesNV cornerSampledImage(@NativeType("VkBool32") boolean value) { ncornerSampledImage(address(), value ? 1 : 0); return this; }

    /** Initializes this struct with the specified values. */
    public VkPhysicalDeviceCornerSampledImageFeaturesNV set(
        int sType,
        long pNext,
        boolean cornerSampledImage
    ) {
        sType(sType);
        pNext(pNext);
        cornerSampledImage(cornerSampledImage);

        return this;
    }

    /**
     * Copies the specified struct data to this struct.
     *
     * @param src the source struct
     *
     * @return this struct
     */
    public VkPhysicalDeviceCornerSampledImageFeaturesNV set(VkPhysicalDeviceCornerSampledImageFeaturesNV src) {
        memCopy(src.address(), address(), SIZEOF);
        return this;
    }

    // -----------------------------------

    /** Returns a new {@code VkPhysicalDeviceCornerSampledImageFeaturesNV} instance allocated with {@link MemoryUtil#memAlloc memAlloc}. The instance must be explicitly freed. */
    public static VkPhysicalDeviceCornerSampledImageFeaturesNV malloc() {
        return new VkPhysicalDeviceCornerSampledImageFeaturesNV(nmemAllocChecked(SIZEOF), null);
    }

    /** Returns a new {@code VkPhysicalDeviceCornerSampledImageFeaturesNV} instance allocated with {@link MemoryUtil#memCalloc memCalloc}. The instance must be explicitly freed. */
    public static VkPhysicalDeviceCornerSampledImageFeaturesNV calloc() {
        return new VkPhysicalDeviceCornerSampledImageFeaturesNV(nmemCallocChecked(1, SIZEOF), null);
    }

    /** Returns a new {@code VkPhysicalDeviceCornerSampledImageFeaturesNV} instance allocated with {@link BufferUtils}. */
    public static VkPhysicalDeviceCornerSampledImageFeaturesNV create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkPhysicalDeviceCornerSampledImageFeaturesNV(memAddress(container), container);
    }

    /** Returns a new {@code VkPhysicalDeviceCornerSampledImageFeaturesNV} instance for the specified memory address. */
    public static VkPhysicalDeviceCornerSampledImageFeaturesNV create(long address) {
        return new VkPhysicalDeviceCornerSampledImageFeaturesNV(address, null);
    }

    /** Like {@link #create(long) create}, but returns {@code null} if {@code address} is {@code NULL}. */
    @Nullable
    public static VkPhysicalDeviceCornerSampledImageFeaturesNV createSafe(long address) {
        return address == NULL ? null : new VkPhysicalDeviceCornerSampledImageFeaturesNV(address, null);
    }

    /**
     * Returns a new {@link VkPhysicalDeviceCornerSampledImageFeaturesNV.Buffer} instance allocated with {@link MemoryUtil#memAlloc memAlloc}. The instance must be explicitly freed.
     *
     * @param capacity the buffer capacity
     */
    public static VkPhysicalDeviceCornerSampledImageFeaturesNV.Buffer malloc(int capacity) {
        return new Buffer(nmemAllocChecked(__checkMalloc(capacity, SIZEOF)), capacity);
    }

    /**
     * Returns a new {@link VkPhysicalDeviceCornerSampledImageFeaturesNV.Buffer} instance allocated with {@link MemoryUtil#memCalloc memCalloc}. The instance must be explicitly freed.
     *
     * @param capacity the buffer capacity
     */
    public static VkPhysicalDeviceCornerSampledImageFeaturesNV.Buffer calloc(int capacity) {
        return new Buffer(nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    /**
     * Returns a new {@link VkPhysicalDeviceCornerSampledImageFeaturesNV.Buffer} instance allocated with {@link BufferUtils}.
     *
     * @param capacity the buffer capacity
     */
    public static VkPhysicalDeviceCornerSampledImageFeaturesNV.Buffer create(int capacity) {
        ByteBuffer container = __create(capacity, SIZEOF);
        return new Buffer(memAddress(container), container, -1, 0, capacity, capacity);
    }

    /**
     * Create a {@link VkPhysicalDeviceCornerSampledImageFeaturesNV.Buffer} instance at the specified memory.
     *
     * @param address  the memory address
     * @param capacity the buffer capacity
     */
    public static VkPhysicalDeviceCornerSampledImageFeaturesNV.Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    /** Like {@link #create(long, int) create}, but returns {@code null} if {@code address} is {@code NULL}. */
    @Nullable
    public static VkPhysicalDeviceCornerSampledImageFeaturesNV.Buffer createSafe(long address, int capacity) {
        return address == NULL ? null : new Buffer(address, capacity);
    }

    // -----------------------------------

    /** Deprecated for removal in 3.4.0. Use {@link #malloc(MemoryStack)} instead. */
    @Deprecated public static VkPhysicalDeviceCornerSampledImageFeaturesNV mallocStack() { return malloc(stackGet()); }
    /** Deprecated for removal in 3.4.0. Use {@link #calloc(MemoryStack)} instead. */
    @Deprecated public static VkPhysicalDeviceCornerSampledImageFeaturesNV callocStack() { return calloc(stackGet()); }
    /** Deprecated for removal in 3.4.0. Use {@link #malloc(MemoryStack)} instead. */
    @Deprecated public static VkPhysicalDeviceCornerSampledImageFeaturesNV mallocStack(MemoryStack stack) { return malloc(stack); }
    /** Deprecated for removal in 3.4.0. Use {@link #calloc(MemoryStack)} instead. */
    @Deprecated public static VkPhysicalDeviceCornerSampledImageFeaturesNV callocStack(MemoryStack stack) { return calloc(stack); }
    /** Deprecated for removal in 3.4.0. Use {@link #malloc(int, MemoryStack)} instead. */
    @Deprecated public static VkPhysicalDeviceCornerSampledImageFeaturesNV.Buffer mallocStack(int capacity) { return malloc(capacity, stackGet()); }
    /** Deprecated for removal in 3.4.0. Use {@link #calloc(int, MemoryStack)} instead. */
    @Deprecated public static VkPhysicalDeviceCornerSampledImageFeaturesNV.Buffer callocStack(int capacity) { return calloc(capacity, stackGet()); }
    /** Deprecated for removal in 3.4.0. Use {@link #malloc(int, MemoryStack)} instead. */
    @Deprecated public static VkPhysicalDeviceCornerSampledImageFeaturesNV.Buffer mallocStack(int capacity, MemoryStack stack) { return malloc(capacity, stack); }
    /** Deprecated for removal in 3.4.0. Use {@link #calloc(int, MemoryStack)} instead. */
    @Deprecated public static VkPhysicalDeviceCornerSampledImageFeaturesNV.Buffer callocStack(int capacity, MemoryStack stack) { return calloc(capacity, stack); }

    /**
     * Returns a new {@code VkPhysicalDeviceCornerSampledImageFeaturesNV} instance allocated on the specified {@link MemoryStack}.
     *
     * @param stack the stack from which to allocate
     */
    public static VkPhysicalDeviceCornerSampledImageFeaturesNV malloc(MemoryStack stack) {
        return new VkPhysicalDeviceCornerSampledImageFeaturesNV(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    /**
     * Returns a new {@code VkPhysicalDeviceCornerSampledImageFeaturesNV} instance allocated on the specified {@link MemoryStack} and initializes all its bits to zero.
     *
     * @param stack the stack from which to allocate
     */
    public static VkPhysicalDeviceCornerSampledImageFeaturesNV calloc(MemoryStack stack) {
        return new VkPhysicalDeviceCornerSampledImageFeaturesNV(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    /**
     * Returns a new {@link VkPhysicalDeviceCornerSampledImageFeaturesNV.Buffer} instance allocated on the specified {@link MemoryStack}.
     *
     * @param stack    the stack from which to allocate
     * @param capacity the buffer capacity
     */
    public static VkPhysicalDeviceCornerSampledImageFeaturesNV.Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    /**
     * Returns a new {@link VkPhysicalDeviceCornerSampledImageFeaturesNV.Buffer} instance allocated on the specified {@link MemoryStack} and initializes all its bits to zero.
     *
     * @param stack    the stack from which to allocate
     * @param capacity the buffer capacity
     */
    public static VkPhysicalDeviceCornerSampledImageFeaturesNV.Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    // -----------------------------------

    /** Unsafe version of {@link #sType}. */
    public static int nsType(long struct) { return UNSAFE.getInt(null, struct + VkPhysicalDeviceCornerSampledImageFeaturesNV.STYPE); }
    /** Unsafe version of {@link #pNext}. */
    public static long npNext(long struct) { return memGetAddress(struct + VkPhysicalDeviceCornerSampledImageFeaturesNV.PNEXT); }
    /** Unsafe version of {@link #cornerSampledImage}. */
    public static int ncornerSampledImage(long struct) { return UNSAFE.getInt(null, struct + VkPhysicalDeviceCornerSampledImageFeaturesNV.CORNERSAMPLEDIMAGE); }

    /** Unsafe version of {@link #sType(int) sType}. */
    public static void nsType(long struct, int value) { UNSAFE.putInt(null, struct + VkPhysicalDeviceCornerSampledImageFeaturesNV.STYPE, value); }
    /** Unsafe version of {@link #pNext(long) pNext}. */
    public static void npNext(long struct, long value) { memPutAddress(struct + VkPhysicalDeviceCornerSampledImageFeaturesNV.PNEXT, value); }
    /** Unsafe version of {@link #cornerSampledImage(boolean) cornerSampledImage}. */
    public static void ncornerSampledImage(long struct, int value) { UNSAFE.putInt(null, struct + VkPhysicalDeviceCornerSampledImageFeaturesNV.CORNERSAMPLEDIMAGE, value); }

    // -----------------------------------

    /** An array of {@link VkPhysicalDeviceCornerSampledImageFeaturesNV} structs. */
    public static class Buffer extends StructBuffer<VkPhysicalDeviceCornerSampledImageFeaturesNV, Buffer> implements NativeResource {

        private static final VkPhysicalDeviceCornerSampledImageFeaturesNV ELEMENT_FACTORY = VkPhysicalDeviceCornerSampledImageFeaturesNV.create(-1L);

        /**
         * Creates a new {@code VkPhysicalDeviceCornerSampledImageFeaturesNV.Buffer} instance backed by the specified container.
         *
         * <p>Changes to the container's content will be visible to the struct buffer instance and vice versa. The two buffers' position, limit, and mark values
         * will be independent. The new buffer's position will be zero, its capacity and its limit will be the number of bytes remaining in this buffer divided
         * by {@link VkPhysicalDeviceCornerSampledImageFeaturesNV#SIZEOF}, and its mark will be undefined.</p>
         *
         * <p>The created buffer instance holds a strong reference to the container object.</p>
         */
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkPhysicalDeviceCornerSampledImageFeaturesNV getElementFactory() {
            return ELEMENT_FACTORY;
        }

        /** @return the value of the {@link VkPhysicalDeviceCornerSampledImageFeaturesNV#sType} field. */
        @NativeType("VkStructureType")
        public int sType() { return VkPhysicalDeviceCornerSampledImageFeaturesNV.nsType(address()); }
        /** @return the value of the {@link VkPhysicalDeviceCornerSampledImageFeaturesNV#pNext} field. */
        @NativeType("void *")
        public long pNext() { return VkPhysicalDeviceCornerSampledImageFeaturesNV.npNext(address()); }
        /** @return the value of the {@link VkPhysicalDeviceCornerSampledImageFeaturesNV#cornerSampledImage} field. */
        @NativeType("VkBool32")
        public boolean cornerSampledImage() { return VkPhysicalDeviceCornerSampledImageFeaturesNV.ncornerSampledImage(address()) != 0; }

        /** Sets the specified value to the {@link VkPhysicalDeviceCornerSampledImageFeaturesNV#sType} field. */
        public VkPhysicalDeviceCornerSampledImageFeaturesNV.Buffer sType(@NativeType("VkStructureType") int value) { VkPhysicalDeviceCornerSampledImageFeaturesNV.nsType(address(), value); return this; }
        /** Sets the {@link NVCornerSampledImage#VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CORNER_SAMPLED_IMAGE_FEATURES_NV STRUCTURE_TYPE_PHYSICAL_DEVICE_CORNER_SAMPLED_IMAGE_FEATURES_NV} value to the {@link VkPhysicalDeviceCornerSampledImageFeaturesNV#sType} field. */
        public VkPhysicalDeviceCornerSampledImageFeaturesNV.Buffer sType$Default() { return sType(NVCornerSampledImage.VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CORNER_SAMPLED_IMAGE_FEATURES_NV); }
        /** Sets the specified value to the {@link VkPhysicalDeviceCornerSampledImageFeaturesNV#pNext} field. */
        public VkPhysicalDeviceCornerSampledImageFeaturesNV.Buffer pNext(@NativeType("void *") long value) { VkPhysicalDeviceCornerSampledImageFeaturesNV.npNext(address(), value); return this; }
        /** Sets the specified value to the {@link VkPhysicalDeviceCornerSampledImageFeaturesNV#cornerSampledImage} field. */
        public VkPhysicalDeviceCornerSampledImageFeaturesNV.Buffer cornerSampledImage(@NativeType("VkBool32") boolean value) { VkPhysicalDeviceCornerSampledImageFeaturesNV.ncornerSampledImage(address(), value ? 1 : 0); return this; }

    }

}