/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.cuda;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CUmulticastObjectProp
extends Struct<CUmulticastObjectProp>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int NUMDEVICES;
    public static final int SIZE;
    public static final int HANDLETYPES;
    public static final int FLAGS;

    protected CUmulticastObjectProp(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected CUmulticastObjectProp create(long address, @Nullable ByteBuffer container) {
        return new CUmulticastObjectProp(address, container);
    }

    public CUmulticastObjectProp(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), CUmulticastObjectProp.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="unsigned int")
    public int numDevices() {
        return CUmulticastObjectProp.nnumDevices(this.address());
    }

    @NativeType(value="size_t")
    public long size() {
        return CUmulticastObjectProp.nsize(this.address());
    }

    @NativeType(value="unsigned long long")
    public long handleTypes() {
        return CUmulticastObjectProp.nhandleTypes(this.address());
    }

    @NativeType(value="unsigned long long")
    public long flags() {
        return CUmulticastObjectProp.nflags(this.address());
    }

    public CUmulticastObjectProp numDevices(@NativeType(value="unsigned int") int value) {
        CUmulticastObjectProp.nnumDevices(this.address(), value);
        return this;
    }

    public CUmulticastObjectProp size(@NativeType(value="size_t") long value) {
        CUmulticastObjectProp.nsize(this.address(), value);
        return this;
    }

    public CUmulticastObjectProp handleTypes(@NativeType(value="unsigned long long") long value) {
        CUmulticastObjectProp.nhandleTypes(this.address(), value);
        return this;
    }

    public CUmulticastObjectProp flags(@NativeType(value="unsigned long long") long value) {
        CUmulticastObjectProp.nflags(this.address(), value);
        return this;
    }

    public CUmulticastObjectProp set(int numDevices, long size, long handleTypes, long flags) {
        this.numDevices(numDevices);
        this.size(size);
        this.handleTypes(handleTypes);
        this.flags(flags);
        return this;
    }

    public CUmulticastObjectProp set(CUmulticastObjectProp src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static CUmulticastObjectProp malloc() {
        return new CUmulticastObjectProp(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static CUmulticastObjectProp calloc() {
        return new CUmulticastObjectProp(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static CUmulticastObjectProp create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new CUmulticastObjectProp(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static CUmulticastObjectProp create(long address) {
        return new CUmulticastObjectProp(address, null);
    }

    @Nullable
    public static CUmulticastObjectProp createSafe(long address) {
        return address == 0L ? null : new CUmulticastObjectProp(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)CUmulticastObjectProp.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = CUmulticastObjectProp.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static CUmulticastObjectProp malloc(MemoryStack stack) {
        return new CUmulticastObjectProp(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static CUmulticastObjectProp calloc(MemoryStack stack) {
        return new CUmulticastObjectProp(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nnumDevices(long struct) {
        return UNSAFE.getInt(null, struct + (long)NUMDEVICES);
    }

    public static long nsize(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)SIZE));
    }

    public static long nhandleTypes(long struct) {
        return UNSAFE.getLong(null, struct + (long)HANDLETYPES);
    }

    public static long nflags(long struct) {
        return UNSAFE.getLong(null, struct + (long)FLAGS);
    }

    public static void nnumDevices(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)NUMDEVICES, value);
    }

    public static void nsize(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)SIZE), (long)value);
    }

    public static void nhandleTypes(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)HANDLETYPES, value);
    }

    public static void nflags(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)FLAGS, value);
    }

    static {
        Struct.Layout layout = CUmulticastObjectProp.__struct((Struct.Member[])new Struct.Member[]{CUmulticastObjectProp.__member((int)4), CUmulticastObjectProp.__member((int)POINTER_SIZE), CUmulticastObjectProp.__member((int)8), CUmulticastObjectProp.__member((int)8)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        NUMDEVICES = layout.offsetof(0);
        SIZE = layout.offsetof(1);
        HANDLETYPES = layout.offsetof(2);
        FLAGS = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<CUmulticastObjectProp, Buffer>
    implements NativeResource {
        private static final CUmulticastObjectProp ELEMENT_FACTORY = CUmulticastObjectProp.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected CUmulticastObjectProp getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="unsigned int")
        public int numDevices() {
            return CUmulticastObjectProp.nnumDevices(this.address());
        }

        @NativeType(value="size_t")
        public long size() {
            return CUmulticastObjectProp.nsize(this.address());
        }

        @NativeType(value="unsigned long long")
        public long handleTypes() {
            return CUmulticastObjectProp.nhandleTypes(this.address());
        }

        @NativeType(value="unsigned long long")
        public long flags() {
            return CUmulticastObjectProp.nflags(this.address());
        }

        public Buffer numDevices(@NativeType(value="unsigned int") int value) {
            CUmulticastObjectProp.nnumDevices(this.address(), value);
            return this;
        }

        public Buffer size(@NativeType(value="size_t") long value) {
            CUmulticastObjectProp.nsize(this.address(), value);
            return this;
        }

        public Buffer handleTypes(@NativeType(value="unsigned long long") long value) {
            CUmulticastObjectProp.nhandleTypes(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="unsigned long long") long value) {
            CUmulticastObjectProp.nflags(this.address(), value);
            return this;
        }
    }
}

