/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.cuda;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.cuda.CUlaunchAttributeValue;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CUlaunchAttribute
extends Struct<CUlaunchAttribute>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int ID;
    public static final int PAD;
    public static final int VALUE;

    protected CUlaunchAttribute(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected CUlaunchAttribute create(long address, @Nullable ByteBuffer container) {
        return new CUlaunchAttribute(address, container);
    }

    public CUlaunchAttribute(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), CUlaunchAttribute.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="CUlaunchAttributeID")
    public int id() {
        return CUlaunchAttribute.nid(this.address());
    }

    @NativeType(value="char[4]")
    public ByteBuffer pad() {
        return CUlaunchAttribute.npad(this.address());
    }

    @NativeType(value="char")
    public byte pad(int index) {
        return CUlaunchAttribute.npad(this.address(), index);
    }

    public CUlaunchAttributeValue value() {
        return CUlaunchAttribute.nvalue(this.address());
    }

    public CUlaunchAttribute id(@NativeType(value="CUlaunchAttributeID") int value) {
        CUlaunchAttribute.nid(this.address(), value);
        return this;
    }

    public CUlaunchAttribute pad(@NativeType(value="char[4]") ByteBuffer value) {
        CUlaunchAttribute.npad(this.address(), value);
        return this;
    }

    public CUlaunchAttribute pad(int index, @NativeType(value="char") byte value) {
        CUlaunchAttribute.npad(this.address(), index, value);
        return this;
    }

    public CUlaunchAttribute value(CUlaunchAttributeValue value) {
        CUlaunchAttribute.nvalue(this.address(), value);
        return this;
    }

    public CUlaunchAttribute value(Consumer<CUlaunchAttributeValue> consumer) {
        consumer.accept(this.value());
        return this;
    }

    public CUlaunchAttribute set(int id, ByteBuffer pad, CUlaunchAttributeValue value) {
        this.id(id);
        this.pad(pad);
        this.value(value);
        return this;
    }

    public CUlaunchAttribute set(CUlaunchAttribute src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static CUlaunchAttribute malloc() {
        return new CUlaunchAttribute(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static CUlaunchAttribute calloc() {
        return new CUlaunchAttribute(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static CUlaunchAttribute create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new CUlaunchAttribute(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static CUlaunchAttribute create(long address) {
        return new CUlaunchAttribute(address, null);
    }

    @Nullable
    public static CUlaunchAttribute createSafe(long address) {
        return address == 0L ? null : new CUlaunchAttribute(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)CUlaunchAttribute.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = CUlaunchAttribute.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static CUlaunchAttribute malloc(MemoryStack stack) {
        return new CUlaunchAttribute(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static CUlaunchAttribute calloc(MemoryStack stack) {
        return new CUlaunchAttribute(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nid(long struct) {
        return UNSAFE.getInt(null, struct + (long)ID);
    }

    public static ByteBuffer npad(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)PAD), (int)4);
    }

    public static byte npad(long struct, int index) {
        return UNSAFE.getByte(null, struct + (long)PAD + Checks.check((int)index, (int)4) * 1L);
    }

    public static CUlaunchAttributeValue nvalue(long struct) {
        return CUlaunchAttributeValue.create(struct + (long)VALUE);
    }

    public static void nid(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)ID, value);
    }

    public static void npad(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((java.nio.Buffer)value, (int)4);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((ByteBuffer)value), (long)(struct + (long)PAD), (long)(value.remaining() * 1));
    }

    public static void npad(long struct, int index, byte value) {
        UNSAFE.putByte(null, struct + (long)PAD + Checks.check((int)index, (int)4) * 1L, value);
    }

    public static void nvalue(long struct, CUlaunchAttributeValue value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)VALUE), (long)CUlaunchAttributeValue.SIZEOF);
    }

    static {
        Struct.Layout layout = CUlaunchAttribute.__struct((Struct.Member[])new Struct.Member[]{CUlaunchAttribute.__member((int)4), CUlaunchAttribute.__array((int)1, (int)4), CUlaunchAttribute.__member((int)CUlaunchAttributeValue.SIZEOF, (int)CUlaunchAttributeValue.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        ID = layout.offsetof(0);
        PAD = layout.offsetof(1);
        VALUE = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<CUlaunchAttribute, Buffer>
    implements NativeResource {
        private static final CUlaunchAttribute ELEMENT_FACTORY = CUlaunchAttribute.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected CUlaunchAttribute getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="CUlaunchAttributeID")
        public int id() {
            return CUlaunchAttribute.nid(this.address());
        }

        @NativeType(value="char[4]")
        public ByteBuffer pad() {
            return CUlaunchAttribute.npad(this.address());
        }

        @NativeType(value="char")
        public byte pad(int index) {
            return CUlaunchAttribute.npad(this.address(), index);
        }

        public CUlaunchAttributeValue value() {
            return CUlaunchAttribute.nvalue(this.address());
        }

        public Buffer id(@NativeType(value="CUlaunchAttributeID") int value) {
            CUlaunchAttribute.nid(this.address(), value);
            return this;
        }

        public Buffer pad(@NativeType(value="char[4]") ByteBuffer value) {
            CUlaunchAttribute.npad(this.address(), value);
            return this;
        }

        public Buffer pad(int index, @NativeType(value="char") byte value) {
            CUlaunchAttribute.npad(this.address(), index, value);
            return this;
        }

        public Buffer value(CUlaunchAttributeValue value) {
            CUlaunchAttribute.nvalue(this.address(), value);
            return this;
        }

        public Buffer value(Consumer<CUlaunchAttributeValue> consumer) {
            consumer.accept(this.value());
            return this;
        }
    }
}

