/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.cuda;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CUDA_MEMCPY3D
extends Struct<CUDA_MEMCPY3D>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int SRCXINBYTES;
    public static final int SRCY;
    public static final int SRCZ;
    public static final int SRCLOD;
    public static final int SRCMEMORYTYPE;
    public static final int SRCHOST;
    public static final int SRCDEVICE;
    public static final int SRCARRAY;
    public static final int RESERVED0;
    public static final int SRCPITCH;
    public static final int SRCHEIGHT;
    public static final int DSTXINBYTES;
    public static final int DSTY;
    public static final int DSTZ;
    public static final int DSTLOD;
    public static final int DSTMEMORYTYPE;
    public static final int DSTHOST;
    public static final int DSTDEVICE;
    public static final int DSTARRAY;
    public static final int RESERVED1;
    public static final int DSTPITCH;
    public static final int DSTHEIGHT;
    public static final int WIDTHINBYTES;
    public static final int HEIGHT;
    public static final int DEPTH;

    protected CUDA_MEMCPY3D(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected CUDA_MEMCPY3D create(long address, @Nullable ByteBuffer container) {
        return new CUDA_MEMCPY3D(address, container);
    }

    public CUDA_MEMCPY3D(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), CUDA_MEMCPY3D.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="size_t")
    public long srcXInBytes() {
        return CUDA_MEMCPY3D.nsrcXInBytes(this.address());
    }

    @NativeType(value="size_t")
    public long srcY() {
        return CUDA_MEMCPY3D.nsrcY(this.address());
    }

    @NativeType(value="size_t")
    public long srcZ() {
        return CUDA_MEMCPY3D.nsrcZ(this.address());
    }

    @NativeType(value="size_t")
    public long srcLOD() {
        return CUDA_MEMCPY3D.nsrcLOD(this.address());
    }

    @NativeType(value="CUmemorytype")
    public int srcMemoryType() {
        return CUDA_MEMCPY3D.nsrcMemoryType(this.address());
    }

    @Nullable
    @NativeType(value="void const *")
    public ByteBuffer srcHost(int capacity) {
        return CUDA_MEMCPY3D.nsrcHost(this.address(), capacity);
    }

    @NativeType(value="CUdeviceptr")
    public long srcDevice() {
        return CUDA_MEMCPY3D.nsrcDevice(this.address());
    }

    @NativeType(value="CUarray")
    public long srcArray() {
        return CUDA_MEMCPY3D.nsrcArray(this.address());
    }

    @NativeType(value="void *")
    public long reserved0() {
        return CUDA_MEMCPY3D.nreserved0(this.address());
    }

    @NativeType(value="size_t")
    public long srcPitch() {
        return CUDA_MEMCPY3D.nsrcPitch(this.address());
    }

    @NativeType(value="size_t")
    public long srcHeight() {
        return CUDA_MEMCPY3D.nsrcHeight(this.address());
    }

    @NativeType(value="size_t")
    public long dstXInBytes() {
        return CUDA_MEMCPY3D.ndstXInBytes(this.address());
    }

    @NativeType(value="size_t")
    public long dstY() {
        return CUDA_MEMCPY3D.ndstY(this.address());
    }

    @NativeType(value="size_t")
    public long dstZ() {
        return CUDA_MEMCPY3D.ndstZ(this.address());
    }

    @NativeType(value="size_t")
    public long dstLOD() {
        return CUDA_MEMCPY3D.ndstLOD(this.address());
    }

    @NativeType(value="CUmemorytype")
    public int dstMemoryType() {
        return CUDA_MEMCPY3D.ndstMemoryType(this.address());
    }

    @Nullable
    @NativeType(value="void *")
    public ByteBuffer dstHost(int capacity) {
        return CUDA_MEMCPY3D.ndstHost(this.address(), capacity);
    }

    @NativeType(value="CUdeviceptr")
    public long dstDevice() {
        return CUDA_MEMCPY3D.ndstDevice(this.address());
    }

    @NativeType(value="CUarray")
    public long dstArray() {
        return CUDA_MEMCPY3D.ndstArray(this.address());
    }

    @NativeType(value="void *")
    public long reserved1() {
        return CUDA_MEMCPY3D.nreserved1(this.address());
    }

    @NativeType(value="size_t")
    public long dstPitch() {
        return CUDA_MEMCPY3D.ndstPitch(this.address());
    }

    @NativeType(value="size_t")
    public long dstHeight() {
        return CUDA_MEMCPY3D.ndstHeight(this.address());
    }

    @NativeType(value="size_t")
    public long WidthInBytes() {
        return CUDA_MEMCPY3D.nWidthInBytes(this.address());
    }

    @NativeType(value="size_t")
    public long Height() {
        return CUDA_MEMCPY3D.nHeight(this.address());
    }

    @NativeType(value="size_t")
    public long Depth() {
        return CUDA_MEMCPY3D.nDepth(this.address());
    }

    public CUDA_MEMCPY3D srcXInBytes(@NativeType(value="size_t") long value) {
        CUDA_MEMCPY3D.nsrcXInBytes(this.address(), value);
        return this;
    }

    public CUDA_MEMCPY3D srcY(@NativeType(value="size_t") long value) {
        CUDA_MEMCPY3D.nsrcY(this.address(), value);
        return this;
    }

    public CUDA_MEMCPY3D srcZ(@NativeType(value="size_t") long value) {
        CUDA_MEMCPY3D.nsrcZ(this.address(), value);
        return this;
    }

    public CUDA_MEMCPY3D srcLOD(@NativeType(value="size_t") long value) {
        CUDA_MEMCPY3D.nsrcLOD(this.address(), value);
        return this;
    }

    public CUDA_MEMCPY3D srcMemoryType(@NativeType(value="CUmemorytype") int value) {
        CUDA_MEMCPY3D.nsrcMemoryType(this.address(), value);
        return this;
    }

    public CUDA_MEMCPY3D srcHost(@Nullable @NativeType(value="void const *") ByteBuffer value) {
        CUDA_MEMCPY3D.nsrcHost(this.address(), value);
        return this;
    }

    public CUDA_MEMCPY3D srcDevice(@NativeType(value="CUdeviceptr") long value) {
        CUDA_MEMCPY3D.nsrcDevice(this.address(), value);
        return this;
    }

    public CUDA_MEMCPY3D srcArray(@NativeType(value="CUarray") long value) {
        CUDA_MEMCPY3D.nsrcArray(this.address(), value);
        return this;
    }

    public CUDA_MEMCPY3D reserved0(@NativeType(value="void *") long value) {
        CUDA_MEMCPY3D.nreserved0(this.address(), value);
        return this;
    }

    public CUDA_MEMCPY3D srcPitch(@NativeType(value="size_t") long value) {
        CUDA_MEMCPY3D.nsrcPitch(this.address(), value);
        return this;
    }

    public CUDA_MEMCPY3D srcHeight(@NativeType(value="size_t") long value) {
        CUDA_MEMCPY3D.nsrcHeight(this.address(), value);
        return this;
    }

    public CUDA_MEMCPY3D dstXInBytes(@NativeType(value="size_t") long value) {
        CUDA_MEMCPY3D.ndstXInBytes(this.address(), value);
        return this;
    }

    public CUDA_MEMCPY3D dstY(@NativeType(value="size_t") long value) {
        CUDA_MEMCPY3D.ndstY(this.address(), value);
        return this;
    }

    public CUDA_MEMCPY3D dstZ(@NativeType(value="size_t") long value) {
        CUDA_MEMCPY3D.ndstZ(this.address(), value);
        return this;
    }

    public CUDA_MEMCPY3D dstLOD(@NativeType(value="size_t") long value) {
        CUDA_MEMCPY3D.ndstLOD(this.address(), value);
        return this;
    }

    public CUDA_MEMCPY3D dstMemoryType(@NativeType(value="CUmemorytype") int value) {
        CUDA_MEMCPY3D.ndstMemoryType(this.address(), value);
        return this;
    }

    public CUDA_MEMCPY3D dstHost(@Nullable @NativeType(value="void *") ByteBuffer value) {
        CUDA_MEMCPY3D.ndstHost(this.address(), value);
        return this;
    }

    public CUDA_MEMCPY3D dstDevice(@NativeType(value="CUdeviceptr") long value) {
        CUDA_MEMCPY3D.ndstDevice(this.address(), value);
        return this;
    }

    public CUDA_MEMCPY3D dstArray(@NativeType(value="CUarray") long value) {
        CUDA_MEMCPY3D.ndstArray(this.address(), value);
        return this;
    }

    public CUDA_MEMCPY3D reserved1(@NativeType(value="void *") long value) {
        CUDA_MEMCPY3D.nreserved1(this.address(), value);
        return this;
    }

    public CUDA_MEMCPY3D dstPitch(@NativeType(value="size_t") long value) {
        CUDA_MEMCPY3D.ndstPitch(this.address(), value);
        return this;
    }

    public CUDA_MEMCPY3D dstHeight(@NativeType(value="size_t") long value) {
        CUDA_MEMCPY3D.ndstHeight(this.address(), value);
        return this;
    }

    public CUDA_MEMCPY3D WidthInBytes(@NativeType(value="size_t") long value) {
        CUDA_MEMCPY3D.nWidthInBytes(this.address(), value);
        return this;
    }

    public CUDA_MEMCPY3D Height(@NativeType(value="size_t") long value) {
        CUDA_MEMCPY3D.nHeight(this.address(), value);
        return this;
    }

    public CUDA_MEMCPY3D Depth(@NativeType(value="size_t") long value) {
        CUDA_MEMCPY3D.nDepth(this.address(), value);
        return this;
    }

    public CUDA_MEMCPY3D set(long srcXInBytes, long srcY, long srcZ, long srcLOD, int srcMemoryType, @Nullable ByteBuffer srcHost, long srcDevice, long srcArray, long reserved0, long srcPitch, long srcHeight, long dstXInBytes, long dstY, long dstZ, long dstLOD, int dstMemoryType, @Nullable ByteBuffer dstHost, long dstDevice, long dstArray, long reserved1, long dstPitch, long dstHeight, long WidthInBytes, long Height, long Depth) {
        this.srcXInBytes(srcXInBytes);
        this.srcY(srcY);
        this.srcZ(srcZ);
        this.srcLOD(srcLOD);
        this.srcMemoryType(srcMemoryType);
        this.srcHost(srcHost);
        this.srcDevice(srcDevice);
        this.srcArray(srcArray);
        this.reserved0(reserved0);
        this.srcPitch(srcPitch);
        this.srcHeight(srcHeight);
        this.dstXInBytes(dstXInBytes);
        this.dstY(dstY);
        this.dstZ(dstZ);
        this.dstLOD(dstLOD);
        this.dstMemoryType(dstMemoryType);
        this.dstHost(dstHost);
        this.dstDevice(dstDevice);
        this.dstArray(dstArray);
        this.reserved1(reserved1);
        this.dstPitch(dstPitch);
        this.dstHeight(dstHeight);
        this.WidthInBytes(WidthInBytes);
        this.Height(Height);
        this.Depth(Depth);
        return this;
    }

    public CUDA_MEMCPY3D set(CUDA_MEMCPY3D src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static CUDA_MEMCPY3D malloc() {
        return new CUDA_MEMCPY3D(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static CUDA_MEMCPY3D calloc() {
        return new CUDA_MEMCPY3D(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static CUDA_MEMCPY3D create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new CUDA_MEMCPY3D(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static CUDA_MEMCPY3D create(long address) {
        return new CUDA_MEMCPY3D(address, null);
    }

    @Nullable
    public static CUDA_MEMCPY3D createSafe(long address) {
        return address == 0L ? null : new CUDA_MEMCPY3D(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)CUDA_MEMCPY3D.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = CUDA_MEMCPY3D.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static CUDA_MEMCPY3D mallocStack() {
        return CUDA_MEMCPY3D.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static CUDA_MEMCPY3D callocStack() {
        return CUDA_MEMCPY3D.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static CUDA_MEMCPY3D mallocStack(MemoryStack stack) {
        return CUDA_MEMCPY3D.malloc(stack);
    }

    @Deprecated
    public static CUDA_MEMCPY3D callocStack(MemoryStack stack) {
        return CUDA_MEMCPY3D.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return CUDA_MEMCPY3D.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return CUDA_MEMCPY3D.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return CUDA_MEMCPY3D.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return CUDA_MEMCPY3D.calloc(capacity, stack);
    }

    public static CUDA_MEMCPY3D malloc(MemoryStack stack) {
        return new CUDA_MEMCPY3D(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static CUDA_MEMCPY3D calloc(MemoryStack stack) {
        return new CUDA_MEMCPY3D(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nsrcXInBytes(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)SRCXINBYTES));
    }

    public static long nsrcY(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)SRCY));
    }

    public static long nsrcZ(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)SRCZ));
    }

    public static long nsrcLOD(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)SRCLOD));
    }

    public static int nsrcMemoryType(long struct) {
        return UNSAFE.getInt(null, struct + (long)SRCMEMORYTYPE);
    }

    @Nullable
    public static ByteBuffer nsrcHost(long struct, int capacity) {
        return MemoryUtil.memByteBufferSafe((long)MemoryUtil.memGetAddress((long)(struct + (long)SRCHOST)), (int)capacity);
    }

    public static long nsrcDevice(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)SRCDEVICE));
    }

    public static long nsrcArray(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)SRCARRAY));
    }

    public static long nreserved0(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)RESERVED0));
    }

    public static long nsrcPitch(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)SRCPITCH));
    }

    public static long nsrcHeight(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)SRCHEIGHT));
    }

    public static long ndstXInBytes(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)DSTXINBYTES));
    }

    public static long ndstY(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)DSTY));
    }

    public static long ndstZ(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)DSTZ));
    }

    public static long ndstLOD(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)DSTLOD));
    }

    public static int ndstMemoryType(long struct) {
        return UNSAFE.getInt(null, struct + (long)DSTMEMORYTYPE);
    }

    @Nullable
    public static ByteBuffer ndstHost(long struct, int capacity) {
        return MemoryUtil.memByteBufferSafe((long)MemoryUtil.memGetAddress((long)(struct + (long)DSTHOST)), (int)capacity);
    }

    public static long ndstDevice(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)DSTDEVICE));
    }

    public static long ndstArray(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)DSTARRAY));
    }

    public static long nreserved1(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)RESERVED1));
    }

    public static long ndstPitch(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)DSTPITCH));
    }

    public static long ndstHeight(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)DSTHEIGHT));
    }

    public static long nWidthInBytes(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)WIDTHINBYTES));
    }

    public static long nHeight(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)HEIGHT));
    }

    public static long nDepth(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)DEPTH));
    }

    public static void nsrcXInBytes(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)SRCXINBYTES), (long)value);
    }

    public static void nsrcY(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)SRCY), (long)value);
    }

    public static void nsrcZ(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)SRCZ), (long)value);
    }

    public static void nsrcLOD(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)SRCLOD), (long)value);
    }

    public static void nsrcMemoryType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SRCMEMORYTYPE, value);
    }

    public static void nsrcHost(long struct, @Nullable ByteBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)SRCHOST), (long)MemoryUtil.memAddressSafe((ByteBuffer)value));
    }

    public static void nsrcDevice(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)SRCDEVICE), (long)value);
    }

    public static void nsrcArray(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)SRCARRAY), (long)value);
    }

    public static void nreserved0(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)RESERVED0), (long)value);
    }

    public static void nsrcPitch(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)SRCPITCH), (long)value);
    }

    public static void nsrcHeight(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)SRCHEIGHT), (long)value);
    }

    public static void ndstXInBytes(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)DSTXINBYTES), (long)value);
    }

    public static void ndstY(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)DSTY), (long)value);
    }

    public static void ndstZ(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)DSTZ), (long)value);
    }

    public static void ndstLOD(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)DSTLOD), (long)value);
    }

    public static void ndstMemoryType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)DSTMEMORYTYPE, value);
    }

    public static void ndstHost(long struct, @Nullable ByteBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)DSTHOST), (long)MemoryUtil.memAddressSafe((ByteBuffer)value));
    }

    public static void ndstDevice(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)DSTDEVICE), (long)value);
    }

    public static void ndstArray(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)DSTARRAY), (long)value);
    }

    public static void nreserved1(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)RESERVED1), (long)value);
    }

    public static void ndstPitch(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)DSTPITCH), (long)value);
    }

    public static void ndstHeight(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)DSTHEIGHT), (long)value);
    }

    public static void nWidthInBytes(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)WIDTHINBYTES), (long)value);
    }

    public static void nHeight(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)HEIGHT), (long)value);
    }

    public static void nDepth(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)DEPTH), (long)value);
    }

    static {
        Struct.Layout layout = CUDA_MEMCPY3D.__struct((Struct.Member[])new Struct.Member[]{CUDA_MEMCPY3D.__member((int)POINTER_SIZE), CUDA_MEMCPY3D.__member((int)POINTER_SIZE), CUDA_MEMCPY3D.__member((int)POINTER_SIZE), CUDA_MEMCPY3D.__member((int)POINTER_SIZE), CUDA_MEMCPY3D.__member((int)4), CUDA_MEMCPY3D.__member((int)POINTER_SIZE), CUDA_MEMCPY3D.__member((int)POINTER_SIZE), CUDA_MEMCPY3D.__member((int)POINTER_SIZE), CUDA_MEMCPY3D.__member((int)POINTER_SIZE), CUDA_MEMCPY3D.__member((int)POINTER_SIZE), CUDA_MEMCPY3D.__member((int)POINTER_SIZE), CUDA_MEMCPY3D.__member((int)POINTER_SIZE), CUDA_MEMCPY3D.__member((int)POINTER_SIZE), CUDA_MEMCPY3D.__member((int)POINTER_SIZE), CUDA_MEMCPY3D.__member((int)POINTER_SIZE), CUDA_MEMCPY3D.__member((int)4), CUDA_MEMCPY3D.__member((int)POINTER_SIZE), CUDA_MEMCPY3D.__member((int)POINTER_SIZE), CUDA_MEMCPY3D.__member((int)POINTER_SIZE), CUDA_MEMCPY3D.__member((int)POINTER_SIZE), CUDA_MEMCPY3D.__member((int)POINTER_SIZE), CUDA_MEMCPY3D.__member((int)POINTER_SIZE), CUDA_MEMCPY3D.__member((int)POINTER_SIZE), CUDA_MEMCPY3D.__member((int)POINTER_SIZE), CUDA_MEMCPY3D.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        SRCXINBYTES = layout.offsetof(0);
        SRCY = layout.offsetof(1);
        SRCZ = layout.offsetof(2);
        SRCLOD = layout.offsetof(3);
        SRCMEMORYTYPE = layout.offsetof(4);
        SRCHOST = layout.offsetof(5);
        SRCDEVICE = layout.offsetof(6);
        SRCARRAY = layout.offsetof(7);
        RESERVED0 = layout.offsetof(8);
        SRCPITCH = layout.offsetof(9);
        SRCHEIGHT = layout.offsetof(10);
        DSTXINBYTES = layout.offsetof(11);
        DSTY = layout.offsetof(12);
        DSTZ = layout.offsetof(13);
        DSTLOD = layout.offsetof(14);
        DSTMEMORYTYPE = layout.offsetof(15);
        DSTHOST = layout.offsetof(16);
        DSTDEVICE = layout.offsetof(17);
        DSTARRAY = layout.offsetof(18);
        RESERVED1 = layout.offsetof(19);
        DSTPITCH = layout.offsetof(20);
        DSTHEIGHT = layout.offsetof(21);
        WIDTHINBYTES = layout.offsetof(22);
        HEIGHT = layout.offsetof(23);
        DEPTH = layout.offsetof(24);
    }

    public static class Buffer
    extends StructBuffer<CUDA_MEMCPY3D, Buffer>
    implements NativeResource {
        private static final CUDA_MEMCPY3D ELEMENT_FACTORY = CUDA_MEMCPY3D.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected CUDA_MEMCPY3D getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="size_t")
        public long srcXInBytes() {
            return CUDA_MEMCPY3D.nsrcXInBytes(this.address());
        }

        @NativeType(value="size_t")
        public long srcY() {
            return CUDA_MEMCPY3D.nsrcY(this.address());
        }

        @NativeType(value="size_t")
        public long srcZ() {
            return CUDA_MEMCPY3D.nsrcZ(this.address());
        }

        @NativeType(value="size_t")
        public long srcLOD() {
            return CUDA_MEMCPY3D.nsrcLOD(this.address());
        }

        @NativeType(value="CUmemorytype")
        public int srcMemoryType() {
            return CUDA_MEMCPY3D.nsrcMemoryType(this.address());
        }

        @Nullable
        @NativeType(value="void const *")
        public ByteBuffer srcHost(int capacity) {
            return CUDA_MEMCPY3D.nsrcHost(this.address(), capacity);
        }

        @NativeType(value="CUdeviceptr")
        public long srcDevice() {
            return CUDA_MEMCPY3D.nsrcDevice(this.address());
        }

        @NativeType(value="CUarray")
        public long srcArray() {
            return CUDA_MEMCPY3D.nsrcArray(this.address());
        }

        @NativeType(value="void *")
        public long reserved0() {
            return CUDA_MEMCPY3D.nreserved0(this.address());
        }

        @NativeType(value="size_t")
        public long srcPitch() {
            return CUDA_MEMCPY3D.nsrcPitch(this.address());
        }

        @NativeType(value="size_t")
        public long srcHeight() {
            return CUDA_MEMCPY3D.nsrcHeight(this.address());
        }

        @NativeType(value="size_t")
        public long dstXInBytes() {
            return CUDA_MEMCPY3D.ndstXInBytes(this.address());
        }

        @NativeType(value="size_t")
        public long dstY() {
            return CUDA_MEMCPY3D.ndstY(this.address());
        }

        @NativeType(value="size_t")
        public long dstZ() {
            return CUDA_MEMCPY3D.ndstZ(this.address());
        }

        @NativeType(value="size_t")
        public long dstLOD() {
            return CUDA_MEMCPY3D.ndstLOD(this.address());
        }

        @NativeType(value="CUmemorytype")
        public int dstMemoryType() {
            return CUDA_MEMCPY3D.ndstMemoryType(this.address());
        }

        @Nullable
        @NativeType(value="void *")
        public ByteBuffer dstHost(int capacity) {
            return CUDA_MEMCPY3D.ndstHost(this.address(), capacity);
        }

        @NativeType(value="CUdeviceptr")
        public long dstDevice() {
            return CUDA_MEMCPY3D.ndstDevice(this.address());
        }

        @NativeType(value="CUarray")
        public long dstArray() {
            return CUDA_MEMCPY3D.ndstArray(this.address());
        }

        @NativeType(value="void *")
        public long reserved1() {
            return CUDA_MEMCPY3D.nreserved1(this.address());
        }

        @NativeType(value="size_t")
        public long dstPitch() {
            return CUDA_MEMCPY3D.ndstPitch(this.address());
        }

        @NativeType(value="size_t")
        public long dstHeight() {
            return CUDA_MEMCPY3D.ndstHeight(this.address());
        }

        @NativeType(value="size_t")
        public long WidthInBytes() {
            return CUDA_MEMCPY3D.nWidthInBytes(this.address());
        }

        @NativeType(value="size_t")
        public long Height() {
            return CUDA_MEMCPY3D.nHeight(this.address());
        }

        @NativeType(value="size_t")
        public long Depth() {
            return CUDA_MEMCPY3D.nDepth(this.address());
        }

        public Buffer srcXInBytes(@NativeType(value="size_t") long value) {
            CUDA_MEMCPY3D.nsrcXInBytes(this.address(), value);
            return this;
        }

        public Buffer srcY(@NativeType(value="size_t") long value) {
            CUDA_MEMCPY3D.nsrcY(this.address(), value);
            return this;
        }

        public Buffer srcZ(@NativeType(value="size_t") long value) {
            CUDA_MEMCPY3D.nsrcZ(this.address(), value);
            return this;
        }

        public Buffer srcLOD(@NativeType(value="size_t") long value) {
            CUDA_MEMCPY3D.nsrcLOD(this.address(), value);
            return this;
        }

        public Buffer srcMemoryType(@NativeType(value="CUmemorytype") int value) {
            CUDA_MEMCPY3D.nsrcMemoryType(this.address(), value);
            return this;
        }

        public Buffer srcHost(@Nullable @NativeType(value="void const *") ByteBuffer value) {
            CUDA_MEMCPY3D.nsrcHost(this.address(), value);
            return this;
        }

        public Buffer srcDevice(@NativeType(value="CUdeviceptr") long value) {
            CUDA_MEMCPY3D.nsrcDevice(this.address(), value);
            return this;
        }

        public Buffer srcArray(@NativeType(value="CUarray") long value) {
            CUDA_MEMCPY3D.nsrcArray(this.address(), value);
            return this;
        }

        public Buffer reserved0(@NativeType(value="void *") long value) {
            CUDA_MEMCPY3D.nreserved0(this.address(), value);
            return this;
        }

        public Buffer srcPitch(@NativeType(value="size_t") long value) {
            CUDA_MEMCPY3D.nsrcPitch(this.address(), value);
            return this;
        }

        public Buffer srcHeight(@NativeType(value="size_t") long value) {
            CUDA_MEMCPY3D.nsrcHeight(this.address(), value);
            return this;
        }

        public Buffer dstXInBytes(@NativeType(value="size_t") long value) {
            CUDA_MEMCPY3D.ndstXInBytes(this.address(), value);
            return this;
        }

        public Buffer dstY(@NativeType(value="size_t") long value) {
            CUDA_MEMCPY3D.ndstY(this.address(), value);
            return this;
        }

        public Buffer dstZ(@NativeType(value="size_t") long value) {
            CUDA_MEMCPY3D.ndstZ(this.address(), value);
            return this;
        }

        public Buffer dstLOD(@NativeType(value="size_t") long value) {
            CUDA_MEMCPY3D.ndstLOD(this.address(), value);
            return this;
        }

        public Buffer dstMemoryType(@NativeType(value="CUmemorytype") int value) {
            CUDA_MEMCPY3D.ndstMemoryType(this.address(), value);
            return this;
        }

        public Buffer dstHost(@Nullable @NativeType(value="void *") ByteBuffer value) {
            CUDA_MEMCPY3D.ndstHost(this.address(), value);
            return this;
        }

        public Buffer dstDevice(@NativeType(value="CUdeviceptr") long value) {
            CUDA_MEMCPY3D.ndstDevice(this.address(), value);
            return this;
        }

        public Buffer dstArray(@NativeType(value="CUarray") long value) {
            CUDA_MEMCPY3D.ndstArray(this.address(), value);
            return this;
        }

        public Buffer reserved1(@NativeType(value="void *") long value) {
            CUDA_MEMCPY3D.nreserved1(this.address(), value);
            return this;
        }

        public Buffer dstPitch(@NativeType(value="size_t") long value) {
            CUDA_MEMCPY3D.ndstPitch(this.address(), value);
            return this;
        }

        public Buffer dstHeight(@NativeType(value="size_t") long value) {
            CUDA_MEMCPY3D.ndstHeight(this.address(), value);
            return this;
        }

        public Buffer WidthInBytes(@NativeType(value="size_t") long value) {
            CUDA_MEMCPY3D.nWidthInBytes(this.address(), value);
            return this;
        }

        public Buffer Height(@NativeType(value="size_t") long value) {
            CUDA_MEMCPY3D.nHeight(this.address(), value);
            return this;
        }

        public Buffer Depth(@NativeType(value="size_t") long value) {
            CUDA_MEMCPY3D.nDepth(this.address(), value);
            return this;
        }
    }
}

