// CheckStyle: start generated
package com.oracle.truffle.js.builtins.math;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.InlineSupport.InlineTarget;
import com.oracle.truffle.api.dsl.InlineSupport.StateField;
import com.oracle.truffle.api.dsl.InlineSupport.UnsafeAccessedField;
import com.oracle.truffle.api.dsl.Introspection.Provider;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.runtime.JSContext;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;

/**
 * Debug Info: <pre>
 *   Specialization {@link AsinhNode#asinhDouble}
 *     Activation probability: 0.65000
 *     With/without class size: 14/0 bytes
 *   Specialization {@link AsinhNode#asinhGeneric}
 *     Activation probability: 0.35000
 *     With/without class size: 9/0 bytes
 * </pre>
 */
@GeneratedBy(AsinhNode.class)
@SuppressWarnings("javadoc")
public final class AsinhNodeGen extends AsinhNode implements Introspection.Provider {

    private static final StateField STATE_0_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
    /**
     * Source Info: <pre>
     *   Specialization: {@link AsinhNode#asinhDouble}
     *   Parameter: {@link InlinedConditionProfile} isNegative
     *   Inline method: {@link InlinedConditionProfile#inline}</pre>
     */
    private static final InlinedConditionProfile INLINED_IS_NEGATIVE = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, STATE_0_UPDATER.subUpdater(5, 2)));

    @Child private JavaScriptNode arguments0_;
    /**
     * State Info: <pre>
     *   0: SpecializationActive {@link AsinhNode#asinhDouble}
     *   1: SpecializationActive {@link AsinhNode#asinhGeneric}
     *   2-4: ImplicitCast[type=double, index=0]
     *   5-6: InlinedCache
     *        Specialization: {@link AsinhNode#asinhDouble}
     *        Parameter: {@link InlinedConditionProfile} isNegative
     *        Inline method: {@link InlinedConditionProfile#inline}
     * </pre>
     */
    @CompilationFinal @UnsafeAccessedField private int state_0_;

    private AsinhNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
        super(context, builtin);
        this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
    }

    @Override
    public JavaScriptNode[] getArguments() {
        return new JavaScriptNode[] {this.arguments0_};
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b10) == 0 /* only-active SpecializationActive[AsinhNode.asinhDouble(double, InlinedConditionProfile)] */ && ((state_0 & 0b11) != 0  /* is-not SpecializationActive[AsinhNode.asinhDouble(double, InlinedConditionProfile)] && SpecializationActive[AsinhNode.asinhGeneric(Object, InlinedConditionProfile)] */)) {
            return execute_double0(state_0, frameValue);
        } else {
            return execute_generic1(state_0, frameValue);
        }
    }

    private Object execute_double0(int state_0__, VirtualFrame frameValue) {
        int state_0 = state_0__;
        int arguments0Value_int = 0;
        double arguments0Value_;
        try {
            if ((state_0 & 0b11000) == 0 /* only-active ImplicitCast[type=double, index=0] */ && ((state_0 & 0b11) != 0  /* is-not SpecializationActive[AsinhNode.asinhDouble(double, InlinedConditionProfile)] && SpecializationActive[AsinhNode.asinhGeneric(Object, InlinedConditionProfile)] */)) {
                arguments0Value_ = this.arguments0_.executeDouble(frameValue);
            } else if ((state_0 & 0b10100) == 0 /* only-active ImplicitCast[type=double, index=0] */ && ((state_0 & 0b11) != 0  /* is-not SpecializationActive[AsinhNode.asinhDouble(double, InlinedConditionProfile)] && SpecializationActive[AsinhNode.asinhGeneric(Object, InlinedConditionProfile)] */)) {
                arguments0Value_int = this.arguments0_.executeInt(frameValue);
                arguments0Value_ = JSTypes.intToDouble(arguments0Value_int);
            } else {
                Object arguments0Value__ = this.arguments0_.execute(frameValue);
                arguments0Value_ = JSTypesGen.expectImplicitDouble((state_0 & 0b11100) >>> 2 /* get-int ImplicitCast[type=double, index=0] */, arguments0Value__);
            }
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(ex.getResult());
        }
        assert (state_0 & 0b1) != 0 /* is SpecializationActive[AsinhNode.asinhDouble(double, InlinedConditionProfile)] */;
        return asinhDouble(arguments0Value_, INLINED_IS_NEGATIVE);
    }

    private Object execute_generic1(int state_0__, VirtualFrame frameValue) {
        int state_0 = state_0__;
        Object arguments0Value_ = this.arguments0_.execute(frameValue);
        if ((state_0 & 0b11) != 0 /* is SpecializationActive[AsinhNode.asinhDouble(double, InlinedConditionProfile)] || SpecializationActive[AsinhNode.asinhGeneric(Object, InlinedConditionProfile)] */) {
            if ((state_0 & 0b1) != 0 /* is SpecializationActive[AsinhNode.asinhDouble(double, InlinedConditionProfile)] */ && JSTypesGen.isImplicitDouble((state_0 & 0b11100) >>> 2 /* get-int ImplicitCast[type=double, index=0] */, arguments0Value_)) {
                double arguments0Value__ = JSTypesGen.asImplicitDouble((state_0 & 0b11100) >>> 2 /* get-int ImplicitCast[type=double, index=0] */, arguments0Value_);
                return asinhDouble(arguments0Value__, INLINED_IS_NEGATIVE);
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[AsinhNode.asinhGeneric(Object, InlinedConditionProfile)] */) {
                return asinhGeneric(arguments0Value_, INLINED_IS_NEGATIVE);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(arguments0Value_);
    }

    @Override
    public double executeDouble(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b10) == 0 /* only-active SpecializationActive[AsinhNode.asinhDouble(double, InlinedConditionProfile)] */ && ((state_0 & 0b11) != 0  /* is-not SpecializationActive[AsinhNode.asinhDouble(double, InlinedConditionProfile)] && SpecializationActive[AsinhNode.asinhGeneric(Object, InlinedConditionProfile)] */)) {
            return executeDouble_double2(state_0, frameValue);
        } else {
            return executeDouble_generic3(state_0, frameValue);
        }
    }

    private double executeDouble_double2(int state_0__, VirtualFrame frameValue) {
        int state_0 = state_0__;
        int arguments0Value_int = 0;
        double arguments0Value_;
        try {
            if ((state_0 & 0b11000) == 0 /* only-active ImplicitCast[type=double, index=0] */ && ((state_0 & 0b11) != 0  /* is-not SpecializationActive[AsinhNode.asinhDouble(double, InlinedConditionProfile)] && SpecializationActive[AsinhNode.asinhGeneric(Object, InlinedConditionProfile)] */)) {
                arguments0Value_ = this.arguments0_.executeDouble(frameValue);
            } else if ((state_0 & 0b10100) == 0 /* only-active ImplicitCast[type=double, index=0] */ && ((state_0 & 0b11) != 0  /* is-not SpecializationActive[AsinhNode.asinhDouble(double, InlinedConditionProfile)] && SpecializationActive[AsinhNode.asinhGeneric(Object, InlinedConditionProfile)] */)) {
                arguments0Value_int = this.arguments0_.executeInt(frameValue);
                arguments0Value_ = JSTypes.intToDouble(arguments0Value_int);
            } else {
                Object arguments0Value__ = this.arguments0_.execute(frameValue);
                arguments0Value_ = JSTypesGen.expectImplicitDouble((state_0 & 0b11100) >>> 2 /* get-int ImplicitCast[type=double, index=0] */, arguments0Value__);
            }
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(ex.getResult());
        }
        assert (state_0 & 0b1) != 0 /* is SpecializationActive[AsinhNode.asinhDouble(double, InlinedConditionProfile)] */;
        return asinhDouble(arguments0Value_, INLINED_IS_NEGATIVE);
    }

    private double executeDouble_generic3(int state_0__, VirtualFrame frameValue) {
        int state_0 = state_0__;
        Object arguments0Value_ = this.arguments0_.execute(frameValue);
        if ((state_0 & 0b11) != 0 /* is SpecializationActive[AsinhNode.asinhDouble(double, InlinedConditionProfile)] || SpecializationActive[AsinhNode.asinhGeneric(Object, InlinedConditionProfile)] */) {
            if ((state_0 & 0b1) != 0 /* is SpecializationActive[AsinhNode.asinhDouble(double, InlinedConditionProfile)] */ && JSTypesGen.isImplicitDouble((state_0 & 0b11100) >>> 2 /* get-int ImplicitCast[type=double, index=0] */, arguments0Value_)) {
                double arguments0Value__ = JSTypesGen.asImplicitDouble((state_0 & 0b11100) >>> 2 /* get-int ImplicitCast[type=double, index=0] */, arguments0Value_);
                return asinhDouble(arguments0Value__, INLINED_IS_NEGATIVE);
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[AsinhNode.asinhGeneric(Object, InlinedConditionProfile)] */) {
                return asinhGeneric(arguments0Value_, INLINED_IS_NEGATIVE);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(arguments0Value_);
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        executeDouble(frameValue);
        return;
    }

    private double executeAndSpecialize(Object arguments0Value) {
        int state_0 = this.state_0_;
        {
            int doubleCast0;
            if ((doubleCast0 = JSTypesGen.specializeImplicitDouble(arguments0Value)) != 0) {
                double arguments0Value_ = JSTypesGen.asImplicitDouble(doubleCast0, arguments0Value);
                state_0 = (state_0 | (doubleCast0 << 2) /* set-int ImplicitCast[type=double, index=0] */);
                state_0 = state_0 | 0b1 /* add SpecializationActive[AsinhNode.asinhDouble(double, InlinedConditionProfile)] */;
                this.state_0_ = state_0;
                return asinhDouble(arguments0Value_, INLINED_IS_NEGATIVE);
            }
        }
        state_0 = state_0 | 0b10 /* add SpecializationActive[AsinhNode.asinhGeneric(Object, InlinedConditionProfile)] */;
        this.state_0_ = state_0;
        return asinhGeneric(arguments0Value, INLINED_IS_NEGATIVE);
    }

    @Override
    public NodeCost getCost() {
        int state_0 = this.state_0_;
        if ((state_0 & 0b11) == 0) {
            return NodeCost.UNINITIALIZED;
        } else {
            if (((state_0 & 0b11) & ((state_0 & 0b11) - 1)) == 0 /* is-single  */) {
                return NodeCost.MONOMORPHIC;
            }
        }
        return NodeCost.POLYMORPHIC;
    }

    @Override
    public Introspection getIntrospectionData() {
        Object[] data = new Object[3];
        Object[] s;
        data[0] = 0;
        int state_0 = this.state_0_;
        s = new Object[3];
        s[0] = "asinhDouble";
        if ((state_0 & 0b1) != 0 /* is SpecializationActive[AsinhNode.asinhDouble(double, InlinedConditionProfile)] */) {
            s[1] = (byte)0b01 /* active */;
            ArrayList<Object> cached = new ArrayList<>();
            cached.add(Arrays.<Object>asList(INLINED_IS_NEGATIVE));
            s[2] = cached;
        }
        if (s[1] == null) {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[1] = s;
        s = new Object[3];
        s[0] = "asinhGeneric";
        if ((state_0 & 0b10) != 0 /* is SpecializationActive[AsinhNode.asinhGeneric(Object, InlinedConditionProfile)] */) {
            s[1] = (byte)0b01 /* active */;
            ArrayList<Object> cached = new ArrayList<>();
            cached.add(Arrays.<Object>asList(INLINED_IS_NEGATIVE));
            s[2] = cached;
        }
        if (s[1] == null) {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[2] = s;
        return Provider.create(data);
    }

    @NeverDefault
    public static AsinhNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
        return new AsinhNodeGen(context, builtin, arguments);
    }

}
