/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tvm.rpc;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import org.apache.tvm.rpc.NativeServerLoop;
import org.apache.tvm.rpc.ServerProcessor;
import org.apache.tvm.rpc.SocketChannel;
import org.apache.tvm.rpc.Utils;

public class StandaloneServerProcessor
implements ServerProcessor {
    private final ServerSocket server;

    public StandaloneServerProcessor(int serverPort) throws IOException {
        this.server = new ServerSocket(serverPort);
    }

    @Override
    public void terminate() {
        try {
            this.server.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void run() {
        try {
            Socket socket = this.server.accept();
            InputStream in = socket.getInputStream();
            OutputStream out = socket.getOutputStream();
            int magic = Utils.wrapBytes(Utils.recvAll(in, 4)).getInt();
            if (magic != 1045105) {
                Utils.closeQuietly(socket);
                return;
            }
            int keyLen = Utils.wrapBytes(Utils.recvAll(in, 4)).getInt();
            String key = Utils.decodeToStr(Utils.recvAll(in, keyLen));
            if (!key.startsWith("client:")) {
                out.write(Utils.toBytes(1045107));
            } else {
                out.write(Utils.toBytes(1045105));
                String serverKey = "server:java";
                out.write(Utils.toBytes(serverKey.length()));
                out.write(Utils.toBytes(serverKey));
            }
            SocketChannel sockChannel = new SocketChannel(socket);
            System.err.println("Connection from " + socket.getRemoteSocketAddress().toString());
            new NativeServerLoop(sockChannel.getFsend(), sockChannel.getFrecv()).run();
            System.err.println("Finish serving " + socket.getRemoteSocketAddress().toString());
            Utils.closeQuietly(socket);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

