/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tvm.rpc;

import java.io.IOException;
import java.net.Socket;
import org.apache.tvm.Function;
import org.apache.tvm.TVMValue;
import org.apache.tvm.TVMValueBytes;
import org.apache.tvm.rpc.Utils;

public class SocketChannel {
    private final Socket socket;
    private Function fsend = Function.convertFunc(new Function.Callback(){

        @Override
        public Object invoke(TVMValue ... args) {
            byte[] data = args[0].asBytes();
            try {
                SocketChannel.this.socket.getOutputStream().write(data);
            }
            catch (IOException e) {
                e.printStackTrace();
                return -1;
            }
            return data.length;
        }
    });
    private Function frecv = Function.convertFunc(new Function.Callback(){

        @Override
        public Object invoke(TVMValue ... args) {
            long size = args[0].asLong();
            try {
                return new TVMValueBytes(Utils.recvAll(SocketChannel.this.socket.getInputStream(), (int)size));
            }
            catch (IOException e) {
                e.printStackTrace();
                return -1;
            }
        }
    });

    SocketChannel(Socket sock) {
        this.socket = sock;
    }

    public Function getFsend() {
        return this.fsend;
    }

    public Function getFrecv() {
        return this.frecv;
    }
}

