/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tvm.rpc;

import java.io.File;
import java.io.IOException;
import org.apache.tvm.Function;
import org.apache.tvm.Module;
import org.apache.tvm.TVMValue;
import org.apache.tvm.rpc.RPC;

public class NativeServerLoop
implements Runnable {
    private final Function fsend;
    private final Function frecv;

    public NativeServerLoop(Function fsend, Function frecv) {
        this.fsend = fsend;
        this.frecv = frecv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        File tempDir = null;
        try {
            tempDir = NativeServerLoop.serverEnv();
            System.err.println("starting server loop...");
            RPC.getApi("ServerLoop").pushArg(this.fsend).pushArg(this.frecv).invoke();
            System.err.println("done server loop...");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (tempDir != null) {
                String[] entries;
                for (String s : entries = tempDir.list()) {
                    File currentFile = new File(tempDir.getPath(), s);
                    if (currentFile.delete()) continue;
                    System.err.println("[WARN] Couldn't delete temporary file " + currentFile.getAbsolutePath());
                }
                if (!tempDir.delete()) {
                    System.err.println("[WARN] Couldn't delete temporary directory " + tempDir.getAbsolutePath());
                }
            }
        }
    }

    private static File serverEnv() throws IOException {
        final File tempDir = File.createTempFile("tvm4j_rpc_", "");
        if (!tempDir.delete() || !tempDir.mkdir()) {
            throw new IOException("Couldn't create directory " + tempDir.getAbsolutePath());
        }
        Function.register("tvm.rpc.server.workpath", new Function.Callback(){

            @Override
            public Object invoke(TVMValue ... args) {
                return tempDir + File.separator + args[0].asString();
            }
        }, true);
        Function.register("tvm.rpc.server.load_module", new Function.Callback(){

            @Override
            public Object invoke(TVMValue ... args) {
                String filename = args[0].asString();
                String path = tempDir + File.separator + filename;
                System.err.println("Load module from " + path);
                return Module.load(path);
            }
        }, true);
        return tempDir;
    }
}

