/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tvm.rpc;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.apache.tvm.rpc.NativeServerLoop;
import org.apache.tvm.rpc.ServerProcessor;
import org.apache.tvm.rpc.SocketChannel;
import org.apache.tvm.rpc.Utils;

public class ConnectProxyServerProcessor
implements ServerProcessor {
    private final String host;
    private final int port;
    private final String key;
    private volatile Socket currSocket = new Socket();
    private Runnable callback;

    public ConnectProxyServerProcessor(String host, int port, String key) {
        this.host = host;
        this.port = port;
        this.key = "server:" + key;
    }

    public void setStartTimeCallback(Runnable callback) {
        this.callback = callback;
    }

    @Override
    public void terminate() {
        Utils.closeQuietly(this.currSocket);
    }

    @Override
    public void run() {
        try {
            InetSocketAddress address = new InetSocketAddress(this.host, this.port);
            this.currSocket.connect(address, 6000);
            InputStream in = this.currSocket.getInputStream();
            OutputStream out = this.currSocket.getOutputStream();
            out.write(Utils.toBytes(1045105));
            out.write(Utils.toBytes(this.key.length()));
            out.write(Utils.toBytes(this.key));
            int magic = Utils.wrapBytes(Utils.recvAll(in, 4)).getInt();
            if (magic == 1045106) {
                throw new RuntimeException(String.format("key: %s has already been used in proxy", this.key));
            }
            if (magic == 1045107) {
                System.err.println("RPCProxy do not have matching client key " + this.key);
            } else if (magic != 1045105) {
                throw new RuntimeException(address + " is not RPC Proxy");
            }
            int keylen = Utils.wrapBytes(Utils.recvAll(in, 4)).getInt();
            String remoteKey = Utils.decodeToStr(Utils.recvAll(in, keylen));
            System.err.println("RPCProxy connected to " + address);
            if (this.callback != null) {
                this.callback.run();
            }
            SocketChannel sockChannel = new SocketChannel(this.currSocket);
            new NativeServerLoop(sockChannel.getFsend(), sockChannel.getFrecv()).run();
            System.err.println("Finish serving " + address);
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        finally {
            this.terminate();
        }
    }
}

