/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tvm;

import org.apache.tvm.ArgTypeCode;
import org.apache.tvm.Base;
import org.apache.tvm.TVMValue;

public class NDArrayBase
extends TVMValue {
    protected final long handle;
    protected final boolean isView;
    private boolean isReleased = false;

    NDArrayBase(long handle, boolean isView) {
        super(ArgTypeCode.ARRAY_HANDLE);
        this.handle = handle;
        this.isView = isView;
    }

    NDArrayBase(long handle) {
        this(handle, true);
    }

    @Override
    public NDArrayBase asNDArray() {
        return this;
    }

    @Override
    long asHandle() {
        return this.handle;
    }

    public NDArrayBase copyTo(NDArrayBase target) {
        Base.checkCall(Base._LIB.tvmArrayCopyFromTo(this.handle, target.handle));
        return target;
    }

    @Override
    public void release() {
        if (!this.isReleased && !this.isView) {
            Base.checkCall(Base._LIB.tvmArrayFree(this.handle));
            this.isReleased = true;
        }
    }

    protected void finalize() throws Throwable {
        this.release();
        super.finalize();
    }
}

