/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tvm;

import java.io.File;
import java.io.IOException;
import org.apache.tvm.LibInfo;
import org.apache.tvm.NativeLibraryLoader;
import org.apache.tvm.TVMValue;

final class Base {
    public static final LibInfo _LIB = new LibInfo();

    private static void tryLoadLibraryOS(String libname) throws UnsatisfiedLinkError {
        try {
            System.err.println(String.format("Try loading %s from native path.", libname));
            System.loadLibrary(libname);
        }
        catch (UnsatisfiedLinkError e) {
            String os = System.getProperty("os.name");
            if (os.startsWith("Linux")) {
                Base.tryLoadLibraryXPU(libname, "linux-x86_64");
            }
            if (os.startsWith("Mac")) {
                Base.tryLoadLibraryXPU(libname, "osx-x86_64");
            }
            throw new UnsatisfiedLinkError("Windows not supported currently");
        }
    }

    private static void tryLoadLibraryXPU(String libname, String arch) throws UnsatisfiedLinkError {
        System.err.println(String.format("Try loading %s-%s from native path.", libname, arch));
        System.loadLibrary(String.format("%s-%s", libname, arch));
    }

    public static void checkCall(int ret) throws TVMError {
        if (ret != 0) {
            throw new TVMError(_LIB.tvmGetLastError());
        }
    }

    private Base() {
    }

    static {
        boolean loadNativeRuntimeLib = true;
        try {
            try {
                Base.tryLoadLibraryOS("tvm4j");
            }
            catch (UnsatisfiedLinkError e) {
                System.err.println("[WARN] TVM native library not found in path. Copying native library from the archive. Consider installing the library somewhere in the path (for Windows: PATH, for Linux: LD_LIBRARY_PATH), or specifying by Java cmd option -Djava.library.path=[lib path].");
                NativeLibraryLoader.loadLibrary("tvm4j");
            }
        }
        catch (Throwable e) {
            System.err.println("[WARN] Couldn't find native library tvm4j.");
            e.printStackTrace();
            System.err.println("Try to load tvm4j (runtime packed version) ...");
            try {
                System.loadLibrary("tvm4j_runtime_packed");
                loadNativeRuntimeLib = false;
            }
            catch (UnsatisfiedLinkError errFull) {
                System.err.println("[ERROR] Couldn't find native library tvm4j_runtime_packed.");
                throw new RuntimeException(errFull);
            }
        }
        System.err.println("libtvm4j loads successfully.");
        if (loadNativeRuntimeLib) {
            String tvmLibFilename = System.getProperty("libtvm.so.path");
            if (tvmLibFilename == null || !new File(tvmLibFilename).isFile() || _LIB.nativeLibInit(tvmLibFilename) != 0) {
                try {
                    String runtimeLibname;
                    String os = System.getProperty("os.name");
                    if (os.startsWith("Linux")) {
                        runtimeLibname = "libtvm_runtime.so";
                    } else if (os.startsWith("Mac")) {
                        runtimeLibname = "libtvm_runtime.dylib";
                    } else {
                        throw new UnsatisfiedLinkError(os + " not supported currently");
                    }
                    NativeLibraryLoader.extractResourceFileToTempDir(runtimeLibname, new NativeLibraryLoader.Action(){

                        @Override
                        public void invoke(File target) {
                            System.err.println("Loading tvm runtime from " + target.getPath());
                            Base.checkCall(_LIB.nativeLibInit(target.getPath()));
                        }
                    });
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        } else {
            _LIB.nativeLibInit(null);
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                _LIB.shutdown();
            }
        });
    }

    static class TVMError
    extends RuntimeException {
        public TVMError(String err) {
            super(err);
        }
    }

    public static class RefTVMValue {
        public final TVMValue value;

        public RefTVMValue(TVMValue value) {
            this.value = value;
        }

        public RefTVMValue() {
            this(null);
        }
    }

    public static class RefLong {
        public final long value;

        public RefLong(long value) {
            this.value = value;
        }

        public RefLong() {
            this(0L);
        }
    }
}

