// Targeted by JavaCPP version 1.5.6: DO NOT EDIT THIS FILE

package org.bytedeco.tensorflow;

import org.bytedeco.tensorflow.Allocator;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.tensorflow.global.tensorflow.*;


// WorkerSession encapsulates all of the state relating to a given session.
@Namespace("tensorflow") @NoOffset @Properties(inherit = org.bytedeco.tensorflow.presets.tensorflow.class)
public class WorkerSession extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public WorkerSession(Pointer p) { super(p); }

  // The name of the session.
  @MemberGetter public native @StdString BytePointer session_name();

  // The name of the worker. E.g., /job:mnist/replica:0/task:1.
  @MemberGetter public native @StdString BytePointer worker_name();

  // Object from which WorkerInterface instances can be obtained.
  @MemberGetter public native @MoveUniquePtr WorkerCacheInterface worker_cache();

  // Collection of local devices. These devices are typically
  // RenamedDevices in all except the SessionMgr.legacy_session_ and
  // sessions created with `isolate_session_state == false`. In the
  // those cases, this method returns a pointer to a borrowed
  // DeviceMgr (typically the `worker_env.device_mgr`).
  public native DeviceMgr device_mgr();

  public native DeviceMgr remote_device_mgr();

  // graph_mgr keeps track of the registered graphs of this session.
  //
  // Note: graph_mgr must be deleted before rendezvous_mgr!
  // Note: graph_mgr must be deleted before device_mgr!
  @MemberGetter public native @MoveUniquePtr GraphMgr graph_mgr();

  public native @MoveUniquePtr ClusterFunctionLibraryRuntime cluster_flr(); public native WorkerSession cluster_flr(ClusterFunctionLibraryRuntime setter);

  public WorkerSession(@StdString BytePointer session_name, @StdString BytePointer worker_name,
                  @MoveUniquePtr WorkerCacheInterface worker_cache,
                  @MoveUniquePtr DeviceMgr device_mgr,
                  @MoveUniquePtr GraphMgr graph_mgr,
                  @MoveUniquePtr DeviceMgr remote_device_mgr) { super((Pointer)null); allocate(session_name, worker_name, worker_cache, device_mgr, graph_mgr, remote_device_mgr); }
  private native void allocate(@StdString BytePointer session_name, @StdString BytePointer worker_name,
                  @MoveUniquePtr WorkerCacheInterface worker_cache,
                  @MoveUniquePtr DeviceMgr device_mgr,
                  @MoveUniquePtr GraphMgr graph_mgr,
                  @MoveUniquePtr DeviceMgr remote_device_mgr);
  public WorkerSession(@StdString String session_name, @StdString String worker_name,
                  @MoveUniquePtr WorkerCacheInterface worker_cache,
                  @MoveUniquePtr DeviceMgr device_mgr,
                  @MoveUniquePtr GraphMgr graph_mgr,
                  @MoveUniquePtr DeviceMgr remote_device_mgr) { super((Pointer)null); allocate(session_name, worker_name, worker_cache, device_mgr, graph_mgr, remote_device_mgr); }
  private native void allocate(@StdString String session_name, @StdString String worker_name,
                  @MoveUniquePtr WorkerCacheInterface worker_cache,
                  @MoveUniquePtr DeviceMgr device_mgr,
                  @MoveUniquePtr GraphMgr graph_mgr,
                  @MoveUniquePtr DeviceMgr remote_device_mgr);

  public static native @SharedPtr WorkerSession CreateWithBorrowedDeviceMgr(
        @StdString BytePointer session_name, @StdString BytePointer worker_name,
        @MoveUniquePtr WorkerCacheInterface worker_cache,
        DeviceMgr borrowed_device_mgr, @MoveUniquePtr GraphMgr graph_mgr,
        @MoveUniquePtr DeviceMgr remote_device_mgr);
  public static native @SharedPtr WorkerSession CreateWithBorrowedDeviceMgr(
        @StdString String session_name, @StdString String worker_name,
        @MoveUniquePtr WorkerCacheInterface worker_cache,
        DeviceMgr borrowed_device_mgr, @MoveUniquePtr GraphMgr graph_mgr,
        @MoveUniquePtr DeviceMgr remote_device_mgr);
}
