// Targeted by JavaCPP version 1.5.6: DO NOT EDIT THIS FILE

package org.bytedeco.tensorflow;

import org.bytedeco.tensorflow.Allocator;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.tensorflow.global.tensorflow.*;


/** Converts each string in the input Tensor to the specified numeric type.
 * 
 *  (Note that int32 overflow results in an error while float overflow
 *  results in a rounded value.)
 * 
 *  Arguments:
 *  * scope: A Scope object
 * 
 *  Optional attributes (see {@code Attrs}):
 *  * out_type: The numeric type to interpret each string in {@code string_tensor} as.
 * 
 *  Returns:
 *  * {@code Output}: A Tensor of the same shape as the input {@code string_tensor}. */
@Namespace("tensorflow::ops") @NoOffset @Properties(inherit = org.bytedeco.tensorflow.presets.tensorflow.class)
public class StringToNumber extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public StringToNumber(Pointer p) { super(p); }

  /** Optional attribute setters for StringToNumber */
  public static class Attrs extends Pointer {
      static { Loader.load(); }
      /** Default native constructor. */
      public Attrs() { super((Pointer)null); allocate(); }
      /** Native array allocator. Access with {@link Pointer#position(long)}. */
      public Attrs(long size) { super((Pointer)null); allocateArray(size); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public Attrs(Pointer p) { super(p); }
      private native void allocate();
      private native void allocateArray(long size);
      @Override public Attrs position(long position) {
          return (Attrs)super.position(position);
      }
      @Override public Attrs getPointer(long i) {
          return new Attrs((Pointer)this).offsetAddress(i);
      }
  
    /** The numeric type to interpret each string in {@code string_tensor} as.
     * 
     *  Defaults to DT_FLOAT */
    public native @ByVal Attrs OutType(@Cast("tensorflow::DataType") int x);

    public native @Cast("tensorflow::DataType") int out_type_(); public native Attrs out_type_(int setter);
  }
  public StringToNumber(@Const @ByRef Scope scope, @ByVal Input string_tensor) { super((Pointer)null); allocate(scope, string_tensor); }
  private native void allocate(@Const @ByRef Scope scope, @ByVal Input string_tensor);
  public StringToNumber(@Const @ByRef Scope scope, @ByVal Input string_tensor, @Const @ByRef Attrs attrs) { super((Pointer)null); allocate(scope, string_tensor, attrs); }
  private native void allocate(@Const @ByRef Scope scope, @ByVal Input string_tensor, @Const @ByRef Attrs attrs);
  public native @ByVal @Name("operator tensorflow::Output") Output asOutput();
  public native @ByVal @Name("operator tensorflow::Input") Input asInput();
  public native Node node();

  public static native @ByVal Attrs OutType(@Cast("tensorflow::DataType") int x);

  public native @ByRef Operation operation(); public native StringToNumber operation(Operation setter);
  public native @ByRef Output output(); public native StringToNumber output(Output setter);
}
