// Targeted by JavaCPP version 1.5.6: DO NOT EDIT THIS FILE

package org.bytedeco.tensorflow;

import org.bytedeco.tensorflow.Allocator;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.tensorflow.global.tensorflow.*;


/** The gradient operator for the SparseAdd op.
 * 
 *  The SparseAdd op calculates A + B, where A, B, and the sum are all represented
 *  as {@code SparseTensor} objects.  This op takes in the upstream gradient w.r.t.
 *  non-empty values of the sum, and outputs the gradients w.r.t. the non-empty
 *  values of A and B.
 * 
 *  Arguments:
 *  * scope: A Scope object
 *  * backprop_val_grad: 1-D with shape {@code [nnz(sum)]}.  The gradient with respect to
 *  the non-empty values of the sum.
 *  * a_indices: 2-D.  The {@code indices} of the {@code SparseTensor} A, size {@code [nnz(A), ndims]}.
 *  * b_indices: 2-D.  The {@code indices} of the {@code SparseTensor} B, size {@code [nnz(B), ndims]}.
 *  * sum_indices: 2-D.  The {@code indices} of the sum {@code SparseTensor}, size
 *  {@code [nnz(sum), ndims]}.
 * 
 *  Returns:
 *  * {@code Output} a_val_grad: 1-D with shape {@code [nnz(A)]}. The gradient with respect to the
 *  non-empty values of A.
 *  * {@code Output} b_val_grad: 1-D with shape {@code [nnz(B)]}. The gradient with respect to the
 *  non-empty values of B. */
@Namespace("tensorflow::ops") @NoOffset @Properties(inherit = org.bytedeco.tensorflow.presets.tensorflow.class)
public class SparseAddGrad extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public SparseAddGrad(Pointer p) { super(p); }

  public SparseAddGrad(@Const @ByRef Scope scope, @ByVal Input backprop_val_grad, @ByVal Input a_indices,
                @ByVal Input b_indices, @ByVal Input sum_indices) { super((Pointer)null); allocate(scope, backprop_val_grad, a_indices, b_indices, sum_indices); }
  private native void allocate(@Const @ByRef Scope scope, @ByVal Input backprop_val_grad, @ByVal Input a_indices,
                @ByVal Input b_indices, @ByVal Input sum_indices);

  public native @ByRef Operation operation(); public native SparseAddGrad operation(Operation setter);
  public native @ByRef Output a_val_grad(); public native SparseAddGrad a_val_grad(Output setter);
  public native @ByRef Output b_val_grad(); public native SparseAddGrad b_val_grad(Output setter);
}
