// Targeted by JavaCPP version 1.5.6: DO NOT EDIT THIS FILE

package org.bytedeco.tensorflow;

import org.bytedeco.tensorflow.Allocator;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.tensorflow.global.tensorflow.*;


/** Applies a sparse gradient to a given accumulator.
 * 
 *  Does not add if local_step is smaller than the accumulator's
 *  global_step.
 * 
 *  Arguments:
 *  * scope: A Scope object
 *  * handle: The handle to a accumulator.
 *  * local_step: The local_step value at which the sparse gradient was computed.
 *  * gradient_indices: Indices of the sparse gradient to be accumulated. Must be a
 *  vector.
 *  * gradient_values: Values are the non-zero slices of the gradient, and must have
 *  the same first dimension as indices, i.e., the nnz represented by indices and
 *  values must be consistent.
 *  * gradient_shape: Shape of the sparse gradient to be accumulated.
 *  * has_known_shape: Boolean indicating whether gradient_shape is unknown, in which
 *  case the input is ignored during validation.
 * 
 *  Returns:
 *  * the created {@code Operation} */
@Namespace("tensorflow::ops") @NoOffset @Properties(inherit = org.bytedeco.tensorflow.presets.tensorflow.class)
public class SparseAccumulatorApplyGradient extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public SparseAccumulatorApplyGradient(Pointer p) { super(p); }

  public SparseAccumulatorApplyGradient(@Const @ByRef Scope scope,
                                 @ByVal Input handle, @ByVal Input local_step, @ByVal Input gradient_indices, @ByVal Input gradient_values, @ByVal Input gradient_shape, @Cast("bool") boolean has_known_shape) { super((Pointer)null); allocate(scope, handle, local_step, gradient_indices, gradient_values, gradient_shape, has_known_shape); }
  private native void allocate(@Const @ByRef Scope scope,
                                 @ByVal Input handle, @ByVal Input local_step, @ByVal Input gradient_indices, @ByVal Input gradient_values, @ByVal Input gradient_shape, @Cast("bool") boolean has_known_shape);
  public native @ByVal @Name("operator tensorflow::Operation") Operation asOperation();

  public native @ByRef Operation operation(); public native SparseAccumulatorApplyGradient operation(Operation setter);
}
