// Targeted by JavaCPP version 1.5.6: DO NOT EDIT THIS FILE

package org.bytedeco.tensorflow;

import org.bytedeco.tensorflow.Allocator;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.tensorflow.global.tensorflow.*;


/** Return a slice from 'input'.
 * 
 *  The output tensor is a tensor with dimensions described by 'size'
 *  whose values are extracted from 'input' starting at the offsets in
 *  'begin'.
 * 
 *  *Requirements*:
 *    0 <= begin[i] <= begin[i] + size[i] <= Di  for i in [0, n)
 * 
 *  Arguments:
 *  * scope: A Scope object
 *  * begin: begin[i] specifies the offset into the 'i'th dimension of
 *  'input' to slice from.
 *  * size: size[i] specifies the number of elements of the 'i'th dimension
 *  of 'input' to slice. If size[i] is -1, all remaining elements in dimension
 *  i are included in the slice (i.e. this is equivalent to setting
 *  size[i] = input.dim_size(i) - begin[i]).
 * 
 *  Returns:
 *  * {@code Output}: The output tensor. */
@Namespace("tensorflow::ops") @NoOffset @Properties(inherit = org.bytedeco.tensorflow.presets.tensorflow.class)
public class Slice extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public Slice(Pointer p) { super(p); }

  public Slice(@Const @ByRef Scope scope, @ByVal Input input,
        @ByVal Input begin, @ByVal Input size) { super((Pointer)null); allocate(scope, input, begin, size); }
  private native void allocate(@Const @ByRef Scope scope, @ByVal Input input,
        @ByVal Input begin, @ByVal Input size);
  public native @ByVal @Name("operator tensorflow::Output") Output asOutput();
  public native @ByVal @Name("operator tensorflow::Input") Input asInput();
  public native Node node();

  public native @ByRef Operation operation(); public native Slice operation(Operation setter);
  public native @ByRef Output output(); public native Slice output(Output setter);
}
