// Targeted by JavaCPP version 1.5.6: DO NOT EDIT THIS FILE

package org.bytedeco.tensorflow;

import org.bytedeco.tensorflow.Allocator;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.tensorflow.global.tensorflow.*;


/** Applies sparse addition to {@code input} using individual values or slices
 * 
 *  from {@code updates} according to indices {@code indices}.  The updates are non-aliasing:
 *  {@code input} is only modified in-place if no other operations will use it.
 *  Otherwise, a copy of {@code input} is made.  This operation has a gradient with
 *  respect to both {@code input} and {@code updates}.
 * 
 *  {@code input} is a {@code Tensor} with rank {@code P} and {@code indices} is a {@code Tensor} of rank {@code Q}.
 * 
 *  {@code indices} must be integer tensor, containing indices into {@code input}.
 *  It must be shape \([d_0, ..., d_{Q-2}, K]\) where {@code 0 < K <= P}.
 * 
 *  The innermost dimension of {@code indices} (with length {@code K}) corresponds to
 *  indices into elements (if {@code K = P}) or {@code (P-K)}-dimensional slices
 *  (if {@code K < P}) along the {@code K}th dimension of {@code input}.
 * 
 *  {@code updates} is {@code Tensor} of rank {@code Q-1+P-K} with shape:
 * 
 *  $$[d_0, ..., d_{Q-2}, input.shape[K], ..., input.shape[P-1]].$$
 * 
 *  For example, say we want to add 4 scattered elements to a rank-1 tensor to 8
 *  elements. In Python, that addition would look like this:
 * 
 *      input = tf.constant([1, 2, 3, 4, 5, 6, 7, 8])
 *      indices = tf.constant([[4], [3], [1], [7]])
 *      updates = tf.constant([9, 10, 11, 12])
 *      output = tf.scatter_nd_non_aliasing_add(input, indices, updates)
 *      with tf.Session() as sess:
 *        print(sess.run(output))
 * 
 *  The resulting value {@code output} would look like this:
 * 
 *      [1, 13, 3, 14, 14, 6, 7, 20]
 * 
 *  See {@code tf.scatter_nd} for more details about how to make updates to slices.
 * 
 *  Arguments:
 *  * scope: A Scope object
 *  * input: A Tensor.
 *  * indices: A Tensor. Must be one of the following types: {@code int32}, {@code int64}.
 *  A tensor of indices into {@code input}.
 *  * updates: A Tensor. Must have the same type as ref. A tensor of updated values
 *  to add to {@code input}.
 * 
 *  Returns:
 *  * {@code Output}: A {@code Tensor} with the same shape as {@code input}, containing values of {@code input}
 *  updated with {@code updates}. */
@Namespace("tensorflow::ops") @NoOffset @Properties(inherit = org.bytedeco.tensorflow.presets.tensorflow.class)
public class ScatterNdNonAliasingAdd extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public ScatterNdNonAliasingAdd(Pointer p) { super(p); }

  public ScatterNdNonAliasingAdd(@Const @ByRef Scope scope, @ByVal Input input, @ByVal Input indices, @ByVal Input updates) { super((Pointer)null); allocate(scope, input, indices, updates); }
  private native void allocate(@Const @ByRef Scope scope, @ByVal Input input, @ByVal Input indices, @ByVal Input updates);
  public native @ByVal @Name("operator tensorflow::Output") Output asOutput();
  public native @ByVal @Name("operator tensorflow::Input") Input asInput();
  public native Node node();

  public native @ByRef Operation operation(); public native ScatterNdNonAliasingAdd operation(Operation setter);
  public native @ByRef Output output(); public native ScatterNdNonAliasingAdd output(Output setter);
}
