// Targeted by JavaCPP version 1.5.6: DO NOT EDIT THIS FILE

package org.bytedeco.tensorflow;

import org.bytedeco.tensorflow.Allocator;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.tensorflow.global.tensorflow.*;


/** Produces the average pool of the input tensor for quantized types.
 * 
 *  Arguments:
 *  * scope: A Scope object
 *  * input: 4-D with shape {@code [batch, height, width, channels]}.
 *  * min_input: The float value that the lowest quantized input value represents.
 *  * max_input: The float value that the highest quantized input value represents.
 *  * ksize: The size of the window for each dimension of the input tensor.
 *  The length must be 4 to match the number of dimensions of the input.
 *  * strides: The stride of the sliding window for each dimension of the input
 *  tensor.  The length must be 4 to match the number of dimensions of the input.
 *  * padding: The type of padding algorithm to use.
 * 
 *  Returns:
 *  * {@code Output} output
 *  * {@code Output} min_output: The float value that the lowest quantized output value represents.
 *  * {@code Output} max_output: The float value that the highest quantized output value represents. */
@Namespace("tensorflow::ops") @NoOffset @Properties(inherit = org.bytedeco.tensorflow.presets.tensorflow.class)
public class QuantizedAvgPool extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public QuantizedAvgPool(Pointer p) { super(p); }

  public QuantizedAvgPool(@Const @ByRef Scope scope, @ByVal Input input,
                   @ByVal Input min_input, @ByVal Input max_input,
                   @ArraySlice IntPointer ksize, @ArraySlice IntPointer strides, @StringPiece BytePointer padding) { super((Pointer)null); allocate(scope, input, min_input, max_input, ksize, strides, padding); }
  private native void allocate(@Const @ByRef Scope scope, @ByVal Input input,
                   @ByVal Input min_input, @ByVal Input max_input,
                   @ArraySlice IntPointer ksize, @ArraySlice IntPointer strides, @StringPiece BytePointer padding);
  public QuantizedAvgPool(@Const @ByRef Scope scope, @ByVal Input input,
                   @ByVal Input min_input, @ByVal Input max_input,
                   @ArraySlice IntBuffer ksize, @ArraySlice IntBuffer strides, @StringPiece String padding) { super((Pointer)null); allocate(scope, input, min_input, max_input, ksize, strides, padding); }
  private native void allocate(@Const @ByRef Scope scope, @ByVal Input input,
                   @ByVal Input min_input, @ByVal Input max_input,
                   @ArraySlice IntBuffer ksize, @ArraySlice IntBuffer strides, @StringPiece String padding);
  public QuantizedAvgPool(@Const @ByRef Scope scope, @ByVal Input input,
                   @ByVal Input min_input, @ByVal Input max_input,
                   @ArraySlice int[] ksize, @ArraySlice int[] strides, @StringPiece BytePointer padding) { super((Pointer)null); allocate(scope, input, min_input, max_input, ksize, strides, padding); }
  private native void allocate(@Const @ByRef Scope scope, @ByVal Input input,
                   @ByVal Input min_input, @ByVal Input max_input,
                   @ArraySlice int[] ksize, @ArraySlice int[] strides, @StringPiece BytePointer padding);
  public QuantizedAvgPool(@Const @ByRef Scope scope, @ByVal Input input,
                   @ByVal Input min_input, @ByVal Input max_input,
                   @ArraySlice IntPointer ksize, @ArraySlice IntPointer strides, @StringPiece String padding) { super((Pointer)null); allocate(scope, input, min_input, max_input, ksize, strides, padding); }
  private native void allocate(@Const @ByRef Scope scope, @ByVal Input input,
                   @ByVal Input min_input, @ByVal Input max_input,
                   @ArraySlice IntPointer ksize, @ArraySlice IntPointer strides, @StringPiece String padding);
  public QuantizedAvgPool(@Const @ByRef Scope scope, @ByVal Input input,
                   @ByVal Input min_input, @ByVal Input max_input,
                   @ArraySlice IntBuffer ksize, @ArraySlice IntBuffer strides, @StringPiece BytePointer padding) { super((Pointer)null); allocate(scope, input, min_input, max_input, ksize, strides, padding); }
  private native void allocate(@Const @ByRef Scope scope, @ByVal Input input,
                   @ByVal Input min_input, @ByVal Input max_input,
                   @ArraySlice IntBuffer ksize, @ArraySlice IntBuffer strides, @StringPiece BytePointer padding);
  public QuantizedAvgPool(@Const @ByRef Scope scope, @ByVal Input input,
                   @ByVal Input min_input, @ByVal Input max_input,
                   @ArraySlice int[] ksize, @ArraySlice int[] strides, @StringPiece String padding) { super((Pointer)null); allocate(scope, input, min_input, max_input, ksize, strides, padding); }
  private native void allocate(@Const @ByRef Scope scope, @ByVal Input input,
                   @ByVal Input min_input, @ByVal Input max_input,
                   @ArraySlice int[] ksize, @ArraySlice int[] strides, @StringPiece String padding);

  public native @ByRef Operation operation(); public native QuantizedAvgPool operation(Operation setter);
  public native @ByRef Output output(); public native QuantizedAvgPool output(Output setter);
  public native @ByRef Output min_output(); public native QuantizedAvgPool min_output(Output setter);
  public native @ByRef Output max_output(); public native QuantizedAvgPool max_output(Output setter);
}
