// Targeted by JavaCPP version 1.5.6: DO NOT EDIT THIS FILE

package org.bytedeco.tensorflow;

import org.bytedeco.tensorflow.Allocator;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.tensorflow.global.tensorflow.*;


/** Quantizes then dequantizes a tensor.
 * 
 *  This op simulates the precision loss from the quantized forward pass by:
 * 
 *  1. Quantizing the tensor to fixed point numbers, which should match the target
 *     quantization method when it is used in inference.
 *  2. Dequantizing it back to floating point numbers for the following ops, most
 *     likely matmul.
 * 
 *  There are different ways to quantize. This version uses only scaling, so 0.0
 *  maps to 0.
 * 
 *  From the specified 'num_bits' in the quantized output type, it determines
 *  minimum and maximum representable quantized values.
 * 
 *  e.g.
 * 
 *  *   [-128, 127] for signed, num_bits = 8, or
 *  *   [0, 255] for unsigned, num_bits = 8.
 * 
 *  If range_given == False, the initial input_min, input_max will be determined
 *  automatically as the minimum and maximum values in the input tensor, otherwise
 *  the specified values of input_min, input_max are used.
 * 
 *  Note: If the input_min, input_max are specified, they do not need to equal the
 *  actual minimum and maximum values in the tensor. e.g. in some cases it may be
 *  beneficial to specify these values such that the low probability extremes of the
 *  input distribution are clipped.
 * 
 *  This op determines the maximum scale_factor that would map the initial
 *  [input_min, input_max] range to a range that lies within the representable
 *  quantized range.
 * 
 *  It determines the scale from one of input_min and input_max, then updates the
 *  other one to maximize the respresentable range.
 * 
 *  e.g.
 * 
 *  *   if the output is signed, num_bits = 8, [input_min, input_max] = [-10.0,
 *      5.0]: it would use a scale_factor of -128 / -10.0 = 12.8 In this case, it
 *      would update input_max to be 127 / 12.8 = 9.921875
 *  *   if the output is signed, num_bits = 8, [input_min, input_max] = [-10.0,
 *      10.0]: it would use a scale_factor of 127 / 10.0 = 12.7 In this case, it
 *      would update input_min to be 128.0 / 12.7 = -10.07874
 *  *   if the output is unsigned, input_min is forced to be 0, and only the
 *      specified input_max is used.
 * 
 *  After determining the scale_factor and updating the input range, it applies the
 *  following to each value in the 'input' tensor.
 * 
 *  output = round(clamp(value, input_min, input_max) * scale_factor) / scale_factor.
 * 
 *  The above round function rounds the value based on the given round_mode.
 * 
 * 
 *  Arguments:
 *  * scope: A Scope object
 *  * input: Tensor to quantize and then dequantize.
 *  * input_min: If {@code range_given == True}, this specifies the minimum input value that needs to
 *  be represented, otherwise it is determined from the min value of the {@code input}
 *  tensor.
 *  * input_max: If {@code range_given == True}, this specifies the maximum input value that needs to
 *  be represented, otherwise it is determined from the max value of the {@code input}
 *  tensor.
 * 
 *  Optional attributes (see {@code Attrs}):
 *  * signed_input: Whether the quantization is signed or unsigned. (actually this parameter should
 *  have been called <b>{@code signed_output}</b>)
 *  * num_bits: The bitwidth of the quantization.
 *  * range_given: Whether the range is given or should be determined from the {@code input} tensor.
 *  * round_mode: The 'round_mode' attribute controls which rounding tie-breaking algorithm is
 *  used when rounding float values to their quantized equivalents. The following
 *  rounding modes are currently supported:
 * 
 *  *   HALF_TO_EVEN: this is the default round_mode.
 *  *   HALF_UP: round towards positive. In this mode 7.5 rounds up to 8 and -7.5
 *      rounds up to -7.
 * 
 *  * narrow_range: If True, then the absolute value of the quantized minimum value is the same as
 *  the quantized maximum value, instead of 1 greater.
 *  i.e. for 8 bit quantization, the minimum value is -127 instead of -128.
 * 
 *  Returns:
 *  * {@code Output}: The output tensor. */
@Namespace("tensorflow::ops") @NoOffset @Properties(inherit = org.bytedeco.tensorflow.presets.tensorflow.class)
public class QuantizeAndDequantizeV2 extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public QuantizeAndDequantizeV2(Pointer p) { super(p); }

  /** Optional attribute setters for QuantizeAndDequantizeV2 */
  public static class Attrs extends Pointer {
      static { Loader.load(); }
      /** Default native constructor. */
      public Attrs() { super((Pointer)null); allocate(); }
      /** Native array allocator. Access with {@link Pointer#position(long)}. */
      public Attrs(long size) { super((Pointer)null); allocateArray(size); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public Attrs(Pointer p) { super(p); }
      private native void allocate();
      private native void allocateArray(long size);
      @Override public Attrs position(long position) {
          return (Attrs)super.position(position);
      }
      @Override public Attrs getPointer(long i) {
          return new Attrs((Pointer)this).offsetAddress(i);
      }
  
    /** Whether the quantization is signed or unsigned. (actually this parameter should
     *  have been called <b>{@code signed_output}</b>)
     * 
     *  Defaults to true */
    
    ///
    public native @ByVal Attrs SignedInput(@Cast("bool") boolean x);

    /** The bitwidth of the quantization.
     * 
     *  Defaults to 8 */
    
    ///
    public native @ByVal Attrs NumBits(@Cast("tensorflow::int64") long x);

    /** Whether the range is given or should be determined from the {@code input} tensor.
     * 
     *  Defaults to false */
    
    ///
    ///
    ///
    public native @ByVal Attrs RangeGiven(@Cast("bool") boolean x);

    /** The 'round_mode' attribute controls which rounding tie-breaking algorithm is
     *  used when rounding float values to their quantized equivalents. The following
     *  rounding modes are currently supported:
     * 
     *  *   HALF_TO_EVEN: this is the default round_mode.
     *  *   HALF_UP: round towards positive. In this mode 7.5 rounds up to 8 and -7.5
     *      rounds up to -7.
     * 
     * 
     *  Defaults to "HALF_TO_EVEN" */
    
    ///
    public native @ByVal Attrs RoundMode(@StringPiece BytePointer x);
    public native @ByVal Attrs RoundMode(@StringPiece String x);

    /** If True, then the absolute value of the quantized minimum value is the same as
     *  the quantized maximum value, instead of 1 greater.
     *  i.e. for 8 bit quantization, the minimum value is -127 instead of -128.
     * 
     *  Defaults to false */
    public native @ByVal Attrs NarrowRange(@Cast("bool") boolean x);

    public native @Cast("bool") boolean signed_input_(); public native Attrs signed_input_(boolean setter);
    public native @Cast("tensorflow::int64") long num_bits_(); public native Attrs num_bits_(long setter);
    public native @Cast("bool") boolean range_given_(); public native Attrs range_given_(boolean setter);
    public native @StringPiece BytePointer round_mode_(); public native Attrs round_mode_(BytePointer setter);
    public native @Cast("bool") boolean narrow_range_(); public native Attrs narrow_range_(boolean setter);
  }
  public QuantizeAndDequantizeV2(@Const @ByRef Scope scope, @ByVal Input input, @ByVal Input input_min,
                          @ByVal Input input_max) { super((Pointer)null); allocate(scope, input, input_min, input_max); }
  private native void allocate(@Const @ByRef Scope scope, @ByVal Input input, @ByVal Input input_min,
                          @ByVal Input input_max);
  public QuantizeAndDequantizeV2(@Const @ByRef Scope scope, @ByVal Input input, @ByVal Input input_min,
                          @ByVal Input input_max, @Const @ByRef Attrs attrs) { super((Pointer)null); allocate(scope, input, input_min, input_max, attrs); }
  private native void allocate(@Const @ByRef Scope scope, @ByVal Input input, @ByVal Input input_min,
                          @ByVal Input input_max, @Const @ByRef Attrs attrs);
  public native @ByVal @Name("operator tensorflow::Output") Output asOutput();
  public native @ByVal @Name("operator tensorflow::Input") Input asInput();
  public native Node node();

  public static native @ByVal Attrs SignedInput(@Cast("bool") boolean x);
  public static native @ByVal Attrs NumBits(@Cast("tensorflow::int64") long x);
  public static native @ByVal Attrs RangeGiven(@Cast("bool") boolean x);
  public static native @ByVal Attrs RoundMode(@StringPiece BytePointer x);
  public static native @ByVal Attrs RoundMode(@StringPiece String x);
  public static native @ByVal Attrs NarrowRange(@Cast("bool") boolean x);

  public native @ByRef Operation operation(); public native QuantizeAndDequantizeV2 operation(Operation setter);
  public native @ByRef Output output(); public native QuantizeAndDequantizeV2 output(Output setter);
}
