// Targeted by JavaCPP version 1.5.6: DO NOT EDIT THIS FILE

package org.bytedeco.tensorflow;

import org.bytedeco.tensorflow.Allocator;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.tensorflow.global.tensorflow.*;


/** A placeholder op for a value that will be fed into the computation.
 * 
 *  N.B. This operation will fail with an error if it is executed. It is
 *  intended as a way to represent a value that will always be fed, and to
 *  provide attrs that enable the fed value to be checked at runtime.
 * 
 *  Arguments:
 *  * scope: A Scope object
 *  * dtype: The type of elements in the tensor.
 * 
 *  Optional attributes (see {@code Attrs}):
 *  * shape: (Optional) The shape of the tensor. If the shape has 0 dimensions, the
 *  shape is unconstrained.
 * 
 *  Returns:
 *  * {@code Output}: A placeholder tensor that must be replaced using the feed mechanism. */
@Namespace("tensorflow::ops") @NoOffset @Properties(inherit = org.bytedeco.tensorflow.presets.tensorflow.class)
public class Placeholder extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public Placeholder(Pointer p) { super(p); }

  /** Optional attribute setters for Placeholder */
  public static class Attrs extends Pointer {
      static { Loader.load(); }
      /** Default native constructor. */
      public Attrs() { super((Pointer)null); allocate(); }
      /** Native array allocator. Access with {@link Pointer#position(long)}. */
      public Attrs(long size) { super((Pointer)null); allocateArray(size); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public Attrs(Pointer p) { super(p); }
      private native void allocate();
      private native void allocateArray(long size);
      @Override public Attrs position(long position) {
          return (Attrs)super.position(position);
      }
      @Override public Attrs getPointer(long i) {
          return new Attrs((Pointer)this).offsetAddress(i);
      }
  
    /** (Optional) The shape of the tensor. If the shape has 0 dimensions, the
     *  shape is unconstrained.
     * 
     *  Defaults to <unknown> */
    public native @ByVal Attrs Shape(@ByVal PartialTensorShape x);

    public native @ByRef PartialTensorShape shape_(); public native Attrs shape_(PartialTensorShape setter);
  }
  public Placeholder(@Const @ByRef Scope scope, @Cast("tensorflow::DataType") int dtype) { super((Pointer)null); allocate(scope, dtype); }
  private native void allocate(@Const @ByRef Scope scope, @Cast("tensorflow::DataType") int dtype);
  public Placeholder(@Const @ByRef Scope scope, @Cast("tensorflow::DataType") int dtype, @Const @ByRef Attrs attrs) { super((Pointer)null); allocate(scope, dtype, attrs); }
  private native void allocate(@Const @ByRef Scope scope, @Cast("tensorflow::DataType") int dtype, @Const @ByRef Attrs attrs);
  public native @ByVal @Name("operator tensorflow::Output") Output asOutput();
  public native @ByVal @Name("operator tensorflow::Input") Input asInput();
  public native Node node();

  public static native @ByVal Attrs Shape(@ByVal PartialTensorShape x);

  public native @ByRef Operation operation(); public native Placeholder operation(Operation setter);
  public native @ByRef Output output(); public native Placeholder output(Output setter);
}
