// Targeted by JavaCPP version 1.5.6: DO NOT EDIT THIS FILE

package org.bytedeco.tensorflow;

import org.bytedeco.tensorflow.Allocator;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.tensorflow.global.tensorflow.*;


/** Computes the inverse of one or more square invertible matrices or their
 * 
 *  adjoints (conjugate transposes).
 * 
 *  The input is a tensor of shape {@code [..., M, M]} whose inner-most 2 dimensions
 *  form square matrices. The output is a tensor of the same shape as the input
 *  containing the inverse for all input submatrices {@code [..., :, :]}.
 * 
 *  The op uses LU decomposition with partial pivoting to compute the inverses.
 * 
 *  If a matrix is not invertible there is no guarantee what the op does. It
 *  may detect the condition and raise an exception or it may simply return a
 *  garbage result.
 * 
 *  Arguments:
 *  * scope: A Scope object
 *  * input: Shape is {@code [..., M, M]}.
 * 
 *  Returns:
 *  * {@code Output}: Shape is {@code [..., M, M]}.
 * 
 *  \compatibility(numpy)
 *  Equivalent to np.linalg.inv
 *  \end_compatibility */
@Namespace("tensorflow::ops") @NoOffset @Properties(inherit = org.bytedeco.tensorflow.presets.tensorflow.class)
public class MatrixInverse extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public MatrixInverse(Pointer p) { super(p); }

  /** Optional attribute setters for MatrixInverse */
  public static class Attrs extends Pointer {
      static { Loader.load(); }
      /** Default native constructor. */
      public Attrs() { super((Pointer)null); allocate(); }
      /** Native array allocator. Access with {@link Pointer#position(long)}. */
      public Attrs(long size) { super((Pointer)null); allocateArray(size); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public Attrs(Pointer p) { super(p); }
      private native void allocate();
      private native void allocateArray(long size);
      @Override public Attrs position(long position) {
          return (Attrs)super.position(position);
      }
      @Override public Attrs getPointer(long i) {
          return new Attrs((Pointer)this).offsetAddress(i);
      }
  
    /** Defaults to false */
    public native @ByVal Attrs Adjoint(@Cast("bool") boolean x);

    public native @Cast("bool") boolean adjoint_(); public native Attrs adjoint_(boolean setter);
  }
  public MatrixInverse(@Const @ByRef Scope scope, @ByVal Input input) { super((Pointer)null); allocate(scope, input); }
  private native void allocate(@Const @ByRef Scope scope, @ByVal Input input);
  public MatrixInverse(@Const @ByRef Scope scope, @ByVal Input input,
                @Const @ByRef Attrs attrs) { super((Pointer)null); allocate(scope, input, attrs); }
  private native void allocate(@Const @ByRef Scope scope, @ByVal Input input,
                @Const @ByRef Attrs attrs);
  public native @ByVal @Name("operator tensorflow::Output") Output asOutput();
  public native @ByVal @Name("operator tensorflow::Input") Input asInput();
  public native Node node();

  public static native @ByVal Attrs Adjoint(@Cast("bool") boolean x);

  public native @ByRef Operation operation(); public native MatrixInverse operation(Operation setter);
  public native @ByRef Output output(); public native MatrixInverse output(Output setter);
}
