// Targeted by JavaCPP version 1.5.6: DO NOT EDIT THIS FILE

package org.bytedeco.tensorflow;

import org.bytedeco.tensorflow.Allocator;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.tensorflow.global.tensorflow.*;


/** A generic interface for accessing a file system.  Implementations
 *  of custom filesystem adapters must implement this interface,
 *  RandomAccessFile, WritableFile, and ReadOnlyMemoryRegion classes. */
@Namespace("tensorflow") @Properties(inherit = org.bytedeco.tensorflow.presets.tensorflow.class)
public class FileSystem extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public FileSystem(Pointer p) { super(p); }

  /** \brief Creates a brand new random access read-only file with the
   *  specified name.
   * 
   *  On success, stores a pointer to the new file in
   *  *result and returns OK.  On failure stores NULL in *result and
   *  returns non-OK.  If the file does not exist, returns a non-OK
   *  status.
   * 
   *  The returned file may be concurrently accessed by multiple threads.
   * 
   *  The ownership of the returned RandomAccessFile is passed to the caller
   *  and the object should be deleted when is not used. */
  
  ///
  ///
  ///
  public native @ByVal Status NewRandomAccessFile(
        @StdString BytePointer fname, @UniquePtr RandomAccessFile result);
  public native @ByVal Status NewRandomAccessFile(
        @StdString String fname, @UniquePtr RandomAccessFile result);

  /** \brief Creates an object that writes to a new file with the specified
   *  name.
   * 
   *  Deletes any existing file with the same name and creates a
   *  new file.  On success, stores a pointer to the new file in
   *  *result and returns OK.  On failure stores NULL in *result and
   *  returns non-OK.
   * 
   *  The returned file will only be accessed by one thread at a time.
   * 
   *  The ownership of the returned WritableFile is passed to the caller
   *  and the object should be deleted when is not used. */
  
  ///
  ///
  ///
  public native @ByVal Status NewWritableFile(@StdString BytePointer fname,
                                   @UniquePtr WritableFile result);
  public native @ByVal Status NewWritableFile(@StdString String fname,
                                   @UniquePtr WritableFile result);

  /** \brief Creates an object that either appends to an existing file, or
   *  writes to a new file (if the file does not exist to begin with).
   * 
   *  On success, stores a pointer to the new file in *result and
   *  returns OK.  On failure stores NULL in *result and returns
   *  non-OK.
   * 
   *  The returned file will only be accessed by one thread at a time.
   * 
   *  The ownership of the returned WritableFile is passed to the caller
   *  and the object should be deleted when is not used. */
  
  ///
  ///
  ///
  public native @ByVal Status NewAppendableFile(@StdString BytePointer fname,
                                     @UniquePtr WritableFile result);
  public native @ByVal Status NewAppendableFile(@StdString String fname,
                                     @UniquePtr WritableFile result);

  /** \brief Creates a readonly region of memory with the file context.
   * 
   *  On success, it returns a pointer to read-only memory region
   *  from the content of file fname. The ownership of the region is passed to
   *  the caller. On failure stores nullptr in *result and returns non-OK.
   * 
   *  The returned memory region can be accessed from many threads in parallel.
   * 
   *  The ownership of the returned ReadOnlyMemoryRegion is passed to the caller
   *  and the object should be deleted when is not used. */
  public native @ByVal Status NewReadOnlyMemoryRegionFromFile(
        @StdString BytePointer fname, @UniquePtr ReadOnlyMemoryRegion result);
  public native @ByVal Status NewReadOnlyMemoryRegionFromFile(
        @StdString String fname, @UniquePtr ReadOnlyMemoryRegion result);

  /** Returns OK if the named path exists and NOT_FOUND otherwise. */
  public native @ByVal Status FileExists(@StdString BytePointer fname);
  public native @ByVal Status FileExists(@StdString String fname);

  /** Returns true if all the listed files exist, false otherwise.
   *  if status is not null, populate the vector with a detailed status
   *  for each file. */
  
  ///
  public native @Cast("bool") boolean FilesExist(@Const @ByRef StringVector files,
                            @StdVector Status status);

  /** \brief Returns the immediate children in the given directory.
   * 
   *  The returned paths are relative to 'dir'. */
  
  ///
  ///
  ///
  public native @ByVal Status GetChildren(@StdString BytePointer dir,
                               StringVector result);
  public native @ByVal Status GetChildren(@StdString String dir,
                               StringVector result);

  /** \brief Given a pattern, stores in *results the set of paths that matches
   *  that pattern. *results is cleared.
   * 
   *  pattern must match all of a name, not just a substring.
   * 
   *  pattern: { term }
   *  term:
   *    '*': matches any sequence of non-'/' characters
   *    '?': matches a single non-'/' character
   *    '[' [ '^' ] { match-list } ']':
   *         matches any single character (not) on the list
   *    c: matches character c (c != '*', '?', '\', '[')
   *    '\' c: matches character c
   *  character-range:
   *    c: matches character c (c != '\', '-', ']')
   *    '\' c: matches character c
   *    lo '-' hi: matches character c for lo <= c <= hi
   * 
   *  Typical return codes:
   *   * OK - no errors
   *   * UNIMPLEMENTED - Some underlying functions (like GetChildren) are not
   *                     implemented */
  public native @ByVal Status GetMatchingPaths(@StdString BytePointer pattern,
                                    StringVector results);
  public native @ByVal Status GetMatchingPaths(@StdString String pattern,
                                    StringVector results);

  /** \brief Obtains statistics for the given path. */
  public native @ByVal Status Stat(@StdString BytePointer fname, FileStatistics stat);
  public native @ByVal Status Stat(@StdString String fname, FileStatistics stat);

  /** \brief Deletes the named file. */
  public native @ByVal Status DeleteFile(@StdString BytePointer fname);
  public native @ByVal Status DeleteFile(@StdString String fname);

  /** \brief Creates the specified directory.
   *  Typical return codes:
   *   * OK - successfully created the directory.
   *   * ALREADY_EXISTS - directory with name dirname already exists.
   *   * PERMISSION_DENIED - dirname is not writable. */
  public native @ByVal Status CreateDir(@StdString BytePointer dirname);
  public native @ByVal Status CreateDir(@StdString String dirname);

  /** \brief Creates the specified directory and all the necessary
   *  subdirectories.
   *  Typical return codes:
   *   * OK - successfully created the directory and sub directories, even if
   *          they were already created.
   *   * PERMISSION_DENIED - dirname or some subdirectory is not writable. */
  public native @ByVal Status RecursivelyCreateDir(@StdString BytePointer dirname);
  public native @ByVal Status RecursivelyCreateDir(@StdString String dirname);

  /** \brief Deletes the specified directory. */
  
  ///
  ///
  ///
  ///
  ///
  public native @ByVal Status DeleteDir(@StdString BytePointer dirname);
  public native @ByVal Status DeleteDir(@StdString String dirname);

  /** \brief Deletes the specified directory and all subdirectories and files
   *  underneath it. This is accomplished by traversing the directory tree
   *  rooted at dirname and deleting entries as they are encountered.
   * 
   *  If dirname itself is not readable or does not exist, *undeleted_dir_count
   *  is set to 1, *undeleted_file_count is set to 0 and an appropriate status
   *  (e.g. NOT_FOUND) is returned.
   * 
   *  If dirname and all its descendants were successfully deleted, TF_OK is
   *  returned and both error counters are set to zero.
   * 
   *  Otherwise, while traversing the tree, undeleted_file_count and
   *  undeleted_dir_count are updated if an entry of the corresponding type
   *  could not be deleted. The returned error status represents the reason that
   *  any one of these entries could not be deleted.
   * 
   *  REQUIRES: undeleted_files, undeleted_dirs to be not null.
   * 
   *  Typical return codes:
   *   * OK - dirname exists and we were able to delete everything underneath.
   *   * NOT_FOUND - dirname doesn't exist
   *   * PERMISSION_DENIED - dirname or some descendant is not writable
   *   * UNIMPLEMENTED - Some underlying functions (like Delete) are not
   *                     implemented */
  public native @ByVal Status DeleteRecursively(@StdString BytePointer dirname,
                                     @Cast("tensorflow::int64*") LongPointer undeleted_files,
                                     @Cast("tensorflow::int64*") LongPointer undeleted_dirs);
  public native @ByVal Status DeleteRecursively(@StdString String dirname,
                                     @Cast("tensorflow::int64*") LongBuffer undeleted_files,
                                     @Cast("tensorflow::int64*") LongBuffer undeleted_dirs);
  public native @ByVal Status DeleteRecursively(@StdString BytePointer dirname,
                                     @Cast("tensorflow::int64*") long[] undeleted_files,
                                     @Cast("tensorflow::int64*") long... undeleted_dirs);
  public native @ByVal Status DeleteRecursively(@StdString String dirname,
                                     @Cast("tensorflow::int64*") LongPointer undeleted_files,
                                     @Cast("tensorflow::int64*") LongPointer undeleted_dirs);
  public native @ByVal Status DeleteRecursively(@StdString BytePointer dirname,
                                     @Cast("tensorflow::int64*") LongBuffer undeleted_files,
                                     @Cast("tensorflow::int64*") LongBuffer undeleted_dirs);
  public native @ByVal Status DeleteRecursively(@StdString String dirname,
                                     @Cast("tensorflow::int64*") long[] undeleted_files,
                                     @Cast("tensorflow::int64*") long... undeleted_dirs);

  /** \brief Stores the size of {@code fname} in {@code *file_size}. */
  public native @ByVal Status GetFileSize(@StdString BytePointer fname, @Cast("tensorflow::uint64*") LongPointer file_size);
  public native @ByVal Status GetFileSize(@StdString String fname, @Cast("tensorflow::uint64*") LongBuffer file_size);
  public native @ByVal Status GetFileSize(@StdString BytePointer fname, @Cast("tensorflow::uint64*") long... file_size);
  public native @ByVal Status GetFileSize(@StdString String fname, @Cast("tensorflow::uint64*") LongPointer file_size);
  public native @ByVal Status GetFileSize(@StdString BytePointer fname, @Cast("tensorflow::uint64*") LongBuffer file_size);
  public native @ByVal Status GetFileSize(@StdString String fname, @Cast("tensorflow::uint64*") long... file_size);

  /** \brief Overwrites the target if it exists. */
  public native @ByVal Status RenameFile(@StdString BytePointer src, @StdString BytePointer target);
  public native @ByVal Status RenameFile(@StdString String src, @StdString String target);

  /** \brief Copy the src to target. */
  
  ///
  public native @ByVal Status CopyFile(@StdString BytePointer src, @StdString BytePointer target);
  public native @ByVal Status CopyFile(@StdString String src, @StdString String target);

  /** \brief Translate an URI to a filename for the FileSystem implementation.
   * 
   *  The implementation in this class cleans up the path, removing
   *  duplicate /'s, resolving .. and . (more details in
   *  tensorflow::lib::io::CleanPath). */
  
  ///
  public native @StdString BytePointer TranslateName(@StdString BytePointer name);
  public native @StdString String TranslateName(@StdString String name);

  /** \brief Returns whether the given path is a directory or not.
   * 
   *  Typical return codes (not guaranteed exhaustive):
   *   * OK - The path exists and is a directory.
   *   * FAILED_PRECONDITION - The path exists and is not a directory.
   *   * NOT_FOUND - The path entry does not exist.
   *   * PERMISSION_DENIED - Insufficient permissions.
   *   * UNIMPLEMENTED - The file factory doesn't support directories. */
  public native @ByVal Status IsDirectory(@StdString BytePointer fname);
  public native @ByVal Status IsDirectory(@StdString String fname);

  /** \brief Flushes any cached filesystem objects from memory. */
  public native void FlushCaches();
}
