// Targeted by JavaCPP version 1.5.6: DO NOT EDIT THIS FILE

package org.bytedeco.tensorflow;

import org.bytedeco.tensorflow.Allocator;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.tensorflow.global.tensorflow.*;


/** Computes {@code exp(x) - 1} element-wise.
 * 
 *    i.e. {@code exp(x) - 1} or {@code e^(x) - 1}, where {@code x} is the input tensor.
 *    {@code e} denotes Euler's number and is approximately equal to 2.718281.
 * 
 *    <pre>{@code python
 *    x = tf.constant(2.0)
 *    tf.math.expm1(x) ==> 6.389056
 * 
 *    x = tf.constant([2.0, 8.0])
 *    tf.math.expm1(x) ==> array([6.389056, 2979.958], dtype=float32)
 * 
 *    x = tf.constant(1 + 1j)
 *    tf.math.expm1(x) ==> (0.46869393991588515+2.2873552871788423j)
 *    }</pre>
 * 
 *  Arguments:
 *  * scope: A Scope object
 * 
 *  Returns:
 *  * {@code Output}: The y tensor. */
@Namespace("tensorflow::ops") @NoOffset @Properties(inherit = org.bytedeco.tensorflow.presets.tensorflow.class)
public class Expm1 extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public Expm1(Pointer p) { super(p); }

  public Expm1(@Const @ByRef Scope scope, @ByVal Input x) { super((Pointer)null); allocate(scope, x); }
  private native void allocate(@Const @ByRef Scope scope, @ByVal Input x);
  public native @ByVal @Name("operator tensorflow::Output") Output asOutput();
  public native @ByVal @Name("operator tensorflow::Input") Input asInput();
  public native Node node();

  public native @ByRef Operation operation(); public native Expm1 operation(Operation setter);
  public native @ByRef Output y(); public native Expm1 y(Output setter);
}
