// Targeted by JavaCPP version 1.5.6: DO NOT EDIT THIS FILE

package org.bytedeco.tensorflow;

import org.bytedeco.tensorflow.Allocator;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.tensorflow.global.tensorflow.*;


/** Encode audio data using the WAV file format.
 * 
 *  This operation will generate a string suitable to be saved out to create a .wav
 *  audio file. It will be encoded in the 16-bit PCM format. It takes in float
 *  values in the range -1.0f to 1.0f, and any outside that value will be clamped to
 *  that range.
 * 
 *  {@code audio} is a 2-D float Tensor of shape {@code [length, channels]}.
 *  {@code sample_rate} is a scalar Tensor holding the rate to use (e.g. 44100).
 * 
 *  Arguments:
 *  * scope: A Scope object
 *  * audio: 2-D with shape {@code [length, channels]}.
 *  * sample_rate: Scalar containing the sample frequency.
 * 
 *  Returns:
 *  * {@code Output}: 0-D. WAV-encoded file contents. */
@Namespace("tensorflow::ops") @NoOffset @Properties(inherit = org.bytedeco.tensorflow.presets.tensorflow.class)
public class EncodeWav extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public EncodeWav(Pointer p) { super(p); }

  public EncodeWav(@Const @ByRef Scope scope, @ByVal Input audio,
            @ByVal Input sample_rate) { super((Pointer)null); allocate(scope, audio, sample_rate); }
  private native void allocate(@Const @ByRef Scope scope, @ByVal Input audio,
            @ByVal Input sample_rate);
  public native @ByVal @Name("operator tensorflow::Output") Output asOutput();
  public native @ByVal @Name("operator tensorflow::Input") Input asInput();
  public native Node node();

  public native @ByRef Operation operation(); public native EncodeWav operation(Operation setter);
  public native @ByRef Output contents(); public native EncodeWav contents(Output setter);
}
