// Targeted by JavaCPP version 1.5.6: DO NOT EDIT THIS FILE

package org.bytedeco.tensorflow;

import org.bytedeco.tensorflow.Allocator;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.tensorflow.global.tensorflow.*;


@Namespace("tensorflow") @NoOffset @Properties(inherit = org.bytedeco.tensorflow.presets.tensorflow.class)
public class Device extends DeviceBase {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public Device(Pointer p) { super(p); }

  // Callback type that takes a Status and returns void.

  // Full name of this device (see top comment).
  public native @StdString BytePointer name();

  // Parsed name of this device
  public native @Const @ByRef DeviceNameUtils.ParsedName parsed_name();

  // Describes what kind of device this is.  This is intended to be
  // human-readable and not computer-parsed, except that two devices
  // with the same device_type() are expected to perform similarly
  // (both from a computation and communication perspective).
  public native @StdString BytePointer device_type();

  // Returns an aggregation of device attributes.
  public native @Const @ByRef DeviceAttributes attributes();

  // Performs the actual compute function.
  //
  // Subclasses may override this function if they wish to perform
  // some initialization before each compute.
  public native void Compute(OpKernel op_kernel, OpKernelContext context);

  // Asynchronous kernel's compute.
  public native void ComputeAsync(AsyncOpKernel op_kernel, OpKernelContext context,
                              @ByVal @Cast("tensorflow::AsyncOpKernel::DoneCallback*") Fn done);

  // Takes ownership of the references in tensors. If necessary, a
  // device may override this method to keep a reference to the
  // accessed tensors until the async computation has completed.
  public native void ConsumeListOfAccessedTensors(
        DeviceContext context, @Cast("const tensorflow::TensorReferenceVector*") @ByRef TensorValueVector tensors);

  // Blocks until all operations queued on the device at the time of
  // the call have completed.  Returns any error pending on the device
  // at completion.
  public native @ByVal Status Sync();

  // Calls the given callback when all operations queued on the device at the
  // time of the call have completed. The callback is passed any error pending
  // on the device at completion.
  // TODO(b/112409994): Consolidate these two APIs, removing the synchronous
  // version.
  public native void Sync(@Cast("const tensorflow::Device::DoneCallback*") @ByRef Pointer done);

  // On session completion, the executor may call Device::Sync() depending on
  // flag settings. Override this to return false for devices that don't allow
  // such calls. Instead, these devices must use other mechanisms (such as
  // num_deferred_ops) to ensure the device has finished processing necessary
  // work at session completion. In addition, for these devices, RefreshStatus
  // must be called at session completion to retrieve execution result status.
  //
  // Devices that override this function must also implement RefreshStatus.
  public native @Cast("bool") boolean AllowsSyncOnCompletion();

  // This is used in conjunction with AllowsSyncOnCompletion to allow the
  // executor to get execution result status at session completion.
  //
  // For supported devices, this call returns the underlying device stream's
  // current status in a non-blocking way, without using blocking calls such as
  // Stream::BlockHostUntilDone or Device::Sync. When applicable, the device
  // status is also updated with the retrieved stream status.
  public native @ByVal Status RefreshStatus();

  // Optionally modify the device's GraphDef before execution.
  //
  // This method should be considered experimental and is supplied to enable
  // prototyping of TensorFlow device implementations that need to modify
  // the GraphDef before execution.
  //
  // 'graph' supplies the partition of the graph assigned to this
  // device.
  public native @ByVal Status MaybeRewriteGraph(@UniquePtr Graph arg0);

  // Fill in the context map for the graph. Default behavior is to do
  // nothing.
  //
  // The caller takes ownership over the DeviceContext objects given
  // by the device.
  public native @ByVal Status FillContextMap(@Const Graph graph,
                                  @Cast("tensorflow::DeviceContextMap*") DeviceContextVector device_context_map);

  // Returns the op segment of this device.  The caller can reuse op
  // kernels registered for the same session running on this device.
  public native OpSegment op_segment();

  // Returns the resource manager associated w/ this device.
  public native ResourceMgr resource_manager();

  // Summarizes the status of this Device, for debugging.
  public native @StdString BytePointer DebugString();

  // Assembles the parameter components into a complete DeviceAttributes value.
  public static native @ByVal DeviceAttributes BuildDeviceAttributes(
        @StdString BytePointer name, @ByVal DeviceType device, @Cast("tensorflow::Bytes") long memory_limit,
        @Const @ByRef DeviceLocality locality, @StdString BytePointer physical_device_desc);
  public static native @ByVal DeviceAttributes BuildDeviceAttributes(
        @StdString String name, @ByVal DeviceType device, @Cast("tensorflow::Bytes") long memory_limit,
        @Const @ByRef DeviceLocality locality, @StdString String physical_device_desc);

  public static native @ByVal DeviceAttributes BuildDeviceAttributes(
        @StdString BytePointer name, @ByVal DeviceType device, @Cast("tensorflow::Bytes") long memory_limit,
        @Const @ByRef DeviceLocality locality);
  public static native @ByVal DeviceAttributes BuildDeviceAttributes(
        @StdString String name, @ByVal DeviceType device, @Cast("tensorflow::Bytes") long memory_limit,
        @Const @ByRef DeviceLocality locality);

  // Clears the resource manager associated with this device.
  public native void ClearResourceMgr();

  public native @Cast("bool") boolean IsLocal();
}
