// Targeted by JavaCPP version 1.5.6: DO NOT EDIT THIS FILE

package org.bytedeco.tensorflow;

import org.bytedeco.tensorflow.Allocator;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.tensorflow.global.tensorflow.*;


/** Decode the first frame of a BMP-encoded image to a uint8 tensor.
 * 
 *  The attr {@code channels} indicates the desired number of color channels for the
 *  decoded image.
 * 
 *  Accepted values are:
 * 
 *  *   0: Use the number of channels in the BMP-encoded image.
 *  *   3: output an RGB image.
 *  *   4: output an RGBA image.
 * 
 *  Arguments:
 *  * scope: A Scope object
 *  * contents: 0-D.  The BMP-encoded image.
 * 
 *  Returns:
 *  * {@code Output}: 3-D with shape {@code [height, width, channels]}. RGB order */
@Namespace("tensorflow::ops") @NoOffset @Properties(inherit = org.bytedeco.tensorflow.presets.tensorflow.class)
public class DecodeBmp extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public DecodeBmp(Pointer p) { super(p); }

  /** Optional attribute setters for DecodeBmp */
  public static class Attrs extends Pointer {
      static { Loader.load(); }
      /** Default native constructor. */
      public Attrs() { super((Pointer)null); allocate(); }
      /** Native array allocator. Access with {@link Pointer#position(long)}. */
      public Attrs(long size) { super((Pointer)null); allocateArray(size); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public Attrs(Pointer p) { super(p); }
      private native void allocate();
      private native void allocateArray(long size);
      @Override public Attrs position(long position) {
          return (Attrs)super.position(position);
      }
      @Override public Attrs getPointer(long i) {
          return new Attrs((Pointer)this).offsetAddress(i);
      }
  
    /** Defaults to 0 */
    public native @ByVal Attrs Channels(@Cast("tensorflow::int64") long x);

    public native @Cast("tensorflow::int64") long channels_(); public native Attrs channels_(long setter);
  }
  public DecodeBmp(@Const @ByRef Scope scope, @ByVal Input contents) { super((Pointer)null); allocate(scope, contents); }
  private native void allocate(@Const @ByRef Scope scope, @ByVal Input contents);
  public DecodeBmp(@Const @ByRef Scope scope, @ByVal Input contents, @Const @ByRef Attrs attrs) { super((Pointer)null); allocate(scope, contents, attrs); }
  private native void allocate(@Const @ByRef Scope scope, @ByVal Input contents, @Const @ByRef Attrs attrs);
  public native @ByVal @Name("operator tensorflow::Output") Output asOutput();
  public native @ByVal @Name("operator tensorflow::Input") Input asInput();
  public native Node node();

  public static native @ByVal Attrs Channels(@Cast("tensorflow::int64") long x);

  public native @ByRef Operation operation(); public native DecodeBmp operation(Operation setter);
  public native @ByRef Output image(); public native DecodeBmp image(Output setter);
}
