// Targeted by JavaCPP version 1.5.6: DO NOT EDIT THIS FILE

package org.bytedeco.tensorflow;

import org.bytedeco.tensorflow.Allocator;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.tensorflow.global.tensorflow.*;


// Builds a string-string table of tensor names to BundleEntryProto (metadata).
//
// On construction, attempts to create a directory given by the dirname of
// "prefix", so "status()" must be checked before calling any member functions.
//
// All threads accessing the same BundleWriter must synchronize.
@Namespace("tensorflow") @NoOffset @Properties(inherit = org.bytedeco.tensorflow.presets.tensorflow.class)
public class BundleWriter extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public BundleWriter(Pointer p) { super(p); }

  @NoOffset public static class Options extends Pointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public Options(Pointer p) { super(p); }
      /** Native array allocator. Access with {@link Pointer#position(long)}. */
      public Options(long size) { super((Pointer)null); allocateArray(size); }
      private native void allocateArray(long size);
      @Override public Options position(long position) {
          return (Options)super.position(position);
      }
      @Override public Options getPointer(long i) {
          return new Options((Pointer)this).offsetAddress(i);
      }
  
    public Options() { super((Pointer)null); allocate(); }
    private native void allocate();
    // Alignment, in bytes, for tensor data.
    // Must be >= 1. The default size of 1 densely packs tensors.
    public native int data_alignment(); public native Options data_alignment(int setter);
  }
  public BundleWriter(Env env, @StringPiece BytePointer prefix,
                 @Const @ByRef(nullValue = "tensorflow::BundleWriter::Options()") Options options) { super((Pointer)null); allocate(env, prefix, options); }
  private native void allocate(Env env, @StringPiece BytePointer prefix,
                 @Const @ByRef(nullValue = "tensorflow::BundleWriter::Options()") Options options);
  public BundleWriter(Env env, @StringPiece BytePointer prefix) { super((Pointer)null); allocate(env, prefix); }
  private native void allocate(Env env, @StringPiece BytePointer prefix);
  public BundleWriter(Env env, @StringPiece String prefix,
                 @Const @ByRef(nullValue = "tensorflow::BundleWriter::Options()") Options options) { super((Pointer)null); allocate(env, prefix, options); }
  private native void allocate(Env env, @StringPiece String prefix,
                 @Const @ByRef(nullValue = "tensorflow::BundleWriter::Options()") Options options);
  public BundleWriter(Env env, @StringPiece String prefix) { super((Pointer)null); allocate(env, prefix); }
  private native void allocate(Env env, @StringPiece String prefix);

  // Adds the tensor "val" under key "key".
  // Across calls "key" must be unique but can be added in any order.
  public native @ByVal Status Add(@StringPiece BytePointer key, @Const @ByRef Tensor val);
  public native @ByVal Status Add(@StringPiece String key, @Const @ByRef Tensor val);

  // Partitioned variables support.
  // A slice of a full tensor is stored in two entries in the metadata table:
  //
  //   full_tensor_key   -> BundleEntryProto, describing all stored slices
  //                        of this full tensor.  Does not append to the data
  //                        file.
  //   encoded slice key -> BundleEntryProto, describing one particular slice.
  //                        Appends values of this slice to the data file.
  //
  // Slices of a full tensor can be added in any order.
  //
  // If a full tensor has slices placed on N devices and N BundleWriter's are
  // concurrently used, the caller must use MergeBundles() to ensure that a
  // consistent entry for "full_tensor_key" is produced.
  //
  // Returns an error if the same slice is added the second time.
  public native @ByVal Status AddSlice(@StringPiece BytePointer full_tensor_key,
                    @Const @ByRef TensorShape full_tensor_shape,
                    @Const @ByRef TensorSlice slice_spec, @Const @ByRef Tensor slice_tensor);
  public native @ByVal Status AddSlice(@StringPiece String full_tensor_key,
                    @Const @ByRef TensorShape full_tensor_shape,
                    @Const @ByRef TensorSlice slice_spec, @Const @ByRef Tensor slice_tensor);

  // Finishes the writer and flushes.
  public native @ByVal Status Finish();

  public native @ByVal Status status();
}
