// Targeted by JavaCPP version 1.5.6: DO NOT EDIT THIS FILE

package org.bytedeco.tensorflow;

import org.bytedeco.tensorflow.Allocator;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.tensorflow.global.tensorflow.*;


/** \defgroup state_ops State Ops
 *  \{
 <p>
 *  Update 'ref' by assigning 'value' to it.
 * 
 *  This operation outputs "ref" after the assignment is done.
 *  This makes it easier to chain operations that need to use the reset value.
 * 
 *  Arguments:
 *  * scope: A Scope object
 *  * ref: Should be from a {@code Variable} node. May be uninitialized.
 *  * value: The value to be assigned to the variable.
 * 
 *  Optional attributes (see {@code Attrs}):
 *  * validate_shape: If true, the operation will validate that the shape
 *  of 'value' matches the shape of the Tensor being assigned to.  If false,
 *  'ref' will take on the shape of 'value'.
 *  * use_locking: If True, the assignment will be protected by a lock;
 *  otherwise the behavior is undefined, but may exhibit less contention.
 * 
 *  Returns:
 *  * {@code Output}: = Same as "ref".  Returned as a convenience for operations that want
 *  to use the new value after the variable has been reset. */
@Namespace("tensorflow::ops") @NoOffset @Properties(inherit = org.bytedeco.tensorflow.presets.tensorflow.class)
public class Assign extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public Assign(Pointer p) { super(p); }

  /** Optional attribute setters for Assign */
  public static class Attrs extends Pointer {
      static { Loader.load(); }
      /** Default native constructor. */
      public Attrs() { super((Pointer)null); allocate(); }
      /** Native array allocator. Access with {@link Pointer#position(long)}. */
      public Attrs(long size) { super((Pointer)null); allocateArray(size); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public Attrs(Pointer p) { super(p); }
      private native void allocate();
      private native void allocateArray(long size);
      @Override public Attrs position(long position) {
          return (Attrs)super.position(position);
      }
      @Override public Attrs getPointer(long i) {
          return new Attrs((Pointer)this).offsetAddress(i);
      }
  
    /** If true, the operation will validate that the shape
     *  of 'value' matches the shape of the Tensor being assigned to.  If false,
     *  'ref' will take on the shape of 'value'.
     * 
     *  Defaults to true */
    
    ///
    public native @ByVal Attrs ValidateShape(@Cast("bool") boolean x);

    /** If True, the assignment will be protected by a lock;
     *  otherwise the behavior is undefined, but may exhibit less contention.
     * 
     *  Defaults to true */
    public native @ByVal Attrs UseLocking(@Cast("bool") boolean x);

    public native @Cast("bool") boolean validate_shape_(); public native Attrs validate_shape_(boolean setter);
    public native @Cast("bool") boolean use_locking_(); public native Attrs use_locking_(boolean setter);
  }
  public Assign(@Const @ByRef Scope scope, @ByVal Input ref,
         @ByVal Input value) { super((Pointer)null); allocate(scope, ref, value); }
  private native void allocate(@Const @ByRef Scope scope, @ByVal Input ref,
         @ByVal Input value);
  public Assign(@Const @ByRef Scope scope, @ByVal Input ref,
         @ByVal Input value, @Const @ByRef Attrs attrs) { super((Pointer)null); allocate(scope, ref, value, attrs); }
  private native void allocate(@Const @ByRef Scope scope, @ByVal Input ref,
         @ByVal Input value, @Const @ByRef Attrs attrs);
  public native @ByVal @Name("operator tensorflow::Output") Output asOutput();
  public native @ByVal @Name("operator tensorflow::Input") Input asInput();
  public native Node node();

  public static native @ByVal Attrs ValidateShape(@Cast("bool") boolean x);
  public static native @ByVal Attrs UseLocking(@Cast("bool") boolean x);

  public native @ByRef Operation operation(); public native Assign operation(Operation setter);
  public native @ByRef Output output_ref(); public native Assign output_ref(Output setter);
}
